

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetDocumentReportConfig.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_SetDocumentReportConfig')
BEGIN
	print '>>> Drop Stored Procedure: QS_SetDocumentReportConfig <<<'
	drop procedure QS_SetDocumentReportConfig
END
IF EXISTS (select * from GxQscripts where name='QS_SetDocumentReportConfig')
	delete from GxQscripts where name = 'QS_SetDocumentReportConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetDocumentReportConfig')
	delete from GXDBVersions where aliasname = 'QS_SetDocumentReportConfig'
GO
print '... Creating Procedure: QS_SetDocumentReportConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetDocumentReportConfig
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @param1 nvarchar(1024) = ''
AS
DECLARE @NoParams AS nvarchar(3)
DECLARE @ErrorCode AS int
DECLARE @ErrorString AS nvarchar(100)
DECLARE @ScriptName AS nvarchar(100)
DECLARE @nowtime as int
DECLARE @FilePath NVARCHAR(256) = ''
DECLARE @name NVARCHAR(MAX) = ''
DECLARE @description NVARCHAR(MAX) = ''
DECLARE @definition XML = ''
DECLARE @CreateTime INT
DECLARE @ModifiedTime INT
DECLARE @guid NVARCHAR(256) = ''
DECLARE @Date DATETIME = getdate()
DECLARE @xml XML
DECLARE @reportType INT
DECLARE @sql NVARCHAR(MAX) = ''
BEGIN TRY
    SET @NoParams = ''
    SET @ErrorCode = 0
    SET @ErrorString = N'Succeeded'
    SET @ScriptName = N'SetClientGroupIndexServer'
    SET @nowtime = dbo.GetUnixTime (GetUTCDate())
    --Check whether all params are passed--
    IF (@param1 = @NoParams)
    BEGIN
        SET @ErrorCode = 1
        SET @ErrorString = 'Invalid inputs. File Path is mandatory.'
        GOTO ARGS_ERROR
    END
    SET @FilePath = @param1
    IF (@FilePath <> '')
    BEGIN
    	IF OBJECT_ID('tempdb.dbo.#XML') IS NOT null DROP TABLE #XML
        CREATE TABLE #XML (xmlContent XML)
        SET @sql = 'INSERT INTO #XML SELECT CAST(BulkColumn AS XML) FROM OPENROWSET(BULK '''+@FilePath+''' , SINGLE_BLOB) x'
        EXEC(@sql)
        SET @xml = (SELECT TOP (1) xmlContent FROM #XML)
        SET @name = @xml.value('(WebReport_DocumentReportConfiguration/name)[1]', 'nvarchar(max)')
        SET @description = @xml.value('(WebReport_DocumentReportConfiguration/description)[1]', 'nvarchar(max)')
        SET @guid = @xml.value('(WebReport_DocumentReportConfiguration/guid)[1]', 'nvarchar(max)')
        SET @reportType = @xml.value('(WebReport_DocumentReportConfiguration/flags)[1]', 'int')
	IF @name is null OR (@name != (SELECT name from APP_DocumentReport WHERE guid = @guid))
	BEGIN
		return
	END
        IF (SELECT count(guid) from APP_DocumentReport WHERE guid = @guid)>0
        BEGIN
            UPDATE APP_DocumentReport
            SET modifiedTime = getdate(),
                definition = @xml
            WHERE guid = @guid
        END
        ELSE
        BEGIN
            INSERT INTO APP_DocumentReport (name, description, definition, createTime, modifiedTime, guid, reportType)values(@name,@description,@xml,@Date,@Date,@guid,@reportType)
        END
        DROP TABLE #XML
    END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = ERROR_MESSAGE()
    GOTO ARGS_ERROR
END CATCH
ARGS_ERROR:
    PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
         + ' with Parameters: ['+ @param1
         + ']. Exit Code(' +convert(varchar(2), @ErrorCode) + ').'
IF @ErrorCode <> 0
    Raiserror(@ErrorString,
                15,  --Severity (> 10 to force DOS Error Code = 1)
                1    --State
                )
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetDocumentReportConfig')
	delete from GxQscripts where name = 'QS_SetDocumentReportConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetDocumentReportConfig')
	delete from GXDBVersions where aliasname = 'QS_SetDocumentReportConfig'
GO

insert into GXDBVersions values(2, 'QS_SetDocumentReportConfig',  '00000000000000000000', 'QS_SetDocumentReportConfig', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetDocumentReportConfig',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '    qoperation execscript -sn SetDocumentReportConfig.sql [-si ''FilePath'']
'
 + CHAR(10) + '--   script_name: SetDocumentReportConfig'
 + CHAR(10) + '--   Qscript to set config xml file for document generation.'
)
GO

