

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetDeviceControllerProps.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SetDeviceControllerProps.sp,v $ $Id: QS_SetDeviceControllerProps.sp,v 1.5.12.3 2018/09/23 00:23:09 anarulkar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_SetDeviceControllerProps')
BEGIN
	print '>>> Drop Stored Procedure: QS_SetDeviceControllerProps <<<'
	drop procedure QS_SetDeviceControllerProps
END
IF EXISTS (select * from GxQscripts where name='QS_SetDeviceControllerProps')
	delete from GxQscripts where name = 'QS_SetDeviceControllerProps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetDeviceControllerProps')
	delete from GXDBVersions where aliasname = 'QS_SetDeviceControllerProps'
GO
print '... Creating Procedure: QS_SetDeviceControllerProps'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetDeviceControllerProps
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Defined operations listed here:
-- operation - 'SetPruner'
-- operation - 'GetPruner'
-- SP Input Params
  @i_operation varchar(100)='',
  @i_LibraryName nvarchar(1024)='',
  @i_MountPathName nvarchar(1024)='',
  @i_MediaAgentName nvarchar(1024)='',
  @i_DeviceName nvarchar(1024)=''
AS
Set NOCOUNT ON
	DECLARE @lastError	integer
	SET		@lastError	= 0
	DECLARE @libId		integer = 0
	DECLARE @mountPathId	integer = 0
	DECLARE @mediaAgentId	integer = 0
	DECLARE @mediaAgentName nvarchar(1024) = 'NoName'
	DECLARE @deviceId	integer = 0
	DECLARE @localErrorMsg	varchar(512)
	SET		@localErrorMsg	='Error Encountered when running script.'
	IF (@i_operation = 'SetPruner')
	BEGIN
		SET @libId = ISNULL((SELECT LibraryId FROM MMLibrary with (nolock) WHERE AliasName = @i_LibraryName), 0)
		SET @mountPathId = ISNULL((SELECT mountPathId FROM MMMountPath with (nolock) WHERE MountPathName = @i_MountPathName and LibraryId = @libId), 0)
		SET @mediaAgentId = ISNULL((SELECT H.clientId FROM MMHost H with (nolock), APP_Client C with (nolock)
						WHERE H.clientId = C.id AND C.name = @i_MediaAgentName), 0)
		IF @i_DeviceName <> ''
		BEGIN
			SET @deviceId	= ISNULL((SELECT TOP(1) D.DeviceId FROM MMDevice D WITH (NOLOCK), MMMountPathToStorageDevice MPSD WITH (NOLOCK), MMMountPath MP WITH (NOLOCK) WHERE D.AliasName = @i_DeviceName
						AND D.DeviceId = MPSD.DeviceId AND MPSD.MountPathId = MP.MountPathId AND MP.LibraryId = @libId), 0)
		END
		ELSE
		BEGIN
			SET @deviceId = ISNULL((SELECT TOP(1) DeviceId FROM MMMountPathToStorageDevice with (nolock) where MountPathId = @mountPathId), 0)
		END
		IF @libId = 0
		BEGIN
			SET @localErrorMsg = 'Error: Library Name is not found in database!'
			Set @lastError = 1
			goto   ARGS_ERROR
		END
		IF ((@mountPathId = 0) AND (@deviceId = 0))
		BEGIN
			SET @localErrorMsg = 'Error: MountPath Name OR Device Name is not found in database!'
			Set @lastError = 1
			goto   ARGS_ERROR
		END
		IF @mediaAgentId = 0
		BEGIN
			SET @localErrorMsg = 'Error: MediaAgent Name is not found in database!'
			Set @lastError = 1
			goto   ARGS_ERROR
		END
		IF NOT EXISTS (SELECT * FROM APP_Client APPC with (nolock), SimInstalledPackages PKG WITH (READUNCOMMITTED)
WHERE APPC.id = @mediaAgentId AND APPC.id = PKG.ClientId AND PKG.simPackageID IN (51, 1301)
AND ((APPC.ReleaseId > 15) OR ((APPC.ReleaseId >= 15) AND (PKG.HighestSP > 10))))
		BEGIN
			SET @localErrorMsg = 'Error: MediaAgent is on lesser version for enabling granular pruning on cloud. Please upgrade MediaAgent'
			SET @lastError = 1
			goto ARGS_ERROR
		END
		-- unset the flag on other deviceControllers first
		UPDATE MMDeviceController
SET UseCount = UseCount & ~(1)
		WHERE DeviceId = @deviceId
		UPDATE MMDeviceController
SET UseCount = UseCount | (1)
		WHERE DeviceId = @deviceId
		AND ClientId = @mediaAgentId
		IF @@ROWCOUNT = 0
		BEGIN
			SET @localErrorMsg = 'Error: failed to update deviceController for pruning!'
			Set @lastError = 1
			goto   ARGS_ERROR
		END
		SELECT ''
	END
	ELSE IF (@i_operation = 'GetPruner')
	BEGIN
		SET @libId = ISNULL((SELECT LibraryId FROM MMLibrary with (nolock) WHERE AliasName = @i_LibraryName), 0)
		SET @mountPathId = ISNULL((SELECT mountPathId FROM MMMountPath with (nolock) WHERE MountPathName = @i_MountPathName and LibraryId = @libId), 0)
		IF @i_DeviceName <> ''
		BEGIN
			SET @deviceId = ISNULL((SELECT TOP(1) D.DeviceId FROM MMDevice D WITH (NOLOCK), MMMountPathToStorageDevice MPSD WITH (NOLOCK), MMMountPath MP WITH (NOLOCK) WHERE D.AliasName = @i_DeviceName
							AND D.DeviceId = MPSD.DeviceId AND MPSD.MountPathId = MP.MountPathId AND MP.LibraryId = @libId), 0)
			SET @mediaAgentName = ISNULL((SELECT C.name
						FROM MMDeviceController DC with (nolock),
						APP_Client C with (nolock)
						WHERE DC.DeviceId = @deviceId
						AND DC.ClientId = C.id
AND DC.UseCount & 1 > 0), 'NoName')
		END
		ELSE
		BEGIN
			SET @mediaAgentName = ISNULL((SELECT C.name
						FROM MMMountPathToStorageDevice MPD with (nolock),
						MMDeviceController DC with (nolock),
						APP_Client C with (nolock)
						WHERE MPD.MountPathId = @mountPathId
						AND MPD.DeviceId = DC.DeviceId
						AND DC.ClientId = C.id
AND DC.UseCount & 1 > 0), 'NoName')
		END
		SELECT @mediaAgentName
	END
ARGS_ERROR:
	if @lastError <> 0
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetDeviceControllerProps')
	delete from GxQscripts where name = 'QS_SetDeviceControllerProps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetDeviceControllerProps')
	delete from GXDBVersions where aliasname = 'QS_SetDeviceControllerProps'
GO

insert into GXDBVersions values(2, 'QS_SetDeviceControllerProps',  '00010005001200030000', 'QS_SetDeviceControllerProps', '00010005001200030000')
GO

insert into GxQscripts values(2,'QS_SetDeviceControllerProps',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetDeviceControllerProps -si operation -si LibraryName -si MountPathName -si MediaAgentName -si DeviceName
'
 + CHAR(10) + '	operation  SetPruner / GetPruner
'
 + CHAR(10) + '	SetPruner  To set an MA as pruner for library/MountPath. Previous MA will be unset automatically.
'
 + CHAR(10) + '	GetPruner  Given Library and MountPath name, it gets the MediaAgent client name which is set as pruner
'
 + CHAR(10) + '	LibraryName - Name of library for which pruner MA is set/get.
'
 + CHAR(10) + '	MountPathName - Name of mountPath for which pruner MA is set/get.
'
 + CHAR(10) + '	MediaAgentName - Name of mediaagent which is set as pruner.
'
 + CHAR(10) + '	DeviceName - Use device name if mountpath name is not unique
'
)
GO

