

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetDefaultSCContent.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetDefaultSCContent <<<'

IF EXISTS (select * from sysobjects where name='QS_SetDefaultSCContent')
	drop procedure QS_SetDefaultSCContent
IF EXISTS (select * from GxQscripts where name='QS_SetDefaultSCContent')
	delete from GxQscripts where name = 'QS_SetDefaultSCContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetDefaultSCContent')
	delete from GXDBVersions where aliasname = 'QS_SetDefaultSCContent'
GO
print '... Creating Procedure: QS_SetDefaultSCContent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetDefaultSCContent
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @CLIENTNAME varchar(1024) = '%s',
  @listofPaths varchar(1024) = '%s',
  @DELIM varchar(1024) = '%s',
  @BACKUPSETNAME varchar(1024) = '%s'
AS
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
-----------------------------------------------------
-- GET THE FOLLOWING FROM THE QSCRIPT COMMAND LINE --
-----------------------------------------------------
--DECLARE @CLIENTNAME     varchar(1024)
--DECLARE @listOfPaths	varchar(2048)
--DECLARE @DELIM			varchar(2)
--DECLARE @BACKUPSETNAME  varchar(1024)
--SET		@ClientName		= '%s'
--SET		@listOfPaths	= '%s'
--SET		@DELIM			= '%s'
--SET		@BACKUPSETNAME	= '%s'
------- TEST DATA (FAKE OUT QSCRIPT  -----------------
--SET   @CLIENTNAME = 'jewelfish_cn'
--SET	@BACKUPSETNAME = 'defaultBackupSet'
--SET   @DELIM       = ';'
--SET	@listOfPaths = 'C:\;d:\tmp;e:\DB_Backups;f:\;c:\tmp'
--SET	@listOfPaths = 'C:\'
--SET	@listOfPaths = '\;d:\'
------------------------------------------------------
DECLARE @subClientName varchar(1024)
DECLARE @clientId    integer
DECLARE @backupSetId integer
DECLARE @subClientId	integer
DECLARE @thisPath		varchar(1024)
DECLARE @inStrLen       int
DECLARE @nextSeper		int
-------------  Convenience Definitions  ---------------------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'SetDefaultSCContent'
DECLARE @NoParameter            varchar(10)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @nowTime   integer
SET		@nowTime  =   dbo.GetUnixTime (GetUTCdate())DECLARE @srcSubClientID   int
DECLARE @hasStatusBits  integer
SET		@hasStatusBits = 8						-- Default SubClient
DECLARE @notStatusBits  integer
SET		@notStatusBits = 4+2					-- DELETED, UNINSTALLED
DECLARE @lastError		int
SET		@lastError = 1							-- Be pessimistic
DECLARE	@errorString	varchar(1024)
set		@errorString = 'Error encountered when running script'
DECLARE @describeSC		varchar(1024)
set		@describeSC  = 'Unknown SubClient'
--------------------------------------
-- CHECK FOR MINIMUM ARGS, SET		--
-- .. DEFAULTS, AS REQUIRED			--
--------------------------------------
IF @ClientName = @NoParameter
BEGIN
	SET @errorString = 'Error. No Client specified.'
	GOTO ARGS_ERROR
END
IF @listOfPaths = @NoParameter
BEGIN
	SET @errorString = 'Error. No Content specified.'
	GOTO ARGS_ERROR
END
IF @DELIM = @NoParameter
BEGIN
	SET @DELIM = ';'
	PRINT 'Setting Delimiter to default [' + @DELIM + '].'
END
IF @BACKUPSETNAME = @NoParameter
BEGIN
	SET @BACKUPSETNAME = 'defaultBackupSet'
	PRINT 'Setting BackupSetName to default [' + @BACKUPSETNAME + '].'
END
PRINT Convert(varchar(60), getdate()) +' [Start] '+ @scriptName +' {' + @clientName  +'}, {' +@listOfPaths + '}, {' +@DELIM + '}, {' +@BackupSetName + '}'
--------------------------------------
-- Figure Out ClientId from name:	--
--------------------------------------
SET @clientId     = (Select id from APP_CLIENT where name = @CLIENTNAME)
IF @clientId is NulL
	BEGIN
		Set @errorString = 'No Client with name ['+@ClientName+'] exists.'
		goto ARGS_ERROR
	END
--------------------------------------------------
-- Figure out BackupSetId from name:			--
-- .. Not as easy as clientId,backupSet names	--
-- .. are not necessarily unique Commcell-wide	--
--------------------------------------------------
SET @backupSetId = (Select DISTINCT BSN.id from APP_BACKUPSETNAME AS BSN, APP_APPLICATION AS APP
                      where
						APP.clientId = @clientId
						AND APP.backupSet = BSN.id
						AND BSN.name = @BACKUPSETNAME
						AND appTypeId in (1,11,12,17,18,19,20,21,28,29,36,33,34,36,38,42,43,63,64,74,86)
						)
IF @backupSetId is NulL
	BEGIN
		SET @errorString = 'No backupset with name ['+@BACKUPSETNAME+'] exists.'
		goto ARGS_ERROR
	END
--------------------------------------------------
-- Now we can determine the id for the default	--
-- SubClient for this Client/Backupset			--
--------------------------------------------------
SET @subClientId = (Select id from APP_APPLICATION
		 WHERE clientId = @clientId
		  AND  backupSet = @backupSetId
          AND  appTypeId in (1,11,12,17,18,19,20,21,28,29,36,33,34,36,38,42,43,63,64,74,86)
		  AND (subClientStatus & @hasStatusBits) <> 0
		  AND (subClientStatus & @notStatusBits) =  0
		)
IF @subClientId is NulL
	BEGIN
		SET @errorString= 'No Active default subClient for client['+@CLIENTNAME+ '], backupset['+@BACKUPSETNAME+'].'
		goto ARGS_ERROR
	END
SET @subClientName = (select subClientName from APP_APPLICATION where id = @subClientId)
SET @describeSC = '[' +@clientName + '(FS)-->' + @backupsetName + '-->' +@subClientName + '{'+convert(varchar(10), @subClientId) + '}]'
---
 PRINT  'Processing content for ' +@describeSC
--SELECT 'step'= 'pre clear', * FROM APP_SCFILTERFILE WHERE COMPONENTNAMEID = @SUBCLIENTID
BEGIN TRAN
---------------------------------------------
--	AGE ALL OLD CONTENT FOR THIS SUBCLIENT --
---------------------------------------------
	UPDATE APP_SCFILTERFILE
		SET modified = @nowTime
			WHERE COMPONENTNAMEID = @subClientId AND Modified = 0 AND Type = 1
	SET @lastError = @@error
	IF @lastError <> 0
	BEGIN
		SET @errorString = 'Error. Could not age content for ' +@describeSC
		GOTO TRANS_EXIT
	END
-------------------------------------------------------------
-- PARSE LIST OF PATHS. IF THEY DON'T EXIST AS CONTENT FOR --
-- ANY OTHER SUBLCIENT IN THE BACKUPSET, OK TO ADD IT IN   --
-- TO THE DEFAULT SUBCLIENT								   --
-------------------------------------------------------------
print 'debug DELIM ['+@DELIM+']'
SET  @inStrLen   = LEN(@listOfPaths)
IF @inStrLen > 0
BEGIN
    WHILE (LEN(@listOfPaths) > 0)
    BEGIN
		SET @nextSeper   = CHARINDEX(@DELIM, @listOfPaths, 1)
		IF @nextSeper = 0
		BEGIN
			SET @listOfPaths = @listOfPaths+@DELIM
			SET @nextSeper = @instrlen+1
		END
        SET @thisPath    = RTRIM(LTRIM(SUBSTRING(@listOfPaths, 1, @nextSeper-1)))
		IF EXISTS (SELECT * FROM APP_SCFILTERFILE AS SCF, APP_APPLICATION AS APP
				WHERE APP.ClientId = @clientId
				  AND APP.backupSet = @backupSetId
				  AND  appTypeId in (1,11,12,17,18,19,20,21,28,29,36,33,34,36,38,42,43,63,64,74,86)
		          AND (subClientStatus & @notStatusBits) =  0
                  AND SCF.modified = 0
				  --AND SCF.componentNameId <> @subClientId
                  AND SCF.componentNameId = APP.id
				  AND SCF.Filename =  @thisPath
				  AND SCF.type in (1, 3)
				)
		BEGIN
			SET @errorString = 'Cannot Add path ['+@thisPath+'] to default subClient.  It already exists in another subClient'
			set @lastError = 1
			goto TRANS_EXIT
		END
		ELSE
		BEGIN
			INSERT APP_SCFILTERFILE(componentNameId,type,fileName,created,modified)
				VALUES (@subClientId, 1, @thisPath, @nowTime, 0)
			SET @lastError = @@error
			IF @lastError <> 0
			BEGIN
				SET @errorString = 'Error. Could not add content[' +@thisPath +'] to ' +@describeSC
				GOTO TRANS_EXIT
			END
			PRINT '.. adding Path ['+@thisPath+']'
		END
--      SET UP TO GET NEXT PATH IN THE LIST:
--      --------------------------------------
        IF (@inStrLen - @nextSeper <= 0)
            BREAK
        SET @listOfPaths = SUBSTRING(@listOfPaths, @nextSeper+1, @inStrLen-@nextSeper)
        SET @inStrLen = LEN(@listOfPaths)
    END
END
TRANS_EXIT:
IF @LastError <> 0
	ROLLBACK TRAN
ELSE
BEGIN
COMMIT TRAN
--ROLLBACK TRAN				-- (Use rollback for debugging purposes!)
END
PRINT Convert(varchar(60), getdate()) +' [Complete] '+ @scriptName + '. Exit Code(' +convert(varchar(2), @lastError) + ').'
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
	)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetDefaultSCContent')
	delete from GxQscripts where name = 'QS_SetDefaultSCContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetDefaultSCContent')
	delete from GXDBVersions where aliasname = 'QS_SetDefaultSCContent'
GO

insert into GXDBVersions values(2, 'QS_SetDefaultSCContent',  '00000000000000000000', 'QS_SetDefaultSCContent', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetDefaultSCContent',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetDefaultSCContent.sql -si clientname -si listofpaths [-si delimiter] [-si backupsetName]
'
 + CHAR(10) + '--   script_name : SetDefaultSCContent'
)
GO

