

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetDedupProp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SetDedupProp.sp,v $ $Id: QS_SetDedupProp.sp,v 1.3.210.2 2018/03/20 00:08:51 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetDedupProp <<<'

IF EXISTS (select * from sysobjects where name='QS_SetDedupProp')
	drop procedure QS_SetDedupProp
IF EXISTS (select * from GxQscripts where name='QS_SetDedupProp')
	delete from GxQscripts where name = 'QS_SetDedupProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetDedupProp')
	delete from GXDBVersions where aliasname = 'QS_SetDedupProp'
GO
print '... Creating Procedure: QS_SetDedupProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetDedupProp
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @i_clientNameParam NVARCHAR(25)='',
  @i_singleInstancingParam INTEGER=0,
  @i_getDedupProp INTEGER=0
AS
Set NOCOUNT ON
	-- Single Instancing Propery Values
	-- --------------------------------
	-- 0 - No Single Instancing		CV_SINGLE_INSTANCING_OFF_VAL
	-- 1 - On Client Side			CV_SINGLE_INSTANCING_CLIENT_VAL
	-- 2 - On Media Agent			CV_SINGLE_INSTANCING_MA_VAL
	-- Variables to hold the values from App_SubClientProp Table Row
	DECLARE @C_CV_SI_OPTION NVARCHAR(32)
	DECLARE @C_SC_USING_SC_POLICY NVARCHAR(32)
	DECLARE @C_CV_APPTYPE_SC_POLICY integer
	DECLARE @C_CV_INT_PROPERTY integer
	DECLARE @C_ALL_SUBCLIENTS NVARCHAR(32)
	DECLARE @C_ALL_SC_POLICIES NVARCHAR(32)
	-- CV_SINGLE_INSTANCING_OPTION
	SET @C_CV_SI_OPTION = N'Single Instancing Option'
	-- Sub Client Policy
	SET @C_SC_USING_SC_POLICY = N'Associated subclient Policy'
	-- Sub Client Policy App Type Id
	SET @C_CV_APPTYPE_SC_POLICY = 1030
	-- PROPERTY_INTEGER
	SET @C_CV_INT_PROPERTY = 7
	-- All Subclients
	SET @C_ALL_SUBCLIENTS = N'__AllSubClients__'
	-- All Subclient Policies
	SET @C_ALL_SC_POLICIES = N'__AllSCPolicies__'
	DECLARE @id INTEGER
	DECLARE @componentNameId INTEGER
	DECLARE @attrName NVARCHAR(1024);
	DECLARE @attrType INTEGER
	DECLARE @attrVal NVARCHAR(MAX)
	DECLARE @created INTEGER
	DECLARE @modified INTEGER
	-- Variable used for getting & setting the Current Date Time Stamp
	-- (as count of seconds, rather than as a string)
	DECLARE @nowTime INTEGER
	SET		@nowTime = dbo.GetUnixTime(GetUTCdate())
	-- Variables to hold the Error Number & Error Message
	DECLARE @ErrorNumber INTEGER
	DECLARE @ErrorMessage NVARCHAR(MAX)
	IF LEN(@i_clientNameParam) = 0
	BEGIN
		SET @ErrorMessage = N'Client Name is empty'
		SET @ErrorNumber = 1
		GOTO	QS_ERROR
	END
	IF NOT EXISTS (SELECT Id FROM APP_Client WHERE Name = @i_clientNameParam)
			AND @C_ALL_SUBCLIENTS != @i_clientNameParam
			AND @C_ALL_SC_POLICIES != @i_clientNameParam
	BEGIN
		SET @ErrorMessage = N'Client Name is invalid'
		SET @ErrorNumber = 2
		GOTO	QS_ERROR
	END
	IF @i_singleInstancingParam < 0 OR @i_singleInstancingParam > 2
	BEGIN
		SET @ErrorMessage = N'Dedup Parameter is invalid -- 0-Disable   1-Enable on client side   2-Enable on ma side'
		SET @ErrorNumber = 3
		GOTO	QS_ERROR
	END
	DECLARE @tmpSubClients TABLE (componentNameId integer)
	DECLARE @tmpSubClientList TABLE (subclientId integer, subClientName nvarchar(128), clientId integer, clientName nvarchar(255))
	IF (@i_getDedupProp = 0)
	BEGIN
		-- Setting Dedup property for all subclients (excluding those associated with Subclient Policy)
		IF @i_clientNameParam = @C_ALL_SUBCLIENTS
		BEGIN
			INSERT INTO @tmpSubClients
			SELECT DISTINCT ComponentNameId FROM App_SubClientProp
			Delete FROM @tmpSubClients
			WHERE componentNameId in
				(SELECT DISTINCT ComponentNameId FROM App_SubClientProp
				WHERE AttrName = @C_SC_USING_SC_POLICY AND Modified = 0)
			Delete FROM @tmpSubClients
			WHERE componentNameId in
				(SELECT DISTINCT Id FROM App_Application WHERE AppTypeId = @C_CV_APPTYPE_SC_POLICY)
			UPDATE App_SubClientProp
			SET Modified = @nowTime
			WHERE
				ComponentNameId in (SELECT componentNameId FROM @tmpSubClients) AND
				AttrName = @C_CV_SI_OPTION AND
				Modified = 0
			INSERT INTO App_SubClientProp (ComponentNameId, AttrName, AttrType, AttrVal, Created, Modified)
			SELECT Id, @C_CV_SI_OPTION, @C_CV_INT_PROPERTY, @i_singleInstancingParam, @nowTime, 0
			FROM App_Application
			WHERE Id in (SELECT componentNameId FROM @tmpSubClients)
		END
		-- Setting Dedup property for all subclient policies
		ELSE IF @i_clientNameParam = @C_ALL_SC_POLICIES
		BEGIN
			INSERT INTO @tmpSubClients
			SELECT DISTINCT Id FROM App_Application WHERE AppTypeId = @C_CV_APPTYPE_SC_POLICY
			UPDATE App_SubClientProp
			SET Modified = @nowTime
			WHERE
				ComponentNameId in (SELECT componentNameId FROM @tmpSubClients) AND
				AttrName = @C_CV_SI_OPTION AND
				Modified = 0
			INSERT INTO App_SubClientProp (ComponentNameId, AttrName, AttrType, AttrVal, Created, Modified)
			SELECT Id, @C_CV_SI_OPTION, @C_CV_INT_PROPERTY, @i_singleInstancingParam, @nowTime, 0
			FROM App_Application
			WHERE Id in (SELECT componentNameId FROM @tmpSubClients)
		END
		-- Setting Dedup property for all subclients of a client
		ELSE
		BEGIN
			INSERT INTO @tmpSubClients
			SELECT DISTINCT ComponentNameId FROM App_SubClientProp
			WHERE componentNameId in (SELECT Id FROM App_Application
				WHERE clientId = (SELECT Id FROM App_Client WHERE Name = @i_clientNameParam))
			Delete FROM @tmpSubClients
			WHERE componentNameId in
				(SELECT DISTINCT ComponentNameId FROM App_SubClientProp
				WHERE componentNameId in (SELECT Id FROM App_Application
					WHERE clientId = (SELECT Id FROM App_Client WHERE Name = @i_clientNameParam)) AND
						AttrName = @C_SC_USING_SC_POLICY AND Modified = 0)
			UPDATE App_SubClientProp
			SET Modified = @nowTime
			WHERE
				ComponentNameId in (SELECT componentNameId FROM @tmpSubClients) AND
				AttrName = @C_CV_SI_OPTION AND
				Modified = 0
			INSERT INTO App_SubClientProp (ComponentNameId, AttrName, AttrType, AttrVal, Created, Modified)
			SELECT Id, @C_CV_SI_OPTION, @C_CV_INT_PROPERTY, @i_singleInstancingParam, @nowTime, 0
			FROM App_Application
			WHERE Id in (SELECT componentNameId FROM @tmpSubClients)
		END
	END
	ELSE
	BEGIN
			IF @i_clientNameParam <> @C_ALL_SUBCLIENTS AND @i_clientNameParam <> @C_ALL_SC_POLICIES
			BEGIN
				INSERT INTO @tmpSubClients
				SELECT DISTINCT ComponentNameId FROM App_SubClientProp
				WHERE componentNameId in (SELECT Id FROM App_Application
					WHERE clientId = (SELECT Id FROM App_Client WHERE Name = @i_clientNameParam))
				AND AttrName = @C_CV_SI_OPTION AND
                        Modified = 0
				INSERT INTO @tmpSubClientList
				SELECT APP.id, APP.subclientName, APP.clientId, CLT.name
				FROM APP_Application APP INNER JOIN APP_Client CLT
                ON APP.clientId = CLT.id
				WHERE APP.id in (SELECT componentNameId from @tmpSubClients)
				SELECT * from @tmpSubClientList
			END
			ELSE
			BEGIN
				INSERT INTO @tmpSubClients
				SELECT DISTINCT ComponentNameId FROM App_SubClientProp
				WHERE AttrName = @C_CV_SI_OPTION AND
                        Modified = 0
				INSERT INTO @tmpSubClientList
				SELECT APP.id, APP.subclientName, APP.clientId, CLT.name
				FROM APP_Application APP INNER JOIN APP_Client CLT
                ON APP.clientId = CLT.id
				WHERE APP.id in (SELECT componentNameId from @tmpSubClients)
				SELECT * from @tmpSubClientList
			END
	END
QS_ERROR:
	IF @ErrorNumber <> 0
		Raiserror(@ErrorMessage,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetDedupProp')
	delete from GxQscripts where name = 'QS_SetDedupProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetDedupProp')
	delete from GXDBVersions where aliasname = 'QS_SetDedupProp'
GO

insert into GXDBVersions values(2, 'QS_SetDedupProp',  '00010003021000020000', 'QS_SetDedupProp', '00010003021000020000')
GO

insert into GxQscripts values(2,'QS_SetDedupProp',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		qoperation execscript -sn SetDedupProp -si clientName -si singleInstancingParam'
)
GO

