

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetDeconfClientName.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetDeconfClientName <<<'

IF EXISTS (select * from sysobjects where name='QS_SetDeconfClientName')
	drop procedure QS_SetDeconfClientName
IF EXISTS (select * from GxQscripts where name='QS_SetDeconfClientName')
	delete from GxQscripts where name = 'QS_SetDeconfClientName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetDeconfClientName')
	delete from GXDBVersions where aliasname = 'QS_SetDeconfClientName'
GO
print '... Creating Procedure: QS_SetDeconfClientName'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetDeconfClientName
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @CLIENTNAME varchar(1024) = '%s',
  @NEWNAME varchar(512) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
--INPUTS
-------------------------------------------
--DECLARE @CLIENTNAME     varchar(1024)
--SET @CLIENTNAME ='%s'
--DECLARE @NEWNAME		varchar(512)
--SET @NEWNAME = '%s'
--------------------------
--SET @CLIENTNAME = 'bingo'
--SET @NEWNAME = 'Bingo'
---------------------------
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'SetDeconfClientName'
DECLARE @STATUS_BIT        integer
SET		@STATUS_BIT        =  2					-- CV_STATUS_UNINSTALLED
DECLARE @NoParameter            varchar(10)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
--DECLARE @MAX_ENTITY_SIZE		smallint
--SET @MAX_ENTITY_SIZE			= 100
---------VAlidate inputs   ----------
IF(@CLIENTNAME = @NoParameter)
BEGIN
	SET @lastError = 1
	SET @localErrorMsg  = 'Error. No client was not given as input.'
	GOTO ARGS_ERROR
END
IF(@NEWNAME = @NoParameter)
BEGIN
	SET @lastError = 1
	SET @localErrorMsg  = 'Error. New client name was not given as input.'
	GOTO ARGS_ERROR
END
DECLARE @clientId int
DECLARE @status int
SELECT @clientId = id, @status = status FROM APP_Client WHERE name like @CLIENTNAME
IF @clientId is NULL
BEGIN
	SET @lastError = 1
	SET @localErrorMsg  = 'Error. Client ['+@CLIENTNAME+'] not found.'
	GOTO ARGS_ERROR
END
IF (@status & @STATUS_BIT) <> @STATUS_BIT
BEGIN
	SET @lastError = 1
	SET @localErrorMsg  = 'Error. Client ['+@CLIENTNAME+'] cannot be renamed. It is not deconfigured. Deconfigure the client and try again or use the name change utility.'
	GOTO ARGS_ERROR
END
IF (LEN(@NEWNAME ) > 100)
BEGIN
	SET @lastError = 1
SET @localErrorMsg = 'Error. Client Name cannot be more than ' + CAST(100 AS varchar(3)) + ' characters.'
	GOTO ARGS_ERROR
END
------------ Rename client  ----------
UPDATE App_Client SET name = @NEWNAME WHERE id = @clientId
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: client = ['
         + @CLIENTNAME
         + '], new client name ['
		 + @NEWNAME
		 +'] Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetDeconfClientName')
	delete from GxQscripts where name = 'QS_SetDeconfClientName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetDeconfClientName')
	delete from GXDBVersions where aliasname = 'QS_SetDeconfClientName'
GO

insert into GXDBVersions values(2, 'QS_SetDeconfClientName',  '00000000000000000000', 'QS_SetDeconfClientName', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetDeconfClientName',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetDeconfClientName.sql -si old_client_name -si new_client_name
'
 + CHAR(10) + '--   script_name : SetDeconfClientName'
)
GO

