

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetDataPathProperty.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SetDataPathProperty.sp,v $ $Id: QS_SetDataPathProperty.sp,v 1.3.76.3 2018/03/20 00:17:49 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetDataPathProperty <<<'

IF EXISTS (select * from sysobjects where name='QS_SetDataPathProperty')
	drop procedure QS_SetDataPathProperty
IF EXISTS (select * from GxQscripts where name='QS_SetDataPathProperty')
	delete from GxQscripts where name = 'QS_SetDataPathProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetDataPathProperty')
	delete from GXDBVersions where aliasname = 'QS_SetDataPathProperty'
GO
print '... Creating Procedure: QS_SetDataPathProperty'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetDataPathProperty
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_Option varchar(1024) = '', -- 'HardwareEncryption'
  @i_target varchar(1024) = '',	-- 'SP-Copy', 'All', 'Lib-MA','datapath'
  @i_param1 varchar(1024) = '',	-- (SP-Copy -> SP Name), (Lib-MA -> Library Name), (datapath -> SP Name)
  @i_param2 varchar(1024) = '',	-- (SP-Copy -> SP Copy Name), (Lib-MA -> MA Name), (datapath -> SP Copy Name)
  @i_param3 varchar(1024) = '',	-- (datapath -> MA name)
  @i_param4 varchar(1024) = '',	-- (datapath -> Library name)
  @i_param5 varchar(1024) = '',	-- (datapath -> Drivepool)
  @i_param6 varchar(1024) = '',	-- (datapath -> scratchpool)
  @i_param7 varchar(1024) = ''	-- option value (HardwareEncryption -> 0-HWEncDisabled, 1-HWEncViaMediaPass, 2-HWEncNoAccess)
AS
SET NOCOUNT ON
--------------------------------------------
-- Local Variables --
--------------------------------------------
DECLARE @lastError	integer
SET		@lastError	= 0
DECLARE @localErrorMsg	varchar(512)
SET		@localErrorMsg	=''
DECLARE @rowCount	integer = 0
DECLARE @option_Value varchar(1024)
DECLARE @tmpDataPath TABLE
(
	DataPathId		INTEGER NOT NULL,
	copyId			INTEGER,
	hostClientId	INTEGER,
	drivePoolId		INTEGER,
	spareGroupId	INTEGER
)
--Validate the input option
IF(LOWER(@i_Option) <> 'hardwareencryption')
BEGIN
	SET @localErrorMsg = 'Error: invalid option '''+ @i_Option+'''.'
	SET @lastError = 1
	GOTO   ARGS_ERROR
END
-- Validate the target datapaths
IF( LOWER(@i_target)  <> 'sp-copy' AND LOWER(@i_target) <> 'all' AND LOWER(@i_target) <> 'lib-ma' AND LOWER(@i_target) <> 'datapath')
BEGIN
	SET @localErrorMsg = 'Error: invalid target '''+ @i_target+'''.'
	SET @lastError = 1
	GOTO   ARGS_ERROR
END
IF(LOWER(@i_target) = 'sp-copy')
BEGIN
	-- Validations
	IF(rtrim(@i_param1) = '' OR rtrim(@i_param2) = '' OR rtrim(@i_param3) = '' )
	BEGIN
		SET @localErrorMsg = 'Error: '+@i_target+' input parameters not valid.'
		SET @lastError = 1
		GOTO   ARGS_ERROR
	END
	IF NOT EXISTS (SELECT * FROM archGroup WITH (NOLOCK) WHERE name = @i_param1)
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Storage Policy by name [' +@i_param1 +'] not found.'
		GOTO ARGS_ERROR
	END
	IF NOT EXISTS (SELECT * FROM archGroup AG WITH (NOLOCK) INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AG.id = AGC.archGroupId WHERE AG.name = @i_param1 AND AGC.name = @i_param2)
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Storage Policy Copy by name [' +@i_param2 +'] not found.'
		GOTO ARGS_ERROR
	END
	SET @option_Value = @i_param3
	INSERT INTO	@tmpDataPath
	SELECT		DP.DataPathId,DP.CopyId,DP.HostClientId,DP.DrivePoolId,DP.SpareGroupId
	FROM		MMDataPath AS DP WITH (NOLOCK)
	INNER JOIN	archGroupCopy AS AGC WITH (NOLOCK) ON DP.CopyId = AGC.id
	INNER JOIN	archGroup AS AG WITH (NOLOCK) ON AG.id = AGC.archGroupId
	WHERE		AG.name = @i_param1
				AND AGC.name = @i_param2
END
ELSE IF (LOWER(@i_target) = 'all')
BEGIN
	SET @option_Value = @i_param1
	INSERT INTO	@tmpDataPath
	SELECT		DP.DataPathId,DP.CopyId,DP.HostClientId,DP.DrivePoolId,DP.SpareGroupId
	FROM		MMDataPath AS DP WITH (NOLOCK)
END
ELSE IF (LOWER(@i_target) = 'lib-ma')
BEGIN
	-- Validations
	IF(rtrim(@i_param1) = '' OR rtrim(@i_param2) = '' )
	BEGIN
		SET @localErrorMsg = 'Error: '+@i_target+' input parameters not valid.'
		SET @lastError = 1
		GOTO   ARGS_ERROR
	END
	IF NOT EXISTS (SELECT * FROM MMLibrary WITH (NOLOCK) WHERE aliasName = @i_param1)
	BEGIN
		SET @localErrorMsg = 'Error: Library by name [' + @i_param1 +'] not found.'
		SET @lastError = 1
		GOTO   ARGS_ERROR
	END
	IF NOT EXISTS (SELECT * FROM app_client AC WITH (NOLOCK), MMHost MH WITH (NOLOCK) WHERE  AC.id = MH.clientid AND AC.name = @i_param2)
	BEGIN
		SET @localErrorMsg = 'Error: Media Agent by name [' + @i_param2 +'] not found.'
		SET @lastError = 1
		GOTO   ARGS_ERROR
	END
	SET @option_Value = @i_param3
	INSERT INTO	@tmpDataPath
	SELECT		DP.DataPathId,DP.CopyId,DP.HostClientId,DP.DrivePoolId,DP.SpareGroupId
	FROM		MMDataPath AS DP WITH (NOLOCK)
	INNER JOIN	MMDrivePool DRP WITH (NOLOCK) ON DP.DrivePoolId = DRP.DrivePoolId
	INNER JOIN	MMMasterPool MP WITH (NOLOCK) ON MP.MasterPoolId = DRP.MasterPoolId
	INNER JOIN	MMLibrary L WITH (NOLOCK) ON L.LibraryId = MP.LibraryId
	INNER JOIN	APP_Client CLNT WITH (NOLOCK) ON CLNT.id = DP.HostClientId
	WHERE		CLNT.name = @i_param2 AND L.AliasName = @i_param1
END
ELSE IF (LOWER(@i_target) = 'datapath')
BEGIN
	IF(rtrim(@i_param1) = '' OR rtrim(@i_param2) = '' OR rtrim(@i_param3) = '' OR rtrim(@i_param4) = '' OR rtrim(@i_param5) = '' OR rtrim(@i_param6) = '' )
	BEGIN
		SET @localErrorMsg = 'Error: '+@i_target+' input parameters not valid.'
		SET @lastError = 1
		GOTO   ARGS_ERROR
	END
	IF NOT EXISTS (SELECT * FROM archGroup WITH (NOLOCK) WHERE name = @i_param1)
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Storage Policy by name [' +@i_param1 +'] not found.'
		GOTO ARGS_ERROR
	END
	IF NOT EXISTS (SELECT * FROM archGroup AG WITH (NOLOCK) INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AG.id = AGC.archGroupId WHERE AG.name = @i_param1 AND AGC.name = @i_param2)
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Storage Policy Copy by name [' +@i_param2 +'] not found.'
		GOTO ARGS_ERROR
	END
	IF NOT EXISTS (SELECT * FROM app_client AC WITH (NOLOCK), MMHost MH WITH (NOLOCK) WHERE  AC.id = MH.clientid AND AC.name = @i_param3)
	BEGIN
		SET @localErrorMsg = 'Error: Media Agent by name [' + @i_param3 +'] not found.'
		SET @lastError = 1
		GOTO   ARGS_ERROR
	END
	IF NOT EXISTS (SELECT * FROM MMLibrary WITH (NOLOCK) WHERE aliasName = @i_param4)
	BEGIN
		SET @localErrorMsg = 'Error: Library by name [' + @i_param4 +'] not found.'
		SET @lastError = 1
		GOTO   ARGS_ERROR
	END
	IF NOT EXISTS (SELECT * FROM MMDrivePool WITH(NOLOCK) WHERE DrivePoolName = @i_param5)
	BEGIN
		SET @localErrorMsg = 'Error: Drive pool by name [' + @i_param5 +'] not found.'
		SET @lastError = 1
		GOTO   ARGS_ERROR
	END
	IF NOT EXISTS (SELECT * FROM MMSpareGroup WITH(NOLOCK) WHERE SpareGroupName = @i_param6)
	BEGIN
		SET @localErrorMsg = 'Error: Scratch pool by name [' + @i_param6 +'] not found.'
		SET @lastError = 1
		GOTO   ARGS_ERROR
	END
	SET @option_Value = @i_param7
	INSERT INTO	@tmpDataPath
	SELECT		DP.DataPathId,DP.CopyId,DP.HostClientId,DP.DrivePoolId,DP.SpareGroupId
	FROM		MMDataPath AS DP WITH (NOLOCK)
	INNER JOIN	MMDrivePool DRP WITH (NOLOCK) ON DP.DrivePoolId = DRP.DrivePoolId
	INNER JOIN	MMMasterPool MP WITH (NOLOCK) ON MP.MasterPoolId = DRP.MasterPoolId
	INNER JOIN	MMLibrary L WITH (NOLOCK) ON L.LibraryId = MP.LibraryId
	INNER JOIN	archGroupCopy AS AGC WITH (NOLOCK) ON DP.CopyId = AGC.id
	INNER JOIN	archGroup AS AG WITH (NOLOCK) ON AG.id = AGC.archGroupId
	INNER JOIN	APP_Client CLNT WITH (NOLOCK) ON CLNT.id = DP.HostClientId
	INNER JOIN	MMSpareGroup SP WITH (NOLOCK) ON DP.SpareGroupId = SP.SpareGroupId
	WHERE		AG.name = @i_param1
				AND AGC.name = @i_param2
				AND CLNT.name = @i_param3
				AND L.AliasName = @i_param4
				AND DRP.DrivePoolName = @i_param5
				AND SP.SpareGroupName = @i_param6
END
IF LOWER(@i_Option) = 'hardwareencryption'
BEGIN
	IF ISNUMERIC(@option_Value) = 0
	BEGIN
		SET @localErrorMsg = 'Error: Invalid hardware encryption type.'
		SET @lastError = 1
		GOTO   ARGS_ERROR
	END
	-- Check the values of Hardware Encryption
	IF CAST(@option_Value AS INT) NOT IN (0,1,2,8)
	BEGIN
		SET @localErrorMsg = 'Error: Invalid hardware encryption type.'
		SET @lastError = 1
		GOTO   ARGS_ERROR
	END
	DELETE FROM @tmpDataPath WHERE SpareGroupId=0	--Spare group is non zero for tape
	IF NOT EXISTS ( SELECT DataPathId FROM @tmpDataPath )
	BEGIN
		SET @localErrorMsg = 'Error: No data paths found.'
		SET @lastError = 1
		GOTO   ARGS_ERROR
	END
	UPDATE	MMDataPath
	SET		UseHardwareEncryption = CAST (@option_Value AS INT)
	WHERE	DataPathId IN (SELECT DataPathId FROM @tmpDataPath)
	SET @rowCount = @@ROWCOUNT
END
BEGIN
SET	@localErrorMsg	='Total number of datapaths updated: [' + CONVERT (VARCHAR(10),@rowCount) + ']'
END
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
				15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetDataPathProperty')
	delete from GxQscripts where name = 'QS_SetDataPathProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetDataPathProperty')
	delete from GXDBVersions where aliasname = 'QS_SetDataPathProperty'
GO

insert into GXDBVersions values(2, 'QS_SetDataPathProperty',  '00010003007600030000', 'QS_SetDataPathProperty', '00010003007600030000')
GO

insert into GxQscripts values(2,'QS_SetDataPathProperty',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '	Command to set Hardware Encryption for all datapaths for a storage policy copy: qoperation execscript -sn SetDataPathProperty -si HardwareEncryption -si SP-Copy -si storage_policy_name -si storage_policy_copy_name -si hardware_encryption
'
 + CHAR(10) + '	Command to set Hardware Encryption for a commcell: qoperation execscript -sn SetDataPathProperty -si HardwareEncryption -si All -si hardware_encryption
'
 + CHAR(10) + '	Command to set Hardware Encryption for a given library/media agent: qoperation execscript -sn SetDataPathProperty -si HardwareEncryption -si Lib-MA -si library_name -si media_agent_name -si hardware_encryption
'
 + CHAR(10) + '	Command to set Hardware Encryption for a given datapath:  qoperation execscript -sn SetDataPathProperty -si HardwareEncryption -si datapath -si storage_policy_name -si storage_policy_copy_name -si media_agent_name -si library_name -si drive_pool_name -si scratch_pool_name -si hardware_encryption
'
 + CHAR(10) + '--   script_name : SetDataPathProperty'
 + CHAR(10) + '--   hardware_encryption = 0:  Disable hardware encryption'
 + CHAR(10) + '--   hardware_encryption = 1:  Enable hardware encryption via media password'
 + CHAR(10) + '--   hardware_encryption = 2:  Enable hardware encryption (no access)'
 + CHAR(10) + '--   hardware_encryption = 8:  Enable encryption on chunk map trailer'
)
GO

