

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetContentIndexingProperty.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_SetContentIndexingProperty')
BEGIN
	print '>>> Drop Stored Procedure: QS_SetContentIndexingProperty <<<'
	drop procedure QS_SetContentIndexingProperty
END
IF EXISTS (select * from GxQscripts where name='QS_SetContentIndexingProperty')
	delete from GxQscripts where name = 'QS_SetContentIndexingProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetContentIndexingProperty')
	delete from GXDBVersions where aliasname = 'QS_SetContentIndexingProperty'
GO
print '... Creating Procedure: QS_SetContentIndexingProperty'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetContentIndexingProperty
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @propertyName nvarchar(2048) = N'',
  @propertyValue nvarchar(2048) =N'',
  @AuthCode NVARCHAR(64) =N''
AS
Set NOCOUNT ON
DECLARE @NoParameter	nvarchar(10)
SET     @NoParameter	=N''
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = N'QS_SetContentIndexingProperty'
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = N'Succeeded'
DECLARE @CommCellNumber		INTEGER = 0
DECLARE @Authenticate		INTEGER = 0
-----------------------invalid parameters------------------------------
IF(@propertyName = @NoParameter OR @propertyValue = @NoParameter)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error: Insufficient command line parameters. Please refer to the readme file and retry with necessary parameters'
	GOTO SCRIPT_EXIT
END
------------------------------------------------------------------------
-----------------Validation of Commcell---------------------
SELECT @CommCellNumber = number from APP_CommCell where id = 2
--authcode is needed for permitted limit is crossed
IF (@propertyName = 'CINumDocumentMaxLimit' AND cast ( @propertyValue as bigint)> 60000000)
OR ( @propertyName = 'MaxCINodesLimitForCloud' AND cast ( @propertyValue as bigint)> 8)
BEGIN
	IF @AuthCode = @NoParameter --IF Authentication code is not passed
	BEGIN
		SET @errorString = N'No Authorization code passed. Authorization code required.'
		SET @errorCode = 3
		GOTO SCRIPT_EXIT
	END
	ELSE
	BEGIN
		SET @Authenticate = CONVERT(INTEGER, @AuthCode)
		IF ((CHECKSUM(HASHBYTES('SHA1', '<' + @scriptName + '><' + CAST(@propertyName AS VARCHAR(100)) + '><' + CAST(@propertyValue AS VARCHAR(100)) + '><' + CAST(@CommCellNumber AS VARCHAR(100)) + '><COMMVAULT>')) & 2147483646) <> @Authenticate)
		BEGIN
			SET @errorString = N'Wrong Authorization code passed [' + @AuthCode + '].'
			SET @errorCode = 4
			GOTO SCRIPT_EXIT
		END
	END
END
-----------------Update conent indexing property into GXGlobalParam table--------------
BEGIN TRAN
	BEGIN TRY
		EXEC QS_SetKeyIntoGlobalParamTbl @propertyName, 'Y', @propertyValue
		IF @propertyName = 'CINumDocumentMaxLimit'
		begin
			SET @propertyName = 'CINumDocumentReachesLimit'
			SET @propertyValue = cast (0.8 * cast ( @propertyValue as bigint) as bigint)
			EXEC QS_SetKeyIntoGlobalParamTbl @propertyName, 'Y', @propertyValue
		end
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode = ERROR_NUMBER ()
		SET @errorString = ERROR_MESSAGE ()
		GOTO SCRIPT_EXIT
	END CATCH
IF @errorCode = 0
	COMMIT TRAN
ELSE
	ROLLBACK TRAN
SCRIPT_EXIT:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@propertyName + ', '+@propertyValue +
         + ']. Exit Code(' +convert(varchar(2), @ErrorCode) + ').'
IF @ErrorCode <> 0
Raiserror(@ErrorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetContentIndexingProperty')
	delete from GxQscripts where name = 'QS_SetContentIndexingProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetContentIndexingProperty')
	delete from GXDBVersions where aliasname = 'QS_SetContentIndexingProperty'
GO

insert into GXDBVersions values(2, 'QS_SetContentIndexingProperty',  '00000000000000000000', 'QS_SetContentIndexingProperty', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetContentIndexingProperty',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	script_name: QS_SetContentIndexingProperty'
 + CHAR(10) + '-- 	qoperation execscript -sn QS_SetContentIndexingProperty.sql -si ''propertyName'' -si ''propertyValue'' [-si AuthenticationCode]'
 + CHAR(10) + '-- 	propertyName - specifies the Content Indexing property name for which we need to change the value. The following are examples of property names:'
 + CHAR(10) + '-- 					CINumDocumentMaxLimit - to set the content index document count limit'
 + CHAR(10) + '-- 					MaxCINodesLimitForCloud - to increase the number of search engine nodes'
 + CHAR(10) + '-- 					RELAX_CHECK_FOR_SP_TO_CI_CLOUD - to associate a search engine to more than one storage policy'
 + CHAR(10) + '-- 	propertyValue - value to be set'
 + CHAR(10) + '-- 	AuthenticationCode - To set CINumDocumentMaxLimit above 60 million or to set MaxCINodesLimitForCloud above 8, contact your account representative to receive an authentication code.'
)
GO

