

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetCompanySetting.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  QS_SetCompanySetting()
--  | Description:  Allows to set specific setting for Company
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SetCompanySetting.sp,v $ $Id: QS_SetCompanySetting.sp,v 1.1.4.6 2019/05/10 21:31:24 alakra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_SetCompanySetting')
BEGIN
	print '>>> Drop Stored Procedure: QS_SetCompanySetting <<<'
	drop procedure QS_SetCompanySetting
END
IF EXISTS (select * from GxQscripts where name='QS_SetCompanySetting')
	delete from GxQscripts where name = 'QS_SetCompanySetting'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetCompanySetting')
	delete from GXDBVersions where aliasname = 'QS_SetCompanySetting'
GO
print '... Creating Procedure: QS_SetCompanySetting'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetCompanySetting
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--QScript Usage. Do not use special char in HTML
  @providerDomainName NVARCHAR(256),
  @propertyName NVARCHAR(256),
  @propertyValue NVARCHAR(MAX)
AS
SET NOCOUNT ON
DECLARE @errorCode    INTEGER
DECLARE @errorString	NVARCHAR(1024)
DECLARE @canManageProvider INT
BEGIN TRY
	-- local variables
	DECLARE @nowTime AS integer = dbo.GetUnixTime (GetUTCdate())
	DECLARE @providerId INTEGER
	DECLARE @ownerCompany INTEGER
	DECLARE @rcnt INTEGER
--INSERT/UPDATE Operation
	BEGIN
		SET @errorCode = 0
		SET @errorString = 'Successful'
		BEGIN TRAN
		-- USER VALIDATION
		--Existence of table and fetching of top 1 userId is done for safety measures
		IF OBJECT_ID('tempdb.dbo.#tempQSUser') IS NULL
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'No logged in user found.'
			goto   SCRIPT_EXIT
		END
		DECLARE @userId INT
		SET @userId = 0
		SET @userId =  ISNULL( (select TOP 1 userId from #tempQSUser),0)
		IF @userId = 0
		BEGIN
			SET @errorCode = 2
			SET @errorString = 'No logged in user found.'
			goto   SCRIPT_EXIT
		END
		--Input validation and assignation--
		--1. Null and empty check
		IF(@propertyName IS NULL OR @propertyName = N'' )
		BEGIN
			SET @errorCode = 3
			SET @errorString = 'Error - empty inputs passed for Property Name.'
			GOTO SCRIPT_EXIT
		END
		--2. Validation of client group name
		SET @providerId = (SELECT id FROM UMDSProviders WHERE domainName=@providerDomainName)
		IF @providerId IS NULL OR @providerId < 0
		BEGIN
			SET @errorCode = 4
			SET @errorString = 'Error. Provider [' + @providerDomainName + '] is not valid'
			GOTO SCRIPT_EXIT
		END
		-- 3. Get owner company for the provided owner
		SET @ownerCompany = dbo.AppGetCompanyForProvider(@providerId)
EXEC sec_checkPermissionOnEntity  @userId, 1, @canManageProvider OUTPUT, 61, @ownerCompany
		IF @canManageProvider = 1
			BEGIN
				SET @propertyValue = LTRIM(RTRIM(@propertyValue))
				IF @propertyName = 'AllowOnPremiseStorage' AND (ISNUMERIC(@propertyValue) = 1) AND (0 = CONVERT(INT,@propertyValue) OR
					EXISTS(SELECT 1 FROM App_CompanyProp WHERE componentNameId = @ownerCompany AND attrName=@propertyName))
				BEGIN
					SET @errorCode = 6
					SET @errorString = 'Error - Property [' + @propertyName + '] can neither be modified nor set to 0.'
				END
				-- Duplicate entries in GxGlobalParam for 'Use UPN For Email' will have to be removed manually.
				-- Handle fix due to issue caused by form 74655 (SP17).
IF @propertyName = 'Use UPN For Email' AND @ownerCompany = 0
				BEGIN
UPDATE GXGlobalParam SET value = @propertyValue WHERE name = 'Use UPN For Email'
					IF @@ROWCOUNT = 0
INSERT INTO GXGlobalParam values('Use UPN For Email',@propertyValue,@nowTime,0)
					GOTO SCRIPT_EXIT
				END
				UPDATE APP_CompanyProp SET attrval =  @propertyValue
                WHERE attrname = @propertyName
                AND componentNameId = @ownerCompany AND modified=0
                SET @rcnt = @@ROWCOUNT
                IF (@rcnt = 0)
                BEGIN
					INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
					VALUES(@ownerCompany, @propertyName, 7,  @propertyValue, @nowTime, 0)
                END
			END
		ELSE
			BEGIN
				set @errorCode = 5
				set @errorString = 'User does not have rights to set email settings for Company.'
			END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @errorCode = ERROR_NUMBER()
    set @errorString = ERROR_MESSAGE()
END CATCH
SCRIPT_EXIT:
IF @errorCode = 0
BEGIN
    COMMIT TRAN
END
ELSE
BEGIN
	ROLLBACK TRAN
END
IF @errorCode <> 0
    RAISERROR(@errorString,
                15,  --Severity (> 10 to force DOS Error Code = 1)
                1    --State
                )
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetCompanySetting')
	delete from GxQscripts where name = 'QS_SetCompanySetting'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetCompanySetting')
	delete from GXDBVersions where aliasname = 'QS_SetCompanySetting'
GO

insert into GXDBVersions values(2, 'QS_SetCompanySetting',  '00010001000400060000', 'QS_SetCompanySetting', '00010001000400060000')
GO

insert into GxQscripts values(2+8,'QS_SetCompanySetting',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '    Script_Name: SetCompanySetting
'
 + CHAR(10) + '    Usage: qoperation execscript -sn SetCompanySetting.sql -si providerName -si propertyName -si propertyValue
'
 + CHAR(10) + '    Description: Set specific property for company
'
)
GO

