

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetClientTimeZone.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetClientTimeZone <<<'

IF EXISTS (select * from sysobjects where name='QS_SetClientTimeZone')
	drop procedure QS_SetClientTimeZone
IF EXISTS (select * from GxQscripts where name='QS_SetClientTimeZone')
	delete from GxQscripts where name = 'QS_SetClientTimeZone'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetClientTimeZone')
	delete from GXDBVersions where aliasname = 'QS_SetClientTimeZone'
GO
print '... Creating Procedure: QS_SetClientTimeZone'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetClientTimeZone
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @timeZoneName nvarchar(MAX), 
  @clientNameList nvarchar(MAX), 
  @clientGroupNameList nvarchar(MAX), 
  @exludedClientnameList nvarchar(MAX) 
AS
  DECLARE @response nvarchar( MAX)
SET NOCOUNT ON
-------Global variables ------
DECLARE @errorCode INT
DECLARE @timeZoneId INT
DECLARE @clientIdList table
(
	id int
)
DECLARE @tempXml xml
DECLARE @tempNameList table
(
	name nvarchar(max)
)
DECLARE @csClientId INT
select @csClientId = clientid from app_commcell where id = 2
---------------------------------- Time zone validation ---------------
SET @timeZoneId = 0
SELECT @timeZoneId = timeZoneId from SchedTimeZone WHERE TimeZoneStdName = @timeZoneName AND Flags = 0
IF @timeZoneId = 0 OR @timeZoneId  = NULL
BEGIN
  SET @response = 'Given Time zone name ['+ @timeZoneName +'] is invalid. Please see help to get the list of valid timezones '
  GOTO REPORT_ERROR
END
--- Set the timeZone name in the required  format
select @timeZoneName = (   CAST (  DSTFlag AS NVARCHAR( 100) )  + ':' +    CAST( ( -1 * (   Bias/60) )  AS nvarchar ( 100  ) )    + ':' + TimeZoneStdName )
from SchedTimeZone  where timeZoneId = @timeZoneId
--------------------------------------------------------------------------
---------------------------------- Client name list validation ---------------
-- Test case --
-- 1. Should not throw error when a clientname is passed in language other than english ( handle unicode).
-- 2. NO_CLIENT should get paased with empty client list
-- 3. ALL_CLIENTS Should get passed with all the client in the DB.
-- 4. Throw error for invalid client names.
IF @clientNameList = 'NO_CLIENT'
BEGIN
 -- No client list are passed proceed without filling clientId list table.
 GOTO CLIENTLIST_VALIDATION_PASSED
END
ELSE IF @clientNameList = 'ALL_CLIENT'
BEGIN
   INSERT INTO @clientIdList
   SELECT id FROM APP_Client
END
ELSE
BEGIN
	INSERT INTO @tempNameList
	(
	   name
	)
	SELECT data FROM dbo.SplitString(@clientNameList , ',')
	 --- check whether we have any client name which are not present in DB
	DECLARE @invalidNameList NVARCHAR(MAX)
	SELECT @invalidNameList = COALESCE( @invalidNameList+',' ,'') + clientNames.name   from @tempNameList  AS clientNames
	LEFT OUTER JOIN APP_Client ON  clientNames.name = APP_Client.name
	WHERE APP_Client.id IS NULL
	IF @invalidNameList <> ''
	BEGIN
	  SET @response =  'ERROR : Client name validation failed for following clientlist ' +  @invalidNameList
	  GOTO REPORT_ERROR
	END
	ELSE
	BEGIN
	  -- List of validated clients need to be inserted into @clientIdList table
	  INSERT INTO @clientIdList
	  SELECT id FROM APP_Client
	  INNER JOIN @tempNameList AS clientNames
	  ON clientNames.name = APP_Client.name
	END
	---Do not change timezone for cs client
	IF EXISTS ( SELECT 1 FROM @clientIdList WHERE id = @csClientId)
	  SET @response =  'WARNING : Cannot change timezone for CS client'
END
CLIENTLIST_VALIDATION_PASSED:
   DELETE @tempNameList
----------------------------------Client names are extracted and validated successfully --------------------
---------------------------------------------------------------------------------------------------------------------------------
---------------------------------- Client group name list validation ---------------
-- Test case --
-- 1. Should not throw error when a clientname is passed in language other than english ( handle unicode) .
-- 2. NO_CLIENTGROUP should get paased with empty client list
-- 3. ALL_CLIENT_GROUP Should get passed with all the client in the DB.
-- 4. Throw error for invalid client names.
IF @clientGroupNameList = 'NO_CLIENTGROUP'
BEGIN
 -- No client list are passed proceed without filling clientId list table.
 GOTO CLIENT_GROUP_LIST_VALIDATION_PASSED
END
ELSE IF @clientGroupNameList = 'ALL_CLIENT_GROUP'
BEGIN
   INSERT INTO @clientIdList
   SELECT DISTINCT clientId FROM APP_ClientGroupAssoc
END
ELSE
BEGIN
	INSERT INTO @tempNameList
	(
	   name
	)
	SELECT data FROM dbo.SplitString(@clientGroupNameList , ',')
	 --- check whether we have any client name which are not present in DB
	DECLARE @invalidClientGroupNameList NVARCHAR(MAX)
	SELECT @invalidClientGroupNameList = COALESCE( @invalidClientGroupNameList +',' ,'') + clientGroupNames.name   from @tempNameList  AS clientGroupNames
	LEFT OUTER JOIN APP_ClientGroup
	ON  clientGroupNames.name = APP_ClientGroup.name
	WHERE APP_ClientGroup.id IS NULL
	IF @invalidClientGroupNameList <> ''
	BEGIN
	  SET @response =  'ERROR : Client group name validation failed for following client group names  ' +  @invalidClientGroupNameList
	  GOTO REPORT_ERROR
	END
	ELSE
	BEGIN
	  -- List of validated clients need to be inserted into @clientIdList table
	  INSERT INTO @clientIdList
		 SELECT DISTINCT APP_ClientGroupAssoc.clientId
	     FROM @tempNameList AS clientGroupNames
	     INNER JOIN APP_ClientGroup
	     ON clientGroupNames.name = APP_ClientGroup.name
	     INNER JOIN APP_ClientGroupAssoc
	     ON APP_ClientGroupAssoc.clientGroupId = APP_ClientGroup.id
	END
END
CLIENT_GROUP_LIST_VALIDATION_PASSED:
    DELETE @tempNameList
----------------------------------Client group names are extracted and validated successfully --------------------
---------------------------------------------------------------------------------------------------------------------------------
---------------------------------- Excluded Client name list validation ---------------
-- Test case --
-- 1. Should not throw error when a clientname is passed in language other than english ( handle unicode) .
-- 2. NO_CLIENT should get paased with empty client list
-- 4. Throw error for invalid client names.
IF @exludedClientnameList = 'NO_CLIENT'
BEGIN
 -- No client list are passed proceed without filling clientId list table.
 GOTO EXCLUDED_CLIENTLIST_VALIDATION_PASSED
END
ELSE
BEGIN
	INSERT INTO @tempNameList
	(
	   name
	)
	SELECT data FROM dbo.SplitString(@exludedClientnameList , ',')
	--- check whether we have any client name which are not present in DB
	DECLARE @invalidExcludedNameList NVARCHAR(MAX)
	SELECT @invalidExcludedNameList = COALESCE( @invalidExcludedNameList+',' ,'') + clientNames.name   from @tempNameList  AS clientNames
	LEFT OUTER JOIN APP_Client ON  clientNames.name = APP_Client.name
	WHERE APP_Client.id IS NULL
	IF @invalidExcludedNameList <> ''
	BEGIN
	  SET @response =  'ERROR : Client name validation failed for following clientlist given for excluding ' +  @invalidExcludedNameList
	  GOTO REPORT_ERROR
	END
	ELSE
	BEGIN
	  -- List of validated clients need to be removed from  @clientIdList table
	  DELETE  @clientIdList WHERE
	  id IN
	  (
	    SELECT id FROM APP_Client
	    INNER JOIN @tempNameList AS clientNames
	    ON clientNames.name = APP_Client.name
	  )
	END
END
EXCLUDED_CLIENTLIST_VALIDATION_PASSED:
   DELETE @tempNameList
   -----------------------------Client names which are excluded are extracted and validated successfully ------------
---------------------------------------------------------------------------------------------------------------------------
--------------------------------
---  Remove duplicate entries
--------------------------------
DECLARE @distinctClientId TABLE
(
   id int
)
INSERT INTO @distinctClientId
SELECT DISTINCT id FROM @clientIdList
---Do not change timezone for cs client
DELETE FROM @distinctClientId
WHERE id = @csClientId
----------------------------------------------------------------------
-- Deleted the previous timeZone entries from the APP_ClientProp
------------------------------------------------------------------------
DELETE  APP_ClientProp
WHERE
 (
    attrName = 'timezone' OR attrname = 'timezone Id'
 )
 AND
 componentNameId in
 (
   select id from @distinctClientId
 )
------------------------------------------------
---- Insert timeZone in the APP_ClientProp table -----
INSERT INTO APP_ClientProp
SELECT id AS componentNameId ,
      'timeZone' AS attrName ,
	   1 as attrType ,
	   @timeZoneName  AS attrVal,
	   DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()) AS created ,
	   0 AS modified,
	   0 AS ccpId
FROM   @distinctClientId
---- Insert timezone Id in the APP_ClientProp table -----
INSERT INTO APP_ClientProp
SELECT id AS componentNameId ,
      'timezone Id' AS attrName ,
	   8 as attrType ,
	   CAST( @timeZoneId AS nvarchar(MAX) )  AS attrVal,
	   DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()) AS created ,
	   0 AS modified,
	   0 AS ccpId
FROM   @distinctClientId
--------------------------------------------------------------
REPORT_ERROR:
 IF @response <>''
 SELECT @response
 ELSE
 BEGIN
     SET @response =  'Timezone modified successfully'
     SELECT @response
 END
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetClientTimeZone')
	delete from GxQscripts where name = 'QS_SetClientTimeZone'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetClientTimeZone')
	delete from GXDBVersions where aliasname = 'QS_SetClientTimeZone'
GO

insert into GXDBVersions values(2, 'QS_SetClientTimeZone',  '00000000000000000000', 'QS_SetClientTimeZone', '00000000000000000000')
GO

insert into GxQscripts values(2+8,'QS_SetClientTimeZone',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '    qoperation execscript -sn QS_SetClientTimeZone.sql -si timeZoneName -si clientNameList -si clientGroupNameList -si exludedClientnameList
'
 + CHAR(10) + '--   script_name : QS_SetClientTimeZone'
)
GO

