

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetClientProperty.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_SetClientProperty')
BEGIN
	print '>>> Drop Stored Procedure: QS_SetClientProperty <<<'
	drop procedure QS_SetClientProperty
END
IF EXISTS (select * from GxQscripts where name='QS_SetClientProperty')
	delete from GxQscripts where name = 'QS_SetClientProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetClientProperty')
	delete from GXDBVersions where aliasname = 'QS_SetClientProperty'
GO
print '... Creating Procedure: QS_SetClientProperty'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetClientProperty
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @clientName nvarchar(2048) = N'',
  @propertyName nvarchar(2048) = N'',
  @propertyValue nvarchar(2048) =N'',
  @AuthCode NVARCHAR(64) =N''
AS
Set NOCOUNT ON
DECLARE @NoParameter	nvarchar(10)
SET     @NoParameter	=N''
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = N'QS_SetClientProperty'
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = N'Succeeded'
DECLARE @CommCellNumber		INTEGER = 0
DECLARE @Authenticate		INTEGER = 0
-----------------------invalid parameters------------------------------
IF(@clientName = @NoParameter OR @propertyName = @NoParameter OR @propertyValue = @NoParameter)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error: Insufficient command line parameters. Please refer to the readme file and retry with necessary parameters'
	GOTO SCRIPT_EXIT
END
------------------------------------------------------------------------
-----------------Validation of client---------------------
DECLARE @ClientID AS int
SET @ClientID = ISNULL((SELECT id FROM APP_Client WHERE name = @clientname),0)
IF @ClientID = 0
BEGIN
	SET @errorCode = 2
	SET @errorString = 'Error. Invalid client name [' + @clientname + '] specified.'
	GOTO SCRIPT_EXIT
END
SELECT @CommCellNumber = number from APP_CommCell where id = 2
IF @AuthCode = @NoParameter --IF Authentication code is not passed
BEGIN
	SET @errorString = N'No Authorization code passed. Authorization code required.'
	SET @errorCode = 3
	GOTO SCRIPT_EXIT
END
ELSE
BEGIN
	SET @Authenticate = CONVERT(INTEGER, @AuthCode)
	IF ((CHECKSUM(HASHBYTES('SHA1', '<' + @scriptName + '><' + CAST(@ClientID AS VARCHAR(100)) + '><' + CAST(@CommCellNumber AS VARCHAR(100)) + '><COMMVAULT>')) & 2147483646) <> @Authenticate)
	BEGIN
		SET @errorString = N'Wrong Authorization code passed [' + @AuthCode + '].'
		SET @errorCode = 4
		GOTO SCRIPT_EXIT
	END
END
-----------------Update client property into APP_ClientProp table--------------
DECLARE @nowtime as int
SET @nowtime = dbo.GetUnixTime (GetUTCDate())
BEGIN TRAN
	BEGIN TRY
		   --If this property already exists, then update it--
		   IF EXISTS (SELECT *
					  FROM APP_ClientProp
					  WHERE componentNameId = @ClientID AND attrName = @propertyName AND modified = 0)
		   BEGIN
					UPDATE APP_ClientProp
					SET attrval = @propertyValue
					WHERE componentNameId = @ClientID and attrName = @propertyName and modified = 0
			END
			ELSE
			BEGIN
				INSERT APP_ClientProp(componentNameId , attrName, attrtype, attrVal, created , modified , ccpId )
					VALUES (@ClientID, @propertyName, 1, @propertyValue, @nowtime, 0, 0)
			END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode = ERROR_NUMBER ()
		SET @errorString = ERROR_MESSAGE ()
		GOTO SCRIPT_EXIT
	END CATCH
IF @errorCode = 0
	COMMIT TRAN
ELSE
	ROLLBACK TRAN
SCRIPT_EXIT:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@clientName + ', '+@propertyName + ', '+@propertyValue +
         + ']. Exit Code(' +convert(varchar(2), @ErrorCode) + ').'
IF @ErrorCode <> 0
Raiserror(@ErrorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetClientProperty')
	delete from GxQscripts where name = 'QS_SetClientProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetClientProperty')
	delete from GXDBVersions where aliasname = 'QS_SetClientProperty'
GO

insert into GXDBVersions values(2, 'QS_SetClientProperty',  '00000000000000000000', 'QS_SetClientProperty', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetClientProperty',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_SetClientProperty.sql -si ''clientName'' -si ''propertyName'' -si ''propertyValue'' -si AuthenticationCode
'
 + CHAR(10) + '-- 	script_name: QS_SetClientProperty'
 + CHAR(10) + '-- 	 Qscript to set client property for the specified client'
 + CHAR(10) + '-- 	clientName - Name of the Client'
 + CHAR(10) + '-- 	propertyName - specifies the property name (attrName) for which we need to change the value'
 + CHAR(10) + '-- 	propertyValue - value to be set'
 + CHAR(10) + '-- 	AuthenticationCode - To receive your authentication code, please contact your account representative. '
)
GO

