

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetClientProp.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetClientProp <<<'

IF EXISTS (select * from sysobjects where name='QS_SetClientProp')
	drop procedure QS_SetClientProp
IF EXISTS (select * from GxQscripts where name='QS_SetClientProp')
	delete from GxQscripts where name = 'QS_SetClientProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetClientProp')
	delete from GXDBVersions where aliasname = 'QS_SetClientProp'
GO
print '... Creating Procedure: QS_SetClientProp'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetClientProp
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @param1 nvarchar(100) = '',
  @param2 nvarchar(100) = ''
AS
--DECLARE @Param1 AS nvarchar(100) = 'c=bingo'
--DECLARE @Param2 AS nvarchar(100) = 'UsePhysicalNode=y'
--*******-----------
--CONVENIENCE DEFS--
--************----
DECLARE @clientname AS nvarchar(100)
DECLARE @option AS bit
DECLARE @dbval AS nvarchar(100)
DECLARE @ClientID AS int
DECLARE @NoParams AS nvarchar(3)
DECLARE @ErrorCode AS int
DECLARE @ErrorString AS nvarchar(100)
DECLARE @ScriptName AS nvarchar(100)
DECLARE @nowtime as int
SET @NoParams = ''
SET @ErrorCode = 0
SET @ErrorString = N'Succeeded'
SET @ScriptName = N'SetClientProp'
SET @nowtime = dbo.GetUnixTime (GetUTCDate())
--Check whether all params are passed--
IF (@param1 = @NoParams) OR (@param1 NOT LIKE 'c=%')
BEGIN
	SET @ErrorCode = 1
	SET @ErrorString = 'Error. 1st param must be client name specified as c=clientname'
	GOTO ARGS_ERROR
END
IF (@param2 = @NoParams) OR (@param2 NOT in (N'UsePhysicalNode=y' , N'UsePhysicalNode=n'))
BEGIN
	SET @ErrorCode = 1
	SET @ErrorString = 'Error. 2nd param must be UsePhysicalNode=y|n'
	GOTO ARGS_ERROR
END
--Validation of client--
SET @clientname = SUBSTRING(@param1,LEN('c=')+1,LEN(@param1)-LEN('c='))
SET @ClientID = ISNULL((SELECT id FROM APP_Client WHERE name = @clientname),0)
IF @ClientID = 0
BEGIN
	SET @ErrorCode = 1
	SET @ErrorString = 'Error. Invalid client[' + @clientname + '] specified.'
	GOTO ARGS_ERROR
END
--All successful---
	IF SUBSTRING(@param2,LEN(N'UsePhysicalNode=')+1,LEN(@param2)-LEN(N'UsePhysicalNode=')) = 'y'
		SET @option = 1
	ELSE
		SET @option = 0
	IF EXISTS (SELECT * FROM APP_ClientProp WHERE componentNameId = @ClientID AND attrName = N'Virtual Client' AND attrVal = 1 AND modified = 0)
	BEGIN
		BEGIN TRY
		   --If this property already exists, then update it--
		   IF EXISTS (SELECT *
					  FROM APP_ClientProp
WHERE componentNameId = @ClientID AND attrName = N'Use Active Physical Node')
		   BEGIN
SET @dbval = (SELECT attrval FROM APP_ClientProp WHERE componentNameId = @ClientID AND attrName = N'Use Active Physical Node' AND modified = 0)
				--Update only if the values don't match
				IF ( @option <> @dbval)
				BEGIN
					UPDATE APP_ClientProp
					SET attrval = CONVERT(nvarchar(1),@option)
WHERE componentNameId = @ClientID and attrName = N'Use Active Physical Node' and modified = 0
				--Add a new row corresponding to this attribute--
					--INSERT APP_ClientProp(componentNameId , attrName, attrtype, attrVal, created , modified , ccpId )
						--VALUES (@ClientID , PROPERTY_NAME, 2, CONVERT(nvarchar(1),@option), @nowtime ,0,0)
				END
			END
			ELSE
			BEGIN
				INSERT APP_ClientProp(componentNameId , attrName, attrtype, attrVal, created , modified , ccpId )
VALUES (@ClientID , N'Use Active Physical Node', 2, CONVERT(nvarchar(1),@option), @nowtime ,0,0)
			END
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			SET @errorCode = ERROR_NUMBER ()
			SET @errorString = ERROR_MESSAGE ()
			GOTO ARGS_ERROR
		END CATCH
	END
	ELSE
	BEGIN
		--Not a virtual client--
		SET @ErrorCode = 1
		SET @ErrorString = 'Error. Client [' + @clientname + '] not a virtual client'
		GOTO ARGS_ERROR
	END
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@Param1 + ', '+@Param2 +
         + ']. Exit Code(' +convert(varchar(2), @ErrorCode) + ').'
IF @ErrorCode <> 0
Raiserror(@ErrorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetClientProp')
	delete from GxQscripts where name = 'QS_SetClientProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetClientProp')
	delete from GXDBVersions where aliasname = 'QS_SetClientProp'
GO

insert into GXDBVersions values(2, 'QS_SetClientProp',  '00000000000000000000', 'QS_SetClientProp', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetClientProp',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetClientProp.sql -si c=clientName -si UsePhysicalNode=y|n 
'
 + CHAR(10) + '-- 	script_name: SetClientProp'
 + CHAR(10) + '-- 	Qscript to enable/disable Use Active Physical Node for virtual clients'
)
GO

