

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetClientGroupIndexServer.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_SetClientGroupIndexServer')
BEGIN
	print '>>> Drop Stored Procedure: QS_SetClientGroupIndexServer <<<'
	drop procedure QS_SetClientGroupIndexServer
END
IF EXISTS (select * from GxQscripts where name='QS_SetClientGroupIndexServer')
	delete from GxQscripts where name = 'QS_SetClientGroupIndexServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetClientGroupIndexServer')
	delete from GXDBVersions where aliasname = 'QS_SetClientGroupIndexServer'
GO
print '... Creating Procedure: QS_SetClientGroupIndexServer'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetClientGroupIndexServer
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @param1 nvarchar(256) = '',
  @param2 nvarchar(100) = ''
AS
DECLARE @NoParams AS nvarchar(3)
DECLARE @ErrorCode AS int
DECLARE @ErrorString AS nvarchar(100)
DECLARE @ScriptName AS nvarchar(100)
DECLARE @nowtime as int
DECLARE @clientGroupName NVARCHAR(256) = ''
DECLARE @clientGroupId INT = NULL
DECLARE @indexServerName NVARCHAR(256) = ''
DECLARE @indexServerId INT = NULL
BEGIN TRY
	SET @NoParams = ''
	SET @ErrorCode = 0
	SET @ErrorString = N'Succeeded'
	SET @ScriptName = N'SetClientGroupIndexServer'
	SET @nowtime = dbo.GetUnixTime (GetUTCDate())
	SET @clientGroupName = @param1
	SET @indexServerName = @param2
	--Check whether all params are passed--
	IF (@param1 = @NoParams) OR (@param2 = @NoParams)
	BEGIN
		SET @ErrorCode = 1
		SET @ErrorString = 'Invalid inputs. Client group name and Index Server names are mandatory.'
		GOTO ARGS_ERROR
	END
	IF (@clientGroupName <> '')
	BEGIN
		-- get clientgroupid by name lookup
		SELECT TOP 1
			@clientGroupId = cg.id
		FROM APP_ClientGroup cg WITH(NOLOCK)
		WHERE cg.name = @clientGroupName
		IF (@clientGroupId IS NULL)
		BEGIN
			SET @errorCode = 2
			SET @errorString = 'Error. Invalid Client Group name [' + @clientGroupName + '] specified.'
			GOTO ARGS_ERROR
		END
		IF NOT EXISTS(SELECT entityId FROM APP_AdvanceSettings S WITH (NOLOCK)
WHERE S.entityId = @clientgroupId AND S.entityType =  28  AND  S.keyName =  'EnableCloudLaptopMode')
		BEGIN
			SET @errorCode = 2
			SET @errorString = 'Error. Cloud Laptop feature is not enabled on the Client Group: [' + @clientGroupName + '] specified.'
			GOTO ARGS_ERROR
		END
	END
	IF (@indexServerName <> '')
	BEGIN
		SELECT TOP 1  @indexServerId=pseudoClientId from DM2CLOUD WITH(NOLOCK)
		Where (name = @indexServerName or displayName = @indexServerName) and Cloudtype = 1 --App::CloudServerType_AnalyticsEngine
		IF (@indexServerId IS NULL)
		BEGIN
			SET @errorCode = 3
			SET @errorString = 'Error. Invalid Index Server name [' + @indexServerName + '] specified.'
			GOTO ARGS_ERROR
		END
	END
	UPDATE APP_COMPONENTPROP
	set longVal =  @indexServerId
WHERE componenttype = 8
	and componentid=@clientGroupId
and propertyTypeId = 3609
	IF @@ROWCOUNT = 0
	BEGIN
		INSERT INTO APP_COMPONENTPROP (componenttype, componentid, propertytypeid,datatype,longval,longlongval,stringval,created,modified)
values (8, @clientGroupId,  3609,  1, @indexServerId, 0,  '',  @nowTime    ,0)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorString = ERROR_MESSAGE()
	GOTO ARGS_ERROR
END CATCH
ARGS_ERROR:
	PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+ @param1 + ', ' + @param2 +
         + ']. Exit Code(' +convert(varchar(2), @ErrorCode) + ').'
IF @ErrorCode <> 0
	Raiserror(@ErrorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetClientGroupIndexServer')
	delete from GxQscripts where name = 'QS_SetClientGroupIndexServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetClientGroupIndexServer')
	delete from GXDBVersions where aliasname = 'QS_SetClientGroupIndexServer'
GO

insert into GXDBVersions values(2, 'QS_SetClientGroupIndexServer',  '00000000000000000000', 'QS_SetClientGroupIndexServer', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetClientGroupIndexServer',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetClientGroupIndexServer.sql [-si ''clientGroupName''] [-si ''IndexServerName'']
'
 + CHAR(10) + '-- 	script_name: SetClientGroupIndexServer'
 + CHAR(10) + '-- 	Qscript to set an index server for a cloud laptop client group.'
)
GO

