

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetClientGroupCCSProp.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetClientGroupCCSProp <<<'

IF EXISTS (select * from sysobjects where name='QS_SetClientGroupCCSProp')
	drop procedure QS_SetClientGroupCCSProp
IF EXISTS (select * from GxQscripts where name='QS_SetClientGroupCCSProp')
	delete from GxQscripts where name = 'QS_SetClientGroupCCSProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetClientGroupCCSProp')
	delete from GXDBVersions where aliasname = 'QS_SetClientGroupCCSProp'
GO
print '... Creating Procedure: QS_SetClientGroupCCSProp'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetClientGroupCCSProp
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @param1 nvarchar(256) = '',
  @param2 nvarchar(100) = '',
  @param3 nvarchar(100) = ''
AS
	--DECLARE param1 AS nvarchar(100) = 'bingo'
	--DECLARE param2 AS nvarchar(100) = 'UseCCS=y'
--*******-----------
--CONVENIENCE DEFS--
--************----
	DECLARE @option AS INT = 15	-- get
	DECLARE @force AS INT = 0
	DECLARE @NoParams AS nvarchar(3)
	DECLARE @ErrorCode AS int
	DECLARE @ErrorString AS nvarchar(100)
	DECLARE @ScriptName AS nvarchar(100)
	DECLARE @nowtime as int
	DECLARE @isForce AS INT = 0
	DECLARE @spRC INT = 0
	DECLARE @clientGroupName NVARCHAR(256) = ''
	DECLARE @clientGroupId INT = NULL
	SET @NoParams = ''
	SET @ErrorCode = 0
	SET @ErrorString = N'Succeeded'
	SET @ScriptName = N'SetClientGroupCCSProp'
	SET @nowtime = dbo.GetUnixTime (GetUTCDate())
--Check whether all params are passed--
	IF (@param1 = @NoParams)
	BEGIN
		SET @clientGroupName = ''
	END
	ELSE
	BEGIN
		SET @clientGroupName = @param1
		IF (@param2 <> @NoParams) AND (@param2 NOT in (N'UseCCS=y' , N'UseCCS=n'))
		BEGIN
			SET @ErrorCode = 2
			SET @ErrorString = 'Error. 2nd param must be ''UseCCS=y|n''.'
			GOTO ARGS_ERROR
		END
		IF (@param3 <> @NoParams) AND (@param3 <> 'force')
		BEGIN
			SET @ErrorCode = 2
			SET @ErrorString = 'Error. 3rd param must be ''force''.'
			GOTO ARGS_ERROR
		END
		IF (@param2 <> @NoParams)
		BEGIN
			IF SUBSTRING(@param2,LEN(N'UseCCS=')+1,LEN(@param2)-LEN(N'UseCCS=')) = 'y'
			BEGIN
				SET @option = 14	-- enable
			END
			ELSE
			BEGIN
				SET @option = 13	-- disable
			END
		END
		IF (@param3 = N'force')
		BEGIN
			SET @force = 1		-- force client re-sync
		END
	END
	IF (@clientGroupName <> '')
	BEGIN
		-- get clientgroupid by name lookup
		SELECT TOP 1
			@clientGroupId = cg.id
		FROM APP_ClientGroup cg WITH(NOLOCK)
		WHERE cg.name = @clientGroupName
		IF (@clientGroupId IS NULL)
		BEGIN
			SET @errorCode = 3
			SET @errorString = 'Error. Invalid client group name [' + @clientGroupName + '] specified.'
			GOTO ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SET @clientGroupId = -1
	END
--All successful---
	-- APPCCSControls options
	--	Opcode=13: Disable ClientGroup CCS Enabled Property for @clientGroupId [@force=1]
	--	Opcode=14: Enable ClientGroup CCS Enabled Property for @clientGroupId [@force=1]
	--  Opcode=15: Get Clients with ''CCS Enabled'' Property by client group or for specific @clientGroupId
	BEGIN TRY
		IF (@option = 15)
		BEGIN
			IF (@clientGroupId = -1)
			BEGIN
				EXEC @spRC = APPCCSControls @opCode=@option
			END
			ELSE
			BEGIN
				EXEC @spRC = APPCCSControls @opCode=@option, @clientGroupId=@clientGroupId
			END
		END
		ELSE
		BEGIN
			EXEC @spRC = APPCCSControls @opCode=@option, @clientGroupId=@clientGroupId, @force=@isForce
		END
		IF @spRC <> 0
		BEGIN
			SET @ErrorCode = @spRC
			SET @ErrorString = 'Error APPCCSControls failed, see output.'
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode = ERROR_NUMBER()
		SET @errorString = ERROR_MESSAGE()
		GOTO ARGS_ERROR
	END CATCH
ARGS_ERROR:
	PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+ @param1 + ', ' + @param2 +
         + ']. Exit Code(' +convert(varchar(2), @ErrorCode) + ').'
IF @ErrorCode <> 0
	Raiserror(@ErrorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetClientGroupCCSProp')
	delete from GxQscripts where name = 'QS_SetClientGroupCCSProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetClientGroupCCSProp')
	delete from GXDBVersions where aliasname = 'QS_SetClientGroupCCSProp'
GO

insert into GXDBVersions values(2, 'QS_SetClientGroupCCSProp',  '00000000000000000000', 'QS_SetClientGroupCCSProp', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetClientGroupCCSProp',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetClientGroupCCSProp.sql [-si ''clientGroupName'' [ (-si UseCCS=y|n) [-si force]]]
'
 + CHAR(10) + '-- 	script_name: SetClientGroupCCSProp'
 + CHAR(10) + '-- 	Qscript to get/enable/disable CommServer Client Side (CCS) Database operations for CCS clients by client groups or given client group name.'
)
GO

