

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetClientGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SetClientGroup.sp,v $ $Id: QS_SetClientGroup.sp,v 1.7.60.5 2018/09/24 17:08:49 kmokshagundam Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetClientGroup <<<'

IF EXISTS (select * from sysobjects where name='QS_SetClientGroup')
	drop procedure QS_SetClientGroup
IF EXISTS (select * from GxQscripts where name='QS_SetClientGroup')
	delete from GxQscripts where name = 'QS_SetClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetClientGroup')
	delete from GXDBVersions where aliasname = 'QS_SetClientGroup'
GO
print '... Creating Procedure: QS_SetClientGroup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetClientGroup
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @clientNames nvarchar(MAX),
  @groupName nvarchar(1024),
  @option nvarchar(100)='ADD'
AS
Set NOCOUNT ON
------------ Convenience Definitions    -----------
	DECLARE @scriptName	varchar(32)
	SET		@scriptName	= 'SetClientGroup'
	DECLARE @lastError	integer
	SET		@lastError	= 0
	DECLARE @localErrorMsg	varchar(512)
	SET		@localErrorMsg	='Error Encountered when running script.'
	DECLARE @optAdd	varchar(32)
	SET		@optAdd	= 'ADD'
	DECLARE @optRem	varchar(32)
	SET		@optRem	= 'REM'
	DECLARE @now				integer
	DECLARE @userId				integer
	DECLARE @clientlist nvarchar(max)
	DECLARE @sql nvarchar(max)
	DECLARE @fwMessage nvarchar(512)
	SET @now = dbo.GetUnixTime(GETDATE())
	SET @userId	 = 1
-----------------------invalid parameters------------------------------
BEGIN TRY
	DECLARE @flag as INT = 0
	DECLARE @clientGroupId integer
	SET @clientGroupId = ISNULL((SELECT id FROM app_clientgroup WHERE name like @groupName), 0)
	IF LEN(@clientNames) <= 0
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Client Names cannot be empty.'
		GOTO ARGS_ERROR
	END
	IF @clientGRoupId = 0
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Client Group ['+ @groupName +'] does not exist.'
		GOTO ARGS_ERROR
	END
	SET @flag = (SELECT flag from APP_ClientGroup WHERE id = @clientGroupId)
IF ( (@flag & 0x0100) <> 0 OR (@flag & 0x0200) <> 0)
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Client Group ['+ @groupName +'] has EDC clients associated, hence can not change association'
		GOTO ARGS_ERROR
	END
IF ((@flag & 0x1000) <> 0)
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Client Group ['+ @groupName +'] is a smart client group, hence can not change association'
		GOTO ARGS_ERROR
	END
	SET @clientlist = ''''+REPLACE(@clientNames,',',''',''')+''''
	SET @sql = 'select client.id,0 from APP_Client client where client.name in('+@clientlist+')'
BEGIN TRAN
	CREATE TABLE #tmptable1
	(
		clientid integer,
		cgGroup integer
	)
	INSERT INTO #tmptable1
		EXECUTE  sp_executesql @sql
	UPDATE #tmptable1 SET cgGroup = @clientGroupId
	CREATE TABLE #tmpTable2
	(
		id integer,
		clientName nvarchar(1024)
	)
	INSERT INTO #tmpTable2
		SELECT * FROM dbo.SplitString(@clientNames,',')
	DECLARE @nameNotAdded nvarchar(max)
	SET @nameNotAdded = ''
	SELECT @nameNotAdded = @nameNotAdded+clientName+',' FROM #tmptable2 WHERE clientName NOT IN
		(SELECT name FROM APP_Client WHERE id in(SELECT clientid FROM #tmptable1))
	IF @option = @optAdd
	BEGIN
			INSERT INTO APP_ClientGroupAssoc(clientGroupId,clientId)
				SELECT DISTINCT cgGroup,clientid FROM #tmptable1 WHERE clientid NOT IN
					(SELECT clientId FROM APP_ClientGroupAssoc WHERE clientGroupId = @clientGroupId )
	END
	ELSE IF @option = @optRem
	BEGIN
			DELETE FROM APP_ClientGroupAssoc WHERE clientId IN (SELECT clientid FROM #tmptable1) and clientGroupId = @clientGroupId
	END
	IF EXISTS( select * from APP_Firewall FW where ((( FW.forClientGroupId=@clientGroupId and FW.forClientId=0)
						 or (FW.clientGroupId= @clientGroupId and FW.clientId =0 ))))
	   OR EXISTS(select * from APP_FirewallOptions FWO where FWO.clientGroupId = @clientGroupId)
		SET @fwMessage = 'Info: Client Group :['+ @groupName  + '] has firewall setting set.Please push the firewall configuration on to successfully added/removed clients to reflect the firewall configuration.'
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @lastError = @@ERROR
	SET @localErrorMsg = (SELECT ERROR_MESSAGE())
	goto ARGS_ERROR
END CATCH
 TRANS_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
ARGS_ERROR:
	PRINT ''
	PRINT @scriptName + 'completed at '
					+ Convert(varchar(60), getdate())+' with parameters client Name ['
					+ @clientNames + '] client group Name ['
					+ @groupName + '] option ['
					+ @option + ']. ErrorCode ('+
					+ Convert(varchar(2),@lastError) +').'
	IF(LEN(@nameNotAdded) > 0)
	BEGIN
		PRINT 'Clients not added/removed['+@nameNotAdded+']'
	END
	IF (LEN(@fwMessage) > 0)
	BEGIN
		PRINT ''
		PRINT @fwMessage
	END
	if @lastError <> 0
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetClientGroup')
	delete from GxQscripts where name = 'QS_SetClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetClientGroup')
	delete from GXDBVersions where aliasname = 'QS_SetClientGroup'
GO

insert into GXDBVersions values(2, 'QS_SetClientGroup',  '00010007006000050000', 'QS_SetClientGroup', '00010007006000050000')
GO

insert into GxQscripts values(2,'QS_SetClientGroup',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetClientGroup -si [client_name_list] -si [client_group_name] -si [option]
'
 + CHAR(10) + '	qoperation execscript -sn SetClientGroup -si @clientNames=''client_name1,client_name2,client_name3'' -si @groupName=''group_name'' -si @option=''ADD/REM''
'
 + CHAR(10) + '	qoperation execscript -sn SetClientGroup -si ''client_name'' -si ''group_name'' -si ''REM''
'
 + CHAR(10) + '	[client_name_list]  specifies the comma separated client names to be added or removed.
'
 + CHAR(10) + '	[client_group_name]  specifies the name of the client group to which the client will be added or removed.
'
 + CHAR(10) + '	[option]  specifies whether the client need to be added or removed. It takes values ADD or REM. By default ADD option is taken.
'
 + CHAR(10) + '	When executed, the qscript returns one of the following output:
'
 + CHAR(10) + '-- 	1 - successful execution'
 + CHAR(10) + '-- 	2 - for failed execution. '
 + CHAR(10) + '-- 	0 - for all status'
)
GO

