

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetClientDescription.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetClientDescription <<<'

IF EXISTS (select * from sysobjects where name='QS_SetClientDescription')
	drop procedure QS_SetClientDescription
IF EXISTS (select * from GxQscripts where name='QS_SetClientDescription')
	delete from GxQscripts where name = 'QS_SetClientDescription'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetClientDescription')
	delete from GXDBVersions where aliasname = 'QS_SetClientDescription'
GO
print '... Creating Procedure: QS_SetClientDescription'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetClientDescription
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientName varchar(1024) = '%s',
  @description varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUTS
-------------------------------------------
--DECLARE @clientName varchar(1024)
--SET @clientName = '%s'
--DECLARE @description varchar(1024)
--SET @description = '%s'
----------------------------------------
--SET @clientName ='os6car'
--SET @description = 'new desc'
----------------------------------------
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'SetClientDescription'
DECLARE @propName varchar(32)
SET @propName  = 'User Description'
DECLARE @NoParameter            varchar(10)
SET     @NoParameter            ='%'                        -- Get Around possible QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
----------- VAlidate inputs   -------------
if @clientName = @NoParameter
BEGIN
	SET @localErrorMsg = 'Error.  Client Name was not supplied as an input.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
if @description = @NoParameter
BEGIN
	SET @localErrorMsg = 'Error.  Description for Client ['+ @clientName +'] was not supplied as an input.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
DECLARE @clientId int
SET @clientId = ISNULL((select C.Id from APP_Client C where C.name = @clientName), 0)
if(@clientId = 0)
BEGIN
	SET @localErrorMsg = 'Error.  Client ['+ @clientName + '] does not exist.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
----------- Set description  -------------
UPDATE APP_Client SET clientDescription = @description WHERE id = @clientId
ARGS_ERROR:
Print ''
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: description = ['
         + @description
         + '], client = ['
         + @clientName
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetClientDescription')
	delete from GxQscripts where name = 'QS_SetClientDescription'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetClientDescription')
	delete from GXDBVersions where aliasname = 'QS_SetClientDescription'
GO

insert into GXDBVersions values(2, 'QS_SetClientDescription',  '00000000000000000000', 'QS_SetClientDescription', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetClientDescription',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetClientDescription -si client_name -si description
'
 + CHAR(10) + '--   script_name : SetClientDescription'
)
GO

