

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetClientCCSProp.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetClientCCSProp <<<'

IF EXISTS (select * from sysobjects where name='QS_SetClientCCSProp')
	drop procedure QS_SetClientCCSProp
IF EXISTS (select * from GxQscripts where name='QS_SetClientCCSProp')
	delete from GxQscripts where name = 'QS_SetClientCCSProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetClientCCSProp')
	delete from GXDBVersions where aliasname = 'QS_SetClientCCSProp'
GO
print '... Creating Procedure: QS_SetClientCCSProp'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetClientCCSProp
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @param1 nvarchar(256) = '',
  @param2 nvarchar(100) = ''
AS
	--DECLARE param1 AS nvarchar(100) = 'bingo'
	--DECLARE param2 AS nvarchar(100) = 'UseCCS=y'
--*******-----------
--CONVENIENCE DEFS--
--************----
	DECLARE @option AS INT = 0
	DECLARE @NoParams AS nvarchar(3)
	DECLARE @ErrorCode AS int
	DECLARE @ErrorString AS nvarchar(100)
	DECLARE @ScriptName AS nvarchar(100)
	DECLARE @nowtime as int
	DECLARE @isForce AS INT = 0
	DECLARE @spRC INT = 0
	DECLARE @clientName NVARCHAR(256) = ''
	DECLARE @clientId INT = NULL
	DECLARE @isCCSEnabled INT = NULL
	SET @NoParams = ''
	SET @ErrorCode = 0
	SET @ErrorString = N'Succeeded'
	SET @ScriptName = N'SetClientCCSProp'
	SET @nowtime = dbo.GetUnixTime (GetUTCDate())
--Check whether all params are passed--
	IF (@param1 = @NoParams)
	BEGIN
		-- List all CCS Clients
		SET @option = 1
	END
	ELSE
	BEGIN
		SET @clientName = @param1
		IF (@param2 = @NoParams) OR (@param2 NOT in (N'UseCCS=y' , N'UseCCS=n', N'AddCCS'))
		BEGIN
			SET @ErrorCode = 1
			SET @ErrorString = 'Error. 2nd param must be UseCCS=y|n or AddCCS.'
			GOTO ARGS_ERROR
		END
	END
	IF (@clientName <> '')
	BEGIN
		SELECT TOP 1
			@clientId = c.id,
			@isCCSEnabled = CAST(cp.attrVal AS INT)
		FROM APP_Client c WITH(NOLOCK)
			LEFT OUTER JOIN APP_ClientProp cp WITH(NOLOCK) ON
				cp.componentNameId = c.id
				AND cp.attrName = 'CCS Enabled'
				AND cp.modified = 0
		WHERE c.name = @clientName
		IF (@clientId IS NULL OR @clientId = 2)
		BEGIN
			SET @errorCode = 2
			SET @errorString = 'Error. Invalid client name [' + @clientname + '] specified.'
			GOTO ARGS_ERROR
		END
		IF (@param2 <> 'AddCCS')
		BEGIN
			IF (@isCCSEnabled IS NULL)
			BEGIN
				SET @errorCode = 3
				SET @errorString = 'Error. Invalid client name [' + @clientname + '] ''CCS Enabled'' property not set for client.'
				GOTO ARGS_ERROR
			END
		END
		ELSE
		BEGIN
			IF (@isCCSEnabled IS NOT NULL)
			BEGIN
				SET @errorCode = 3
				SET @errorString = 'Error. Invalid operation for client name [' + @clientname + '] ''CCS Enabled'' property is set for client, perform an enable operation.'
				GOTO ARGS_ERROR
			END
		END
	END
--All successful---
	-- APPCCSControls options
	--	Opcode=1: Get list of clients with 'CCS Enabled' property
	--	Opcode=9: Disable Client CCS Enabled Property for @clientId [@force=1]
	--	Opcode=10: Enable Client CCS Enabled Property for @clientId [@force=1]
	--  Opcode=4: Insert Client CCS Enabled Property for @clientId
	IF (@clientId IS NOT NULL AND @clientId <> 0)
	BEGIN
		IF (@param2 = 'AddCCS')
		BEGIN
			SET @option = 4
		END
		ELSE IF SUBSTRING(@param2,LEN(N'UseCCS=')+1,LEN(@param2)-LEN(N'UseCCS=')) = 'y'
		BEGIN
			SET @isForce = 1	-- automatically force changes to take effect to re-sync Clients for CCS
			SET @option = 10
		END
		ELSE
		BEGIN
			SET @isForce = 1	-- automatically force changes to take effect to re-sync Clients for CCS
			SET @option = 9
		END
	END
	BEGIN TRY
		IF (@option = 1)
		BEGIN
			EXEC @spRC = APPCCSControls @opCode=@option
		END
		ELSE
		BEGIN
			EXEC @spRC = APPCCSControls @clientId=@clientId, @opCode=@option, @force=@isForce
		END
		IF @spRC <> 0
		BEGIN
			SET @ErrorCode = @spRC
			SET @ErrorString = 'Error APPCCSControls failed, see output.'
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode = ERROR_NUMBER()
		SET @errorString = ERROR_MESSAGE()
		GOTO ARGS_ERROR
	END CATCH
ARGS_ERROR:
	PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+ @param1 + ', ' + @param2 +
         + ']. Exit Code(' +convert(varchar(2), @ErrorCode) + ').'
IF @ErrorCode <> 0
	Raiserror(@ErrorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetClientCCSProp')
	delete from GxQscripts where name = 'QS_SetClientCCSProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetClientCCSProp')
	delete from GXDBVersions where aliasname = 'QS_SetClientCCSProp'
GO

insert into GXDBVersions values(2, 'QS_SetClientCCSProp',  '00000000000000000000', 'QS_SetClientCCSProp', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetClientCCSProp',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetClientCCSProp.sql [ -si ''clientName'' (-si UseCCS=y|n | -si AddCCS) ]
'
 + CHAR(10) + '-- 	script_name: SetClientCCSProp'
 + CHAR(10) + '-- 	Qscript to get/enable/disable/add CommServer Client Side (CCS) Database operations for client.'
)
GO

