

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetCleanupTimeOut.sp] ---------- 

-------------------------------------------
--         Name:   QS_SetCleanupTimeOut.sql
--         Date:   29-Sep-2011
--       Author:   Gokul Pattabiraman
--  Description:   Set the cleanup timeout of all jobs
--
-- TR(original):   None
--     Customer:   RackSpace
--   CommcellId:   N/A (generic)
-------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetCleanupTimeOut <<<'

IF EXISTS (select * from sysobjects where name='QS_SetCleanupTimeOut')
	drop procedure QS_SetCleanupTimeOut
IF EXISTS (select * from GxQscripts where name='QS_SetCleanupTimeOut')
	delete from GxQscripts where name = 'QS_SetCleanupTimeOut'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetCleanupTimeOut')
	delete from GXDBVersions where aliasname = 'QS_SetCleanupTimeOut'
GO
print '... Creating Procedure: QS_SetCleanupTimeOut'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetCleanupTimeOut
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--  3 Corresponds to "medium", same as same functionality in GUI.  Macro doesn't expand right for some reason
-- Qscript Usage.
  @inTimeOutValue INTEGER			-- Must always have this parameter
AS
Set NOCOUNT ON
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'QS_SetCleanupTimeOut'
DECLARE @created				AS integer		= 0
DECLARE @nowTime				AS integer		= dbo.GetUnixTime (GetUTCdate())
-------- Local Variables    -------------
--
DECLARE @localErrorMsg			AS	VARCHAR(512)	='Error Encountered when running script.'
DECLARE @lastError				AS	integer = 0							-- Be optimistic
--
--
--- CHECK IF MINIMUM (& VALID!) PARAMETERS SPECIFIED	 ---
------------------------------------------------------------
IF ISNULL(@inTimeOutValue, 0) < 5
BEGIN
	SET @localErrorMsg	='Error. Timeout value is either unspecified or too low. Minimum is 5 minutes.'
	SET @lastError = 1
	GOTO   ARGS_ERROR
END
--
--
BEGIN TRY
	UPDATE JMPHASE
	SET cleanupTimeout = @inTimeOutValue*60*1000
END TRY
--
--
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    Set @lastError      = ERROR_NUMBER()
    SET @localErrorMsg  = ERROR_MESSAGE()
END   CATCH
--
--
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetCleanupTimeOut')
	delete from GxQscripts where name = 'QS_SetCleanupTimeOut'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetCleanupTimeOut')
	delete from GXDBVersions where aliasname = 'QS_SetCleanupTimeOut'
GO

insert into GXDBVersions values(2, 'QS_SetCleanupTimeOut',  '00000000000000000000', 'QS_SetCleanupTimeOut', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetCleanupTimeOut',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		qoperation execscript -sn QS_SetCleanupTimeOut -si <the timeout in minutes>'
 + CHAR(10) + '--       Example: qoperation execscript -sn QS_SetCleanupTimeOut -si 15'
)
GO

