

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetCSHostNameForPseudoClients.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  QS_SetCSHostNameForPseudoClients()
--  | Description:  Set CommServer host name for pseudo clients
--  +========================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_SetCSHostNameForPseudoClients')
BEGIN
	print '>>> Drop Stored Procedure: QS_SetCSHostNameForPseudoClients <<<'
	drop procedure QS_SetCSHostNameForPseudoClients
END
IF EXISTS (select * from GxQscripts where name='QS_SetCSHostNameForPseudoClients')
	delete from GxQscripts where name = 'QS_SetCSHostNameForPseudoClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetCSHostNameForPseudoClients')
	delete from GXDBVersions where aliasname = 'QS_SetCSHostNameForPseudoClients'
GO
print '... Creating Procedure: QS_SetCSHostNameForPseudoClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetCSHostNameForPseudoClients
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--QScript Usage. Do not use special char in HTML
  @oldCSName NVARCHAR(256)
AS
SET NOCOUNT ON
DECLARE @scriptName NVARCHAR(128) = 'QS_SetCSHostNameForPseudoClients'
DECLARE @errorCode				INTEGER
DECLARE @errorString			NVARCHAR(1024)
DECLARE @currentCSName			NVARCHAR(256)
BEGIN TRY
	--INSERT/UPDATE Operation
	BEGIN
		SET @errorCode = 0
		SET @errorString = 'Successful'
        -- USER VALIDATION
		--Existence of table and fetching of top 1 userId is done for safety measures
		IF OBJECT_ID('tempdb.dbo.#tempQSUser') IS NULL
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'No logged in user found.'
			goto   SCRIPT_EXIT
		END
		DECLARE @userId INT
		SET @userId = 0
		SET @userId =  ISNULL( (select TOP 1 userId from #tempQSUser),0)
		IF @userId = 0
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'No logged in user found.'
			goto   SCRIPT_EXIT
		END
		--Input validation and assignation--
		--1. Null and empty check
		IF @oldCSName = ''
		BEGIN
			SET @ErrorCode = 2
			SET @ErrorString = 'Error. Input param must be old CommServer host name specified as oldCSName'
			GOTO SCRIPT_EXIT
		END
		ELSE
		BEGIN
			SET @currentCSName = (SELECT net_hostname FROM App_Client WHERE id = 2)
			UPDATE App_Client SET csHostName = @currentCSName
			WHERE csHostName = @oldCSName AND specialClientFlags & 2 = 2 -- specialClientFlags 2 indicates pseudo clients
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @errorCode = ERROR_NUMBER()
    set @errorString = ERROR_MESSAGE()
END CATCH
SCRIPT_EXIT:
PRINT @scriptName + ' completed at '
            + Convert(varchar(60), getdate())
            + ' with Parameters: ['+@oldCSName+']. Execution('+ @errorString +').'
IF @errorCode <> 0
BEGIN
  PRINT @scriptName + ' failed. ErrorCode ['+ Convert(varchar(2),@errorCode) +'].'
  RAISERROR(@errorString,
                15,  --Severity (> 10 to force DOS Error Code = 1)
                1    --State
                )
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetCSHostNameForPseudoClients')
	delete from GxQscripts where name = 'QS_SetCSHostNameForPseudoClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetCSHostNameForPseudoClients')
	delete from GXDBVersions where aliasname = 'QS_SetCSHostNameForPseudoClients'
GO

insert into GXDBVersions values(2, 'QS_SetCSHostNameForPseudoClients',  '00000000000000000000', 'QS_SetCSHostNameForPseudoClients', '00000000000000000000')
GO

insert into GxQscripts values(2+8,'QS_SetCSHostNameForPseudoClients',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '    Update CommServer host name for clients with no packages installed.
'
 + CHAR(10) + '    Example: qoperation execscript -sn QS_SetCSHostNameForPseudoClients.sql -si oldCSName
'
)
GO

