

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetAuxCopyJobPriority.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_SetAuxCopyJobPriority')
BEGIN
	print '>>> Drop Stored Procedure: QS_SetAuxCopyJobPriority <<<'
	drop procedure QS_SetAuxCopyJobPriority
END
IF EXISTS (select * from GxQscripts where name='QS_SetAuxCopyJobPriority')
	delete from GxQscripts where name = 'QS_SetAuxCopyJobPriority'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetAuxCopyJobPriority')
	delete from GXDBVersions where aliasname = 'QS_SetAuxCopyJobPriority'
GO
print '... Creating Procedure: QS_SetAuxCopyJobPriority'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_SetAuxCopyJobPriority
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @enabled varchar(64) = '%s',
  @priority varchar(64) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- Input Params --
-------------------------------------------
--DECLARE @enabled	varchar(64)
--SET @enabled =		'%s'
--DECLARE @priority	varchar(64)
--SET @priority =		'%s'
--------------------------------------------
-- Testing --
--------------------------------------------
--SET @enabled =		'Y'
--SET @priority =		'127'
--------------------------------------------
-- Convenience Definitions --
--------------------------------------------
DECLARE @scriptName			varchar(32)
SET		@scriptName	=		'SetAuxCopyJobPriority'
DECLARE @transactionName	varchar(32)
SET @transactionName =		'SetAuxCopyPriorityTran'
DECLARE @propName varchar(32)
SET @propName  = 'JMAuxCopyCombinedPriority'
DECLARE @nowTime int
Set     @nowTime =  datediff(second, '01/01/1970', GetUTCdate())
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
--------------------------------------------
-- Local Variables --
--------------------------------------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
DECLARE @operationPriority		integer = 0
--------------------------------------------
--------------------------------------------
-- @enabled is compulsory param
if (@enabled = @noParameter) or (LOWER(@enabled) <> 'y' and LOWER(@enabled) <> 'n')
BEGIN
	SET @localErrorMsg = 'Error.  Invalid enabled paramater value. Enter [y] to enable and [n] to disable.'
	Set @lastError = 1
	goto	ARGS_ERROR
END
-- If @enabled is true, Validate @priority
if (LOWER(@enabled) = 'y')
	if @priority = @noParameter or ((convert(int, @priority)) < 1 or (convert(int, @priority)) > 999)
	BEGIN
		SET @localErrorMsg = 'Error.  Invalid Priority parameter  value. Priority value should be between 1 and 999.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
BEGIN TRY
BEGIN TRANSACTION @transactionName
	DELETE from GxGlobalParam where name = @propName
	if (@enabled ='y')
	BEGIN
		INSERT INTO GxGlobalParam  VALUES (@propname, @priority,@nowTime,0)
		IF @priority > 100
			SET @operationPriority = @priority / 100
		ELSE IF @priority > 10
			SET @operationPriority = @priority / 10
		ELSE SET @operationPriority = @priority
		UPDATE GxGlobalParam SET value = @operationPriority WHERE name = 'JMAuxCopyPriority'
	END
COMMIT TRANSACTION @transactionName
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	ROLLBACK TRANSACTION @transactionName
	SET @localErrorMsg = 'Error.  Database error occured. Please retry'
	Set @lastError = 1
	goto   ARGS_ERROR
END CATCH
ARGS_ERROR:
	Print ''
	PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: Enabled = ['
         + convert(varchar(4),@enabled)
         + '], Priority = ['
         + convert(varchar(4),@priority)
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
	if (@lastError <> 0)
		Raiserror(@localErrorMsg,
				    15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetAuxCopyJobPriority')
	delete from GxQscripts where name = 'QS_SetAuxCopyJobPriority'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetAuxCopyJobPriority')
	delete from GXDBVersions where aliasname = 'QS_SetAuxCopyJobPriority'
GO

insert into GXDBVersions values(2, 'QS_SetAuxCopyJobPriority',  '00000000000000000000', 'QS_SetAuxCopyJobPriority', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetAuxCopyJobPriority',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetAuxCopyJobPriority.sql -si y or n -si priorityvalue
'
 + CHAR(10) + '--   script_name : SetAuxCopyJobPriority'
)
GO

