

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SetAsFBRMA.sp] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='QS_SetAsFBRMA')
BEGIN
	print '>>> Drop Stored Procedure: QS_SetAsFBRMA <<<'
	drop procedure QS_SetAsFBRMA
END
IF EXISTS (select * from GxQscripts where name='QS_SetAsFBRMA')
	delete from GxQscripts where name = 'QS_SetAsFBRMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetAsFBRMA')
	delete from GXDBVersions where aliasname = 'QS_SetAsFBRMA'
GO
print '... Creating Procedure: QS_SetAsFBRMA'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure QS_SetAsFBRMA
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @clientName nvarchar(100) = N'',
  @propVal nvarchar(10) =  N'',
  @propValFBRTemplate nvarchar(10) =  N''
AS
DECLARE @ClientID AS int=0
DECLARE @ErrorCode AS int=0
DECLARE @ErrorString AS nvarchar(100)= N'Succeeded'
DECLARE @ScriptName AS nvarchar(100)=N'SetAsFBRMA'
DECLARE @nowtime as int = dbo.GetUnixTime (GetUTCDate())
--Check whether all params are passed--
IF (@clientName = N'')
BEGIN
	SET @ErrorCode = 1
	SET @ErrorString = 'Error. 1st param must be client name specified as c=clientname'
	GOTO ARGS_ERROR
END
IF (@propVal NOT in ('0','1'))
BEGIN
	SET @ErrorCode = 1
	SET @ErrorString = 'Error. 2nd param must be 0/1'
	GOTO ARGS_ERROR
END
IF (@propValFBRTemplate NOT in ('0','1'))
BEGIN
	SET @ErrorCode = 1
	SET @ErrorString = 'Error. 3rd param must be 0/1'
	GOTO ARGS_ERROR
END
--Validation of client--
SET @ClientID = ISNULL((SELECT id FROM APP_Client WHERE name = @clientName),0)
IF @ClientID = 0
BEGIN
	SET @ErrorCode = 1
	SET @ErrorString = 'Error. Invalid client[' + @clientName + '] specified.'
	GOTO ARGS_ERROR
END
--All successful---
IF EXISTS (SELECT * FROM App_Platform WHERE clientId = @ClientID AND platformType = 2)
BEGIN
	BEGIN TRY
		--If property 'FBR MediaAgent' already exists, then update it--
		IF EXISTS (SELECT *
					FROM APP_ClientProp
WHERE componentNameId = @ClientID AND attrName = N'FBR MediaAgent')
		BEGIN
				UPDATE APP_ClientProp
				SET attrval = @propVal
WHERE componentNameId = @ClientID and attrName = N'FBR MediaAgent' and modified = 0
		END
		ELSE
		BEGIN
			INSERT APP_ClientProp(componentNameId , attrName, attrtype, attrVal, created , modified , ccpId )
VALUES (@ClientID , N'FBR MediaAgent', 2, @propVal, @nowtime ,0,0)
		END
		--If property 'FBR MediaAgent From Template' already exists, then update it--
		IF EXISTS (SELECT *
					FROM APP_ClientProp
WHERE componentNameId = @ClientID AND attrName = N'FBR MediaAgent From Template')
		BEGIN
				UPDATE APP_ClientProp
				SET attrval = @propValFBRTemplate
WHERE componentNameId = @ClientID and attrName = N'FBR MediaAgent From Template' and modified = 0
		END
		ELSE
		BEGIN
			INSERT APP_ClientProp(componentNameId , attrName, attrtype, attrVal, created , modified , ccpId )
VALUES (@ClientID , N'FBR MediaAgent From Template', 2, @propValFBRTemplate, @nowtime ,0,0)
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode = ERROR_NUMBER ()
		SET @errorString = ERROR_MESSAGE ()
		GOTO ARGS_ERROR
	END CATCH
END
ELSE
BEGIN
	--Not a mediaagent
	SET @ErrorCode = 1
	SET @ErrorString = 'Error. Client [' + @clientname + '] is not a media agent.'
	GOTO ARGS_ERROR
END
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@clientName + ', '+@propVal +
         + ']. Exit Code(' +convert(varchar(2), @ErrorCode) + ').'
IF @ErrorCode <> 0
Raiserror(@ErrorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetAsFBRMA')
	delete from GxQscripts where name = 'QS_SetAsFBRMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetAsFBRMA')
	delete from GXDBVersions where aliasname = 'QS_SetAsFBRMA'
GO

insert into GXDBVersions values(2, 'QS_SetAsFBRMA',  '00000000000000000000', 'QS_SetAsFBRMA', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_SetAsFBRMA',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn SetAsFBRMA.sql -si clientName -si ''0/1'' -si ''0/1'' 
'
 + CHAR(10) + '-- 	script_name: SetAsFBRMA'
 + CHAR(10) + '-- 	Qscript to set/Unset client as FBR MA. '
)
GO

