

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ServerProtection.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_ServerProtection.sp,v $ $Id: QS_ServerProtection.sp,v 1.6.80.6 2018/03/20 00:46:00 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ServerProtection <<<'

IF EXISTS (select * from sysobjects where name='QS_ServerProtection')
	drop procedure QS_ServerProtection
IF EXISTS (select * from GxQscripts where name='QS_ServerProtection')
	delete from GxQscripts where name = 'QS_ServerProtection'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ServerProtection')
	delete from GXDBVersions where aliasname = 'QS_ServerProtection'
GO
print '... Creating Procedure: QS_ServerProtection'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_ServerProtection
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_nLastDays int = 0,
  @i_bSummary int = 2,
  @i_clientGroup NVARCHAR(512) 	= N'',
  @i_BillableEntity varchar(50) = '',
  @i_MaxDaysforBackup int = 0,
  @i_backupType varchar(16) = '',
  @i_includeDeconfiguredSubclients int =0
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--Below are the input parameters and their desc
--	@i_nLastDays  INTEGER			=	0, --Number of days. This is valid only if bSummary is 1 or 3. Give 0 to disabile time filter
--	@i_bSummary   INTEGER			=	2, -- 1-> Report: Summarization (SLA) By Client Group or Billing entity, 2-> Report: Server Protection Status, 3-> Report: Detailed Server Report
--	@i_clientGroup NVARCHAR(512)	=	N'',--filter applicable in the case of bSummary 1 or 2
--	@i_BillableEntity VARCHAR(50) =	'',--filter applicable in the case of bSummary 1 or 2
--  @i_MaxDaysforBackup INTEGER = 0, --filter applicable in the case of bSummary 2, specify  maximum days for backup
--  @i_backupType varchar(16) = ''; --filter applicable in the case of bSummary 2, specify backup type Full, Differential, Other, Incremental, SyntheticFull
if (@i_bSummary <1 OR @i_bSummary >3) --invalid input, so return
	return;
if @i_nLastDays < 0
	set @i_nLastDays = 0;
DECLARE @SERVERS TABLE (clientId INT, isVM int);
INSERT INTO @SERVERS
SELECT C.id, CASE WHEN CP.componentNameId IS NOT NULL THEN 1 ELSE 0 END
FROM APP_Client C
		LEFT OUTER JOIN APP_ClientProp CP
			ON C.id = CP.componentNameId AND CP.attrName = 'Virtual Server Discovered Clients' AND CP.modified = 0
IF @i_clientGroup <> ''
BEGIN
	DECLARE @i_clientGroupId int = 0;
	set @i_clientGroupId = (select id from APP_ClientGroup where name = @i_clientGroup)
	DELETE FROM @SERVERS
	WHERE clientId NOT IN (SELECT clientId FROM APP_ClientGroupAssoc WHERE clientGroupId = @i_clientGroupId)
END
DECLARE @csTimeZoneName NVARCHAR(1024) = (SELECT timeZone FROM APP_CommCell WHERE id = 2)
SELECT  @csTimeZoneName = TimeZoneStdName
FROM    SchedTimeZone
WHERE   TimeZoneName = SUBSTRING(@csTimeZoneName, CHARINDEX(':', @csTimeZoneName, CHARINDEX(':', @csTimeZoneName, 0) + 1) + 1, 255)
DECLARE @Today      DATETIME = DATEDIFF(DAY, 0, GETUTCDATE())
DECLARE @StartTime  INT
IF(@i_nLastDays <= 0)
	SET	@StartTime = 0
ELSE
	SET @StartTime = dbo.GetUnixTime(DATEADD(DAY, -@i_nLastDays, @Today))
BEGIN --begin client
	IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#tblSubclient'))
         DROP TABLE #tblSubclient
CREATE TABLE #tblSubclient (ClientId INT, AppTypeId INT, InstanceId INT, BackupsetId INT, AppId INT, SubclientName NVARCHAR(128),
								ClientGroupList NVARCHAR(MAX))
	INSERT  INTO #tblSubclient
	SELECT  A.clientId, A.appTypeId, A.instance, A.backupSet, A.id, A.SubclientName, ''
	FROM    APP_Application A
				JOIN APP_BackupSetName BKPSET
					ON A.backupSet = BKPSET.id AND ((BKPSET.status = 24 AND A.appTypeId NOT IN (37,62)) OR BKPSET.status <> 24)
	WHERE   dbo.IsSubClientValid(A.appTypeId, A.subclientStatus, 0) = 1
				AND A.id NOT IN (SELECT componentNameId FROM APP_subclientProp WHERE attrName = 'DDB Backup' AND attrVal <> '0' AND modified = 0)
				AND A.clientId NOT IN (SELECT componentNameId
										FROM APP_ClientProp WHERE attrName = 'Content Index Server' AND attrVal = '1' AND modified = 0)
				AND ( @i_includeDeconfiguredSubclients =1 or (A.subclientStatus & 2) <> 2 )
				AND ( @i_includeDeconfiguredSubclients =1 or (A.subclientStatus & 4) <> 4 )
	DELETE #tblSubclient
	FROM #tblSubclient S
	INNER JOIN JMJobAction J WITH (NOLOCK)
    	ON  J.opType IN (4, 14, 76) AND J.action = 1
        AND (J.clientId = S.clientId AND appType IN (S.appTypeId, 0) OR J.appId = S.AppId)
	DELETE #tblSubclient
	FROM #tblSubclient S
        INNER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON S.clientId = CGA.clientId
        INNER JOIN JMJobAction J WITH (NOLOCK) ON CGA.clientGroupId = J.clientGroupId
            AND J.clientGroupId > 0 AND J.ClientId = 1 AND J.AppType = 0 AND J.AppId = 1
            AND J.opType IN (4, 14, 76) AND J.action = 1
	IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#tblSubclientAggr'))
         DROP TABLE #tblSubclientAggr
	CREATE TABLE #tblSubclientAggr (	clientId INT
										, AppId INT
										, nSuccessfulJobs INT
										, nUnsuccessfulJobs INT
										, LastSuccessfulBackupJobID INT
										, LastSuccessfulBackupJobTime INT
										, BackupJobID INT
										, BackupType INT
										, BackupStartTime INT
										, BackupEndTime INT
										, BackupStatus INT
, BackupFailureReason	varchar(256)
										, numOfProtectedObjects BIGINT
										, numOfFailedObjects	BIGINT
	)
	INSERT  INTO #tblSubclientAggr
	SELECT  S.ClientId,
			S.AppId,
			ISNULL(SUM(CASE WHEN B.jobId IS NOT NULL AND B.status IN (1, 3, 14) THEN 1 ELSE 0 END),0) AS nSuccessfulJobs,
			ISNULL(SUM(CASE WHEN B.jobId IS NOT NULL AND B.status NOT IN (1, 3, 14) THEN 1 ELSE 0 END),0) AS nUnsuccessfulJobs,
			ISNULL(MAX(CASE WHEN B.status IN (1, 3, 14) THEN B.jobId ELSE 0 END), 0) AS LastSuccessfulBackupJobID,
			ISNULL(MAX(CASE WHEN B.status IN (1, 3, 14) THEN B.servEndDate ELSE 0 END),0) AS LastSuccessfulBackupJobTime,
			ISNULL(MAX(B.jobId),0) AS BackupJobID,
			0 AS BackupType,
			0 AS BackupStartTime,
			0 AS BackupEndTime,
			0 AS BackupStatus--, 0
			, ''
			, 0
			, 0
	FROM    #tblSubclient S
				INNER JOIN JMBkpStats B
					ON B.appId = S.AppId
	WHERE   B.bkpLevel IN (1, 2, 4, 64, 256, 1024, 32768) AND B.commCellId = 2
	GROUP BY S.ClientId, S.AppId
END --end client
BEGIN--vm begin
	IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#VMJobInfo'))
         DROP TABLE #VMJobInfo
	CREATE TABLE #VMJobInfo (
		commcellid					INT,
		clientId					INT,
		clientGroupList				NVARCHAR(MAX),
		appId						INT,
		appTypeName					varchar(256),
		LastSuccessfulBackupJobId	INT,
		LastSuccessfulBackupTime	INT,
		BackupJobID				BIGINT,
		BackupStatus			INT,
		BackupType				INT,
		BackupStartTime			INT,
		BackupEndTime			INT,
		TotalTimeForLastBackup		BIGINT,
BackupSetName				NVARCHAR(128),
		InstanceName				NVARCHAR(512),
SubClientName				NVARCHAR(128),
		VMSize						BIGINT,
		VMDataWrittenSize			BIGINT,
		VMBackedupSize				BIGINT
	)
	INSERT	INTO #VMJobInfo
	SELECT	JMQ.commCellId,
			JMQ.clientId,
			'' AS clientGroupList,
			MAX(B.appId),
			'' as appTypeName,
			ISNULL(MAX(CASE  WHEN B.status in ( 1,3,14,16)  THEN(
						CASE	WHEN V.attrVal IS NOT NULL AND V.attrVal IN ('0', '3')
							THEN B.jobid
						WHEN V.attrVal IS  NULL AND JMQ.status IN (1,3)
							THEN B.jobId
						ELSE 0
						END)
				END), 0) as LastSuccessfulBackupJobId,
			0 as LastSuccessfulBackupTime,
			MAX(B.jobId) as BackupJobID,
			0 AS BackupStatus,
			0 as BackupType,
			0 as BackupStartTime,
			0 AS BackupEndTime,
			0 as TotalTimeForLastBackup,
			NULL as BackupSetName,
			NULL AS InstanceName,
			NULL AS SubClientName,
			0 AS VMSize,
			0 AS VMDataWrittenSize,
			0 AS VMBackedupSize
	FROM JMQinetixUpdateStatus JMQ
		INNER JOIN JMBkpStats B
			ON	B.jobId = JMQ.jobId
			AND	B.commCellId = B.commCellId
		LEFT OUTER JOIN APP_VMProp V
			ON	JMQ.jobId = V.jobId
			AND	JMQ.commCellId = V.commCellId
			AND	JMQ.clientId = V.VMclientId
			AND	V.attrName = 'vmStatus'
	WHERE	B.appType = 106
	GROUP BY
		JMQ.clientId, JMQ.commCellId
	--DEBUG
	--SELECT * FROM #VMJobInfo
	-----------------------------------------------------------------
	-- Exclude Deleted VMs
	-----------------------------------------------------------------
	DELETE #VMJobInfo
	FROM #VMJobInfo VJ
	INNER JOIN  APP_ClientProp WITH (NOLOCK)
	ON attrName = 'Virtual Machine Deletion Time' AND ISNULL(attrVal, '0') <> '0' AND modified = 0
		  AND componentNameId = VJ.clientId
END --end vm
--SUMMARY1 begin
IF @i_bSummary = 1
BEGIN
	IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#tblClientAggr'))
         DROP TABLE #tblClientAggr
	CREATE TABLE #tblClientAggr (clientId int, isProtected int);
	INSERT INTO #tblClientAggr
	SELECT  DISTINCT A.clientId, CASE WHEN MIN(nSuccessfulJobs) = 0 THEN 0 ELSE 1 END
	FROM	#tblSubclientAggr A
				JOIN @SERVERS SRV ON A.clientId = SRV.clientId
				JOIN JMBkpStats	B ON A.BackupJobID = B.jobId
	WHERE	(B.servEndDate > @StartTime OR @StartTime = 0)
	GROUP	BY A.clientId
	ORDER	BY A.clientId
	INSERT INTO #tblClientAggr
	SELECT	V.clientId, CASE WHEN LastSuccessfulBackupJobId > 0 THEN 1 ELSE 0 END
	FROM	#VMJobInfo V
				JOIN @SERVERS SRV
					ON V.clientId = SRV.clientId
				JOIN JMBkpStats B
					ON V.BackupJobID = B.jobId
	WHERE	 (B.servEndDate > @StartTime OR @StartTime = 0)
	SELECT	COUNT(clientId) 'Total Clients'
			, (SELECT COUNT(CLientId) from #tblClientAggr where isProtected = 1) as Protected
			, (SELECT COUNT(CLientId) from #tblClientAggr where isProtected = 0) as 'Not Protected'
			, (SUBSTRING((SELECT '; '+ name from #tblClientAggr Aggr join APP_Client C on Aggr.clientId = C.id where isProtected = 0 FOR XML PATH('')), 3,1000)) as 'Non Protected Client List'
	FROM #tblClientAggr
	DROP TABLE #tblSubclient
	DROP TABLE #tblSubclientAggr
	DROP TABLE #VMJobInfo
	DROP TABLE #tblClientAggr
	RETURN;
END--END SUMMARY1
BEGIN
	IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#VMInfo'))
         DROP TABLE #VMInfo
	CREATE TABLE #VMInfo (
		clientId			INT,
VMName				NVARCHAR(255)
	)
	IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#VMTotalSize'))
         DROP TABLE #VMTotalSize
	CREATE TABLE #VMTotalSize (
		vmJobId				INT,
		TotalVMBackupSize	BIGINT,
		DataWritten			BIGINT
	)
	IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#tblClientGroupList'))
         DROP TABLE #tblClientGroupList
	IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#tblClientGroupKey'))
         DROP TABLE #tblClientGroupKey
    CREATE TABLE #tblClientGroupList (Key1 BIGINT, Key2 BIGINT, ClientGroupList NVARCHAR(MAX))
    CREATE TABLE #tblClientGroupKey (ClientId INT, Key1 BIGINT, Key2 BIGINT)
    INSERT INTO #tblClientGroupKey
    SELECT  clientId, SUM(clientGroupId), SUM(clientGroupId*clientGroupId)
    FROM    APP_ClientGroupAssoc
    GROUP BY clientId
    DECLARE ClientGroupListCursor CURSOR FOR
    SELECT  Key1, Key2, CG.name
    FROM    APP_ClientGroup CG, APP_ClientGroupAssoc CGA,
            (SELECT Key1, Key2, MIN(ClientId) AS ClientId
            FROM    #tblClientGroupKey
            GROUP BY Key1, Key2) T
    WHERE   CG.id = CGA.clientGroupId AND CGA.clientId = T.ClientId
    ORDER BY Key1, Key2, CG.id
    DECLARE @k1     BIGINT = 0
    DECLARE @k2     BIGINT = 0
    DECLARE @key1   BIGINT = 0
    DECLARE @key2   BIGINT = 0
    DECLARE @name   NVARCHAR(512) = ''
    DECLARE @list   NVARCHAR(MAX) = ''
    OPEN ClientGroupListCursor
        FETCH NEXT FROM ClientGroupListCursor INTO @k1, @k2, @name
    WHILE @@FETCH_STATUS = 0
    BEGIN
        IF  @k1 = @key1 AND @k2 = @key2
            SET @list = (@list + ', ' + @name)
        ELSE
        BEGIN
            IF  @key1 > 0 AND @key2 > 0
                INSERT  INTO #tblClientGroupList
                SELECT  @key1, @key2, @list
            SET @list = @name
            SET @key1 = @k1
            SET @key2 = @k2
        END
        FETCH NEXT FROM ClientGroupListCursor INTO @k1, @k2, @name
    END
    CLOSE ClientGroupListCursor
    DEALLOCATE ClientGroupListCursor
    IF  @key1 > 0 AND @key2 > 0
        INSERT  INTO #tblClientGroupList
        SELECT  @key1, @key2, @list
    UPDATE  #tblSubclientAggr
    SET     BackupStartTime = B.servStartDate
			, BackupEndTime = B.servEndDate
			, BackupType = B.bkpLevel
			, BackupStatus = B.status
			--, LastBackupAppSize = B.totalUncompBytes
			--, BackupFailureReason = B.failureReason
    FROM    #tblSubclientAggr S INNER JOIN JMBkpStats B
        ON B.jobId = S.BackupJobID AND B.commCellId = 2
	IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#ClientDPCoverage'))
         DROP TABLE #ClientDPCoverage
	CREATE TABLE #ClientDPCoverage (
			clientId			int,
ClientName          NVARCHAR(255),
			ClientGroup         NVARCHAR(MAX),
			Agent               VARCHAR(256),
			Instance            NVARCHAR(512),
Backupset           NVARCHAR(128),
			AppId				INT,
Subclient           NVARCHAR(128),
			SuccessfulJobs      INTEGER,
			UnsuccessfulJobs    INTEGER,
			SuccessfulBackupJobId		INT,
			SuccessfulBackupJobTime		INT,
			DaysSinceLastSuccessfulBackupJob INT,
			BackupJobID     INTEGER,
			BackupType      NVARCHAR(16),
			BackupStartTime    VARCHAR(20),
			BackupEndTime      VARCHAR(20),
			BackupStatus       NVARCHAR(32),
			DataWritten	BIGINT
			, BackupFailureReason NVARCHAR(1024)
			, numOfProtectedObjects BIGINT
			, numOfFailedObjects	BIGINT
	 );
    INSERT  INTO #ClientDPCoverage
    SELECT
			CL.id	as ClientId,
			CL.name AS ClientName,
            ISNULL(L.ClientGroupList,'') AS ClientGroup,
            IDA.name,
            dbo.FixInstanceName(INST.name, S.AppTypeId),
            BSN.name Backupset,
            A.AppId as AppId,
            S.SubclientName,
            ISNULL(A.nSuccessfulJobs, 0) AS SuccessfulJobs,
            ISNULL(A.nUnsuccessfulJobs, 0) AS UnSuccessfulJobs,
            A.LastSuccessfulBackupJobID AS SuccessfulBackupJobId ,
			A.LastSuccessfulBackupJobTime AS SuccessfulBackupJobTime,
            CASE WHEN ISNULL(A.LastSuccessfulBackupJobTime, 0) = 0 THEN -1
				 ELSE DATEDIFF(D, dbo.GetDateTime(A.LastSuccessfulBackupJobTime), GETUTCDATE()) END AS DaysSinceLastSuccessfulBackupJob,
            ISNULL(A.BackupJobID, 0) AS BackupJobID,
            CASE WHEN ISNULL(A.BackupType, 0) = 0 THEN 'N/A'
                 ELSE dbo.GetJobBackupTypeDisplay(A.BackupType) END AS BackupType,
            CASE WHEN ISNULL(A.BackupStartTime, 0) = 0 THEN 'N/A'
                 ELSE dbo.UTCToLocalStringTime(dbo.GetDateTime(A.BackupStartTime), @csTimeZoneName) END AS BackupStartTime,
            CASE WHEN ISNULL(A.BackupEndTime, 0) = 0 THEN 'N/A'
                 ELSE dbo.UTCToLocalStringTime(dbo.GetDateTime(A.BackupEndTime), @csTimeZoneName) END AS BackupEndTime,
            CASE WHEN ISNULL(A.BackupStatus, 0) = 0 THEN 'No Run'
                 WHEN A.BackupStatus = 1  THEN 'Completed'
                 WHEN A.BackupStatus = 3  THEN 'Completed With Errors'
                 WHEN A.BackupStatus = 14 THEN 'Completed With Warnings'
                 WHEN A.BackupStatus IN (2, 9)  THEN 'Failed'
                 WHEN A.BackupStatus IN (4, 15) THEN 'Killed' END AS BackupStatus,
            0 AS DataWritten
            --, ROUND(ISNULL(A.LastBackupAppSize, 0)/1024.0/1024.0/1024.0, 2) AS LastBackupAppSizeGB
            , ''--, dbo.JMGetLocalizedMessageFunc(0, ISNULL(A.BackupFailureReason, '')) AS BackupFailureReason
            , 0
            , 0
    FROM    #tblSubclient S
            LEFT OUTER JOIN #tblSubclientAggr A ON A.AppId = S.AppId
            INNER JOIN APP_Client CL ON CL.id = S.ClientId
            INNER JOIN APP_iDAType IDA ON IDA.type = S.AppTypeId
            INNER JOIN APP_InstanceName INST ON INST.id = S.InstanceId
            INNER JOIN APP_BackupsetName BSN ON BSN.id = S.BackupsetId
            LEFT OUTER JOIN #tblClientGroupKey  K ON K.ClientId = S.ClientId
            LEFT OUTER JOIN #tblClientGroupList L ON L.Key1 = K.Key1 AND L.Key2 = K.Key2
    WHERE   CL.origCCId NOT IN (SELECT id FROM APP_CommCell WHERE type > 1) AND (INST.status & 2048) = 0
    ORDER BY CASE WHEN CL.clientDescription LIKE '%offline%' THEN 1 ELSE 0 END DESC,
            (CASE WHEN ISNULL(A.nSuccessfulJobs, 0) > 0 THEN 2 WHEN ISNULL(A.nUnsuccessfulJobs, 0) > 0 THEN 1 ELSE 0 END),
            CL.name,
            IDA.name,
            BSN.name,
            S.SubclientName
	UPDATE #ClientDPCoverage
    SET     DataWritten = X.sizeOnMedia
	FROM    (SELECT T.jobid XJobId, T.commcellId XCommCellId, MAX(T.sizeOnMedia) AS sizeOnMedia
			FROM    (SELECT S.jobid, S.commcellId, S.archGrpCopyId, SUM(S.sizeOnMedia) AS sizeOnMedia
					FROM    JMJobDataStats S WITH (READUNCOMMITTED), #ClientDPCoverage B
					WHERE   S.jobid = B.SuccessfulBackupJobId AND S.AuxCopyJobId = 0
					GROUP BY S.jobid, S.commcellId, S.archGrpCopyId) AS T
			GROUP BY T.jobid, T.commcellId) AS X
	WHERE   BackupJobID = X.XJobId
--VM updation
	UPDATE	#VMJobInfo
	SET		LastSuccessfulBackupTime = CAST(V.attrVal as int)
	FROM	#VMJobInfo VM
				JOIN	APP_VMProp V
					ON VM.LastSuccessfulBackupJobId = V.jobId
						AND V.attrName = 'vmBackupEndTime'
						and V.VMclientId = VM.clientId
	UPDATE	#VMJobInfo
	SET		BackupStatus = CAST(V.attrVal as int)
	FROM	#VMJobInfo VM
				JOIN	APP_VMProp V
					ON VM.BackupJobID = V.jobId
						AND V.attrName = 'vmStatus'
						and V.VMclientId = VM.clientId
	UPDATE #VMJobInfo
	SET VMSize = CAST(V.attrVal as bigint)
	FROM APP_VMProp V
			INNER JOIN #VMJobInfo vm
				ON V.VMclientId = vm.clientId
						AND vm.LastSuccessfulBackupJobId = V.jobId
						AND V.attrName ='vmSize'
						and V.VMclientId = VM.clientId
	UPDATE #VMJobInfo
	SET VMBackedupSize = CAST(V.attrVal as bigint)
	FROM APP_VMProp V
			INNER JOIN #VMJobInfo vm
				ON V.VMclientId = vm.clientId
						AND vm.LastSuccessfulBackupJobId = V.jobId
						AND V.attrName ='vmUsedSpace'
	INSERT INTO #VMTotalSize
	SELECT LastSuccessfulBackupJobId, SUM(VMBackedupSize),0
	FROM #VMJobInfo
	WHERE LastSuccessfulBackupJobId > 0 group by LastSuccessfulBackupJobId
	UPDATE  #VMTotalSize
	SET     DataWritten = ISNULL(
			   (SELECT TOP 1 T.sizeOnMedia
				   FROM    (SELECT S.archGrpCopyId, SUM(S.sizeOnMedia) AS sizeOnMedia
					   FROM    JMJobDataStats S WITH (READUNCOMMITTED)
						   WHERE   2 = S.commcellId and vmJobId =S.jobid and S.AuxCopyJobId = 0
						   GROUP BY S.archGrpCopyId) AS T),0)
	UPDATE	#VMJobInfo
	SET		appId = B.appId,
			BackupType = B.bkpLevel,
			TotalTimeForLastBackup = (B.servEndDate - B.servStartDate),
			BackupStartTime = B.servStartDate,
			BackupEndTime = B.servEndDate
	FROM	#VMJobInfo V INNER JOIN
			JMBkpStats B ON
			B.jobId =  V.LastSuccessfulBackupJobId
			AND B.commCellId = V.commcellid
			AND B.status in (1,3,14,16)
	UPDATE #VMJobInfo
	SET		appId = B.appId
	FROM #VMJobInfo V
				INNER JOIN	JMBkpStats B
					ON v.LastSuccessfulBackupJobId = 0
						AND B.jobId = v.BackupJobID
	UPDATE	#VMJobInfo
	SET		SubClientName	= A.subclientName,
			BackupSetName	= BS.name,
			InstanceName	= I.name,
			appTypeName		= IDA.name
	FROM	#VMJobInfo vmJobInfo
			INNER JOIN APP_Application A
				ON	vmJobInfo.appId = A.id
			INNER JOIN APP_BackupSetName BS
				ON	BS.id = A.backupSet
			INNER JOIN APP_InstanceName I
				ON	I.id = A.instance
			INNER JOIN	APP_iDAType IDA
				ON A.appTypeId = IDA.type
	/*UPDATE #VMJobInfo
	SET BackupStatus = ( SELECT CASE WHEN BackupEndTime < @StartTime THEN 1
								 ELSE 0
								 END )*/
	UPDATE #VMJobInfo
	SET VMDataWrittenSize = cast(VMBackedupSize*(cast(vmTotalSize.DataWritten as real)/vmTotalSize.TotalVMBackupSize) as bigint)
	FROM #VMTotalSize vmTotalSize INNER JOIN #VMJobInfo
			ON vmTotalSize.vmJobId = LastSuccessfulBackupJobId
				AND vmTotalSize.TotalVMBackupSize > 0
				AND LastSuccessfulBackupJobId >0
	INSERT INTO #VMInfo  (clientId, VMName)
	select distinct C.id, C.name
	from APP_Client C
		INNER JOIN @SERVERS SRV
			ON C.id = SRV.clientId
		INNER JOIN APP_ClientProp CP
			ON C.id = CP.componentNameId
			AND CP.attrName = 'Virtual Server Discovered Clients'
			AND CP.modified =0
			AND CP.attrVal = 1
	--DEBUG
	--SELECT * FROM #VMInfo
	-----------------------------------------------------------------
	-- Exclude Deleted VMs
	-----------------------------------------------------------------
	DELETE #VMInfo
	FROM #VMInfo VJ
	INNER JOIN  APP_ClientProp WITH (NOLOCK)
	ON attrName = 'Virtual Machine Deletion Time' AND ISNULL(attrVal, '0') <> '0' AND modified = 0
		  AND componentNameId = VJ.clientId
	IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#VMCoverage'))
         DROP TABLE #VMCoverage
	CREATE TABLE #VMCoverage (
		clientId			INT,
VMName					NVARCHAR(255),
		clientGroup				NVARCHAR(MAX),
		InstanceName				NVARCHAR(512),
BackupSetName				NVARCHAR(128),
		AppId					INT,
		appTypeName				VARCHAR(256),
SubclientName			NVARCHAR(128),
		VMSize					BIGINT,
		VMBackedupSize			BIGINT,
		VMDataWrittenSize		BIGINT,
		SuccessfulBackupJobId	INTEGER,
		SuccessfulBackupJobTime	INT,
		BackupJobID			INTEGER,
		BackupStartTime		VARCHAR(20),
		BackupEndTime		VARCHAR(20),
		BackupType			INT,
		BackupStatus		INT,
		LastBkpType				NVARCHAR(16),
		TotalTimeForLastBackup		INTEGER,
		DaysSinceLastSuccessfulBackupJob  INTEGER
	)
	INSERT INTO #VMCoverage
	SELECT	VMINFO.clientId,
			VMName,
			ISNULL(L.ClientGroupList,'') as clientGroup,
			InstanceName,
			BackupSetName,
			appId as AppId,
			appTypeName,
			SubClientName,
			VMSize,
			VMBackedupSize,
			VMDataWrittenSize,
			LastSuccessfulBackupJobId AS SuccessfulBackupJobId,
			LastSuccessfulBackupTime AS SuccessfulBackupJobTime,
			BackupJobID,
			CASE WHEN ISNULL(BackupStartTime, 0) = 0 THEN 'N/A'
                 ELSE dbo.UTCToLocalStringTime(dbo.GetDateTime(BackupStartTime), @csTimeZoneName) END AS BackupStartTime,
			CASE WHEN ISNULL(BackupEndTime, 0) = 0 THEN 'N/A'
                 ELSE dbo.UTCToLocalStringTime(dbo.GetDateTime(BackupEndTime), @csTimeZoneName) END AS BackupEndTime,
			BackupType,
			BackupStatus,
			CASE BackupType
				WHEN 1 THEN 'Full'
				WHEN 2 THEN 'Incremental'
				WHEN 4 THEN 'Differential'
				WHEN 64 THEN 'SyntheticFull'
				ELSE 'Other'
				END as LastBkpType,
			TotalTimeForLastBackup,
			CASE WHEN ISNULL(LastSuccessfulBackupTime, 0) = 0 THEN 0
				 ELSE DATEDIFF(D, dbo.GetDateTime(LastSuccessfulBackupTime), GETDATE()) END AS DaysSinceLastSuccessfulBackupJob
	FROM	#VMInfo vmInfo
				LEFT OUTER JOIN #VMJobInfo vmJobInfo
					ON vmInfo.clientId = vmJobInfo.clientId
				LEFT OUTER JOIN #tblClientGroupKey  K
					ON K.ClientId = vmInfo.ClientId
				LEFT OUTER JOIN #tblClientGroupList L
					ON L.Key1 = K.Key1 AND L.Key2 = K.Key2
	ORDER BY VMName
END
--S2
IF @i_bSummary = 2 or @i_bSummary = 3
BEGIN
	IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#SUMMARY'))
         DROP TABLE #SUMMARY
	create TABLE #SUMMARY(
				isVm VARCHAR(15)
, ClientName NVARCHAR(255)
, HostName	 NVARCHAR(255)
				, ClientGroup NVARCHAR(MAX)
				, Agent VARCHAR(255)
, Subclient NVARCHAR(128)
				, InstanceName NVARCHAR(512)
, BackupSetName NVARCHAR(128)
				, BackupJobID INT
				, BackupStatus VARCHAR(30)
				, BackupType VARCHAR(30)
				, DataWrittenOfLastSuccessfulBackupJob BIGINT
				, LastSuccessfulBackupJobId BIGINT
				, LastSuccessfulBackupJobTime VARCHAR(30)
				, DaysSinceLastSuccessfulBackupJob INT
				, BackupStartTime VARCHAR(20)
				, BackupEndTime VARCHAR(20)
	);
	INSERT INTO #SUMMARY
	SELECT	'Physical'
			, ClientName
			, CL.net_hostname as 'HostName'
			, ClientGroup
			, Agent
			, Subclient
			, Instance
			, BackupSet
			, BackupJobID
			, BackupStatus
			, BackupType
			, DataWritten as DataWrittenOfLastSuccessfulBackupJob
			, SuccessfulBackupJobId
			, CASE WHEN ISNULL(C.SuccessfulBackupJobTime, 0) = 0 THEN 'N/A'
                 ELSE dbo.UTCToLocalStringTime(dbo.GetDateTime(C.SuccessfulBackupJobTime), @csTimeZoneName) END
			, DaysSinceLastSuccessfulBackupJob
			, BackupStartTime
			, BackupEndTime
	FROM	#ClientDPCoverage C
				INNER JOIN @SERVERS SRV
					ON SRV.clientId = C.clientId
				INNER JOIN APP_Client CL
					on CL.name = C.ClientName
	order by DaysSinceLastSuccessfulBackupJob desc
	INSERT INTO #SUMMARY
	SELECT	'Virtual'
			, VMName as ClientName
			, CL.net_hostname as 'HostName'
			, clientGroup
			, appTypeName as Agent
			, ISNULL(SubclientName, 'N/A')
			, InstanceName
			, BackupSetName
			, BackupJobID
			, CASE BackupStatus WHEN 0 THEN 'Completed'
									WHEN 1 THEN 'FAILED'
									WHEN 2 THEN 'IN_PROGRESS'
									WHEN 3 THEN 'PARTIAL_SUCCESS'
									WHEN 4 THEN 'WAITING'
				END AS BackupStatus
			, ISNULL(LastBkpType, 'N/A')
			, VMDataWrittenSize as DataWrittenOfLastSuccessfulBackupJob
			, SuccessfulBackupJobId
			, CASE WHEN ISNULL(SuccessfulBackupJobTime, 0) = 0 THEN 'N/A'
                 ELSE dbo.UTCToLocalStringTime(dbo.GetDateTime(SuccessfulBackupJobTime), @csTimeZoneName) END AS SuccessfulBackupJobTime
			, DaysSinceLastSuccessfulBackupJob
			, BackupStartTime
			, BackupEndTime
	FROM	#VMCoverage	V
			INNER JOIN @SERVERS SRV
				ON SRV.clientId = V.clientId
			INNER JOIN APP_Client CL
					on CL.name = V.VMName
	order by VMName
	DROP TABLE #VMJobInfo
	IF @i_bSummary = 2
	BEGIN
		IF @i_MaxDaysforBackup > 0
			DELETE FROM #SUMMARY  WHERE DaysSinceLastSuccessfulBackupJob >= @i_MaxDaysforBackup
		IF @i_backupType <> ''
			DELETE FROM #SUMMARY  WHERE BackupType NOT LIKE @i_backupType
		SELECT	ClientName as 'Client',
				Subclient,
				InstanceName,
				BackupSetName,
				DaysSinceLastSuccessfulBackupJob 'Days since no data protection',
				BackupType,
				LastSuccessfulBackupJobTime 'Last data protection time',
				LastSuccessfulBackupJobId 'Last successful job id',
				BackupStatus as 'Status',
				BackupJobID as 'Last job Id',
				BackupStartTime as 'Last job start time',
				BackupEndTime 'Last job end time',
				CONVERT(DECIMAL(20, 2), ISNULL(CAST(DataWrittenOfLastSuccessfulBackupJob AS FLOAT), 0)/1024/1024) 'Last successful job media size (MB)',
				HostName,
				ISNULL(Agent, CASE isVM WHEN 'Virtual' THEN 'Virtual Server' ELSE 'Physical' END) as 'Agent',
				isVM,
				ClientGroup
		from	#SUMMARY
		where DaysSinceLastSuccessfulBackupJob >= @i_nLastDays	or LastSuccessfulBackupJobTime ='N/A'
		ORDER BY DaysSinceLastSuccessfulBackupJob DESC
		DROP TABLE #tblSubclient
		DROP TABLE #tblSubclientAggr
		DROP TABLE #VMTotalSize
		DROP TABLE #VMInfo
		DROP TABLE #tblClientGroupList
		DROP TABLE #tblClientGroupKey
		DROP TABLE #ClientDPCoverage
		DROP TABLE #VMCoverage
		DROP TABLE #SUMMARY
		RETURN;
	END
END
--S3
BEGIN
	DROP TABLE #SUMMARY;
	DELETE #VMTotalSize;
	DELETE #tblSubclientAggr
	IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#SUMMARY1'))
         DROP TABLE #SUMMARY1
	CREATE TABLE #SUMMARY1(
				isVm VARCHAR(15)
, ClientName NVARCHAR(255)
				, ClientGroup NVARCHAR(MAX)
				, Agent VARCHAR(255)
, Subclient NVARCHAR(128)
, BackupSetName	NVARCHAR(128)
				, InstanceName	NVARCHAR(512)
				, BackupJobID INT
				, BackupStatus VARCHAR(30)
				, DataWritten BIGINT
				, BackupType VARCHAR(30)
				, BackupStartTime VARCHAR(20)
				, BackupEndTime VARCHAR(20)
				, LastSuccessfulBackupJobId BIGINT
				, LastSuccessfulBackupJobTime VARCHAR(30)
				, DaysSinceLastSuccessfulBackupJob INT
				, BackupFailureReason NVARCHAR(1024)
				, numOfProtectedObjects BIGINT
				, numOfFailedObjects	BIGINT
	)
	INSERT  INTO #tblSubclientAggr
	SELECT  S.ClientId,
			S.AppId,
			0  AS nSuccessfulJobs,
			0 AS nUnsuccessfulJobs,
			0 AS LastSuccessfulBackupJobID,
			0 AS LastSuccessfulBackupJobTime,
			B.jobId AS BackupJobID,
			B.bkpLevel AS BackupType,
			B.servStartDate AS BackupStartTime,
			B.servEndDate AS BackupEndTime,
			B.status AS BackupStatus
			, B.failureReason
			, B.totalNumOfFiles
			, B.backupFileFailures
	FROM    #tblSubclient S
				INNER JOIN JMBkpStats B
					ON B.appId = S.AppId
	WHERE   B.bkpLevel IN (1, 2, 4, 64, 256, 1024, 32768)
				AND B.commCellId = 2
				AND (B.servEndDate > @StartTime OR @StartTime = 0)
	UPDATE	#tblSubclientAggr
	SET		LastSuccessFulBackupJobId = Client.SuccessfulBackupJobId,
			LastSuccessfulBackupJobTime = Client.SuccessfulBackupJobTime
	FROM	#tblSubclientAggr S
				JOIN #ClientDPCoverage Client
					ON S.appId = Client.appId
	DELETE	#ClientDPCoverage
	INSERT INTO #ClientDPCoverage
    SELECT
			CL.id	as ClientId,
			CL.name AS ClientName,
            ISNULL(L.ClientGroupList,'') AS ClientGroup,
            IDA.name,
            dbo.FixInstanceName(INST.name, S.AppTypeId),
            BSN.name Backupset,
            A.AppId,
            S.SubclientName,
            0 AS SuccessfulJobs,
			0 AS UnsuccessfulJobs,
            A.LastSuccessfulBackupJobID AS LastSuccessfulBackupJobId ,
			LastSuccessfulBackupJobTime,
            CASE WHEN ISNULL(A.LastSuccessfulBackupJobTime, 0) = 0 THEN 0
				 ELSE DATEDIFF(D, dbo.GetDateTime(A.LastSuccessfulBackupJobTime), GETDATE()) END AS DaysSinceLastSuccessfulBackupJob,
            ISNULL(A.BackupJobID, 0) AS BackupJobID,
            CASE WHEN ISNULL(A.BackupType, 0) = 0 THEN 'N/A'
                 ELSE dbo.GetJobBackupTypeDisplay(A.BackupType) END AS BackupType,
            CASE WHEN ISNULL(A.BackupStartTime, 0) = 0 THEN 'N/A'
                 ELSE dbo.UTCToLocalStringTime(dbo.GetDateTime(A.BackupStartTime), @csTimeZoneName) END AS BackupStartTime,
            CASE WHEN ISNULL(A.BackupEndTime, 0) = 0 THEN 'N/A'
                 ELSE dbo.UTCToLocalStringTime(dbo.GetDateTime(A.BackupEndTime), @csTimeZoneName) END AS BackupEndTime,
            CASE WHEN ISNULL(A.BackupStatus, 0) = 0 THEN 'No Run'
                 WHEN A.BackupStatus = 1  THEN 'Completed'
                 WHEN A.BackupStatus = 3  THEN 'Completed With Errors'
                 WHEN A.BackupStatus = 14 THEN 'Completed With Warnings'
                 WHEN A.BackupStatus IN (2, 9)  THEN 'Failed'
                 WHEN A.BackupStatus IN (4, 15) THEN 'Killed' END AS BackupStatus,
            0 AS DataWritten
            , dbo.JMGetLocalizedMessageFunc(0, ISNULL(A.BackupFailureReason, '')) AS BackupFailureReason
            , A.numOfProtectedObjects
            , A.numOfFailedObjects
    FROM    #tblSubclient S
            LEFT OUTER JOIN #tblSubclientAggr A ON A.AppId = S.AppId
            INNER JOIN APP_Client CL ON CL.id = S.ClientId
            INNER JOIN APP_iDAType IDA ON IDA.type = S.AppTypeId
            INNER JOIN APP_InstanceName INST ON INST.id = S.InstanceId
            INNER JOIN APP_BackupsetName BSN ON BSN.id = S.BackupsetId
            LEFT OUTER JOIN #tblClientGroupKey  K ON K.ClientId = S.ClientId
            LEFT OUTER JOIN #tblClientGroupList L ON L.Key1 = K.Key1 AND L.Key2 = K.Key2
    WHERE   CL.origCCId NOT IN (SELECT id FROM APP_CommCell WHERE type > 1) AND (INST.status & 2048) = 0
    ORDER BY CASE WHEN CL.clientDescription LIKE '%offline%' THEN 1 ELSE 0 END DESC,
            (CASE WHEN ISNULL(A.nSuccessfulJobs, 0) > 0 THEN 2 WHEN ISNULL(A.nUnsuccessfulJobs, 0) > 0 THEN 1 ELSE 0 END),
            CL.name,
            IDA.name,
            BSN.name,
            S.SubclientName
	UPDATE #ClientDPCoverage
    SET     DataWritten = X.sizeOnMedia
	FROM    (SELECT T.jobid XJobId, T.commcellId XCommCellId, MAX(T.sizeOnMedia) AS sizeOnMedia
			FROM    (SELECT S.jobid, S.commcellId, S.archGrpCopyId, SUM(S.sizeOnMedia) AS sizeOnMedia
					FROM    JMJobDataStats S WITH (READUNCOMMITTED), #ClientDPCoverage B
					WHERE   S.jobid = B.BackupJobId AND S.AuxCopyJobId = 0
					GROUP BY S.jobid, S.commcellId, S.archGrpCopyId) AS T
			GROUP BY T.jobid, T.commcellId) AS X
	WHERE   BackupJobID = X.XJobId
	INSERT INTO #SUMMARY1
	SELECT
			'Physical'
			, ClientName
			, ClientGroup
			, Agent
			, Subclient
			, BackupSet
			, Instance
			, BackupJobID
			, BackupStatus
			, DataWritten
			, BackupType
			, BackupStartTime
			, BackupEndTime
			, SuccessfulBackupJobId
			, CASE WHEN ISNULL(SuccessfulBackupJobTime, 0) = 0 THEN 'N/A'
                 ELSE dbo.UTCToLocalStringTime(dbo.GetDateTime(SuccessfulBackupJobTime), @csTimeZoneName) END AS LastSuccessfulBackupJobTime
			, DaysSinceLastSuccessfulBackupJob
			, BackupFailureReason
			, ISNULL(numOfProtectedObjects, 0)
			, ISNULL(numOfFailedObjects, 0)
	FROM	#ClientDPCoverage
	IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#VMJobInfo1'))
         DROP TABLE #VMJobInfo1
	CREATE TABLE #VMJobInfo1(
			commcellid					INT,
			clientId					INT,
			clientGroupList				NVARCHAR(MAX),
			appId						INT,
			appTypeName					varchar(256),
BackupSetName				NVARCHAR(128),
			InstanceName				NVARCHAR(512),
SubclientName				NVARCHAR(128),
			jobId						INT,
			startTime					INT,
			endTime						INT,
			backupStatus				INT,
			BackupType					INT,
			LastSuccessfulBackupJobId	BIGINT
			, LastSuccessfulBackupJobTime VARCHAR(30)
			, DaysSinceSuccessfulBackup INT
			, VMSize						BIGINT,
			VMDataWrittenSize			BIGINT,
			VMBackedupSize				BIGINT
		)
	INSERT INTO #VMJobInfo1
	SELECT	JMQ.commCellId,
			JMQ.clientId,
			'' AS clientGroupList,
			MAX(B.appId),
			'' as appTypeName,
			NULL as BackupSetName,
			NULL AS InstanceName,
			NULL AS SubClientName,
			B.jobId,
			0 AS startTime,
			0 AS endTime,
			0 AS backupStatus,
			0 AS BackupType,
			0 AS LastSuccessfulBackupJobId,
			0 AS LastSuccessfulBackupJobTime,
			0 AS DaysSinceSuccessfulBackup,
			0 AS VMSize,
			0 AS VMDataWrittenSize,
			0 AS VMBackedupSize
	FROM JMQinetixUpdateStatus JMQ
		INNER JOIN JMBkpStats B
			ON	B.jobId = JMQ.jobId
			AND	B.commCellId = B.commCellId
			AND (B.servEndDate > @StartTime OR @StartTime = 0)
		LEFT OUTER JOIN APP_VMProp V
			ON	JMQ.jobId = V.jobId
			AND	JMQ.commCellId = V.commCellId
			AND	JMQ.clientId = V.VMclientId
			AND	V.attrName = 'vmStatus'
	WHERE	B.appType = 106
	GROUP BY
		JMQ.clientId, JMQ.commCellId, B.jobId
	-----------------------------------------------------------------
	-- Exclude Deleted VMs
	-----------------------------------------------------------------
	DELETE #VMJobInfo1
	FROM #VMJobInfo1 VJ
	INNER JOIN  APP_ClientProp WITH (NOLOCK)
	ON attrName = 'Virtual Machine Deletion Time' AND ISNULL(attrVal, '0') <> '0' AND modified = 0
		  AND componentNameId = VJ.clientId
	UPDATE	#VMJobInfo1
	SET		backupStatus = CAST(V.attrVal as int)
	FROM	#VMJobInfo1 VM
				JOIN	APP_VMProp V
					ON VM.jobId = V.jobId
						AND V.attrName = 'vmStatus'
	UPDATE #VMJobInfo1
	SET VMSize = CAST(V.attrVal as bigint)
	FROM APP_VMProp V
			INNER JOIN #VMJobInfo1 vm
				ON V.VMclientId = vm.clientId
						AND vm.jobId = V.jobId
						AND V.attrName ='vmSize'
	UPDATE #VMJobInfo1
	SET VMBackedupSize = CAST(V.attrVal as bigint)
	FROM APP_VMProp V
			INNER JOIN #VMJobInfo1 vm
				ON V.VMclientId = vm.clientId
						AND vm.jobId = V.jobId
						AND V.attrName ='vmUsedSpace'
	UPDATE	#VMJobInfo1
		SET		startTime = CAST(V.attrVal as int)
		FROM	#VMJobInfo1 VM
					JOIN	APP_VMProp V
						ON VM.jobId = V.jobId
							AND V.attrName = 'vmBackupStartTime'
	UPDATE	#VMJobInfo1
		SET		endTime = CAST(V.attrVal as int)
		FROM	#VMJobInfo1 VM
					JOIN	APP_VMProp V
						ON VM.jobId = V.jobId
							AND V.attrName = 'vmBackupEndTime'
	UPDATE	#VMJobInfo1
		SET		BackupType = CAST(V.attrVal as int)
		FROM	#VMJobInfo1 VM
					JOIN	APP_VMProp V
						ON VM.jobId = V.jobId
							AND V.attrName = 'vmBackupType'
	INSERT INTO #VMTotalSize
	SELECT jobId, SUM(VMBackedupSize),0 FROM #VMJobInfo1 group by jobId
	UPDATE  #VMTotalSize
	SET     DataWritten = ISNULL(
			   (SELECT TOP 1 T.sizeOnMedia
				   FROM    (SELECT S.archGrpCopyId, SUM(S.sizeOnMedia) AS sizeOnMedia
					   FROM    JMJobDataStats S WITH (READUNCOMMITTED)
						   WHERE   2 = S.commcellId and vmJobId =S.jobid and S.AuxCopyJobId = 0
						   GROUP BY S.archGrpCopyId) AS T),0)
	UPDATE	#VMJobInfo1
	SET		SubClientName	= A.subclientName,
			BackupSetName	= BS.name,
			InstanceName	= I.name,
			appTypeName		= IDA.name
	FROM	#VMJobInfo1 vmJobInfo
				INNER JOIN APP_Application A
					ON	vmJobInfo.appId = A.id
				INNER JOIN APP_BackupSetName BS
					ON	BS.id = A.backupSet
				INNER JOIN APP_InstanceName I
					ON	I.id = A.instance
				INNER JOIN	APP_iDAType IDA
					ON A.appTypeId = IDA.type
	UPDATE	#VMJobInfo1
	SET		LastSuccessfulBackupJobId	= COV.SuccessfulBackupJobId,
			LastSuccessfulBackupJobTime	= COV.SuccessfulBackupJobTime,
			DaysSinceSuccessfulBackup	= COV.DaysSinceLastSuccessfulBackupJob
	FROM	#VMCoverage COV
				JOIN #VMJobInfo1 JOBINFO
					ON COV.clientId = JOBINFO.clientId
						AND COV.AppId = JOBINFO.appId
	UPDATE #VMJobInfo1
	SET VMDataWrittenSize = cast(VMBackedupSize*(cast(vmTotalSize.DataWritten as real)/vmTotalSize.TotalVMBackupSize) as bigint)
	FROM #VMTotalSize vmTotalSize INNER JOIN #VMJobInfo1
			ON vmTotalSize.vmJobId = jobId
				AND vmTotalSize.TotalVMBackupSize > 0
	INSERT INTO #SUMMARY1
	SELECT
			'Virtual'
			, vmInfo.VMName
			, ISNULL(L.ClientGroupList,'') as clientGroup
			, vmJobInfo.appTypeName
			, vmJobInfo.SubClientName
			, vmJobInfo.BackupSetName
			, vmJobInfo.InstanceName
			, vmJobInfo.jobId
			, CASE BackupStatus WHEN 0 THEN 'Completed'
								WHEN 1 THEN 'FAILED'
								WHEN 2 THEN 'IN_PROGRESS'
								WHEN 3 THEN 'PARTIAL_SUCCESS'
								WHEN 4 THEN 'WAITING'
			 END AS BackupStatus
			, vmJobInfo.VMDataWrittenSize
			, CASE BackupType
				WHEN 1 THEN 'Full'
				WHEN 2 THEN 'Incremental'
				WHEN 4 THEN 'Differential'
				WHEN 64 THEN 'SyntheticFull'
				ELSE 'Other'
				END as LastBkpType
			, vmJobInfo.startTime
			, vmJobInfo.endTime
			, vmJobInfo.LastSuccessfulBackupJobId
			, vmJobInfo.LastSuccessfulBackupJobTime
			, vmJobInfo.DaysSinceSuccessfulBackup
			, '' AS backupFailureReason
			, 0 AS numOfProtectedObjects
			, 0 AS numOfFailedObjects
	FROM #VMInfo vmInfo
			INNER JOIN #VMJobInfo1 vmJobInfo
				ON vmInfo.clientId = vmJobInfo.clientId
			LEFT OUTER JOIN #tblClientGroupKey  K
				ON K.ClientId = vmInfo.ClientId
			LEFT OUTER JOIN #tblClientGroupList L
				ON L.Key1 = K.Key1 AND L.Key2 = K.Key2
	SELECT	*
	FROM	#SUMMARY1
	ORDER BY ClientName
	DROP TABLE #tblSubclient
	DROP TABLE #tblSubclientAggr
	DROP TABLE #VMTotalSize
	DROP TABLE #VMInfo
	DROP TABLE #tblClientGroupList
	DROP TABLE #tblClientGroupKey
	DROP TABLE #ClientDPCoverage
	DROP TABLE #VMCoverage
	DROP TABLE #SUMMARY1
	DROP TABLE #VMJobInfo1
END
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ServerProtection')
	delete from GxQscripts where name = 'QS_ServerProtection'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ServerProtection')
	delete from GXDBVersions where aliasname = 'QS_ServerProtection'
GO

insert into GXDBVersions values(2, 'QS_ServerProtection',  '00010006008000060000', 'QS_ServerProtection', '00010006008000060000')
GO

insert into GxQscripts values(2,'QS_ServerProtection',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_ServerProtection [-si @i_nLastDays =''7''] [-si @i_bSummary=''3'' ] [-si @i_clientGroup ='''' ]  [-si @i_BillableEntity='''' ]
'
 + CHAR(10) + '-- 	Backup status of Physical and Virtual Servers is returned.'
)
GO

