

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SelectAdditionalJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SelectAdditionalJobs.sp,v $ $Id: QS_SelectAdditionalJobs.sp,v 1.3.60.2 2018/03/22 01:15:34 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	|			Stored Procedure: "QS_SelectAdditionalJobs"							|
--	|																		|
--	|-------------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SelectAdditionalJobs <<<'

IF EXISTS (select * from sysobjects where name='QS_SelectAdditionalJobs')
	drop procedure QS_SelectAdditionalJobs
IF EXISTS (select * from GxQscripts where name='QS_SelectAdditionalJobs')
	delete from GxQscripts where name = 'QS_SelectAdditionalJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SelectAdditionalJobs')
	delete from GXDBVersions where aliasname = 'QS_SelectAdditionalJobs'
GO
print '... Creating Procedure: QS_SelectAdditionalJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SelectAdditionalJobs
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_SPName nvarchar(max),
  @i_CopyName nvarchar(max),
  @i_BackupTypes integer = 0
AS
 set nocount on
DECLARE @ErrorNumber INTEGER
DECLARE @ErrorMessage NVARCHAR(MAX)
DECLARE	@SPId INTEGER = 0
DECLARE	@newCopy INTEGER = 0
DECLARE	@DestCopyId INTEGER = 0
DECLARE	@modifyTime INTEGER = 0
BEGIN TRY
SELECT @SPId = id from ARCHGROUP WHERE NAME = @i_SPName
IF @SPId = 0
BEGIN
	SET @ErrorNumber = 1
	SET @ErrorMessage = N'Invalid Storage policy name'
	GOTO SCRIPT_EXIT
END
IF @i_CopyName = 'NextCopyId'
BEGIN
	SET @newCopy = 1
	SET @DestCopyId = IDENT_CURRENT('archGroupCopy') + IDENT_INCR('archGroupCopy')
END
IF @newCopy = 0
BEGIN
	SELECT @DestCopyId = id from ARCHGROUPCOPY WHERE NAME = @i_CopyName AND archgroupid = @SPId and isActive = 1
	IF @DestCopyId = 0
	BEGIN
		SET @ErrorNumber = 2
		SET @ErrorMessage = N'Invalid Storage policy copy name'
		GOTO SCRIPT_EXIT
	END
	--This is supported only for SELECTIVE COPY with manual job selection
	IF NOT EXISTS (SELECT 1 from archSelectiveCopy where COPYID = @DestCopyId)
	BEGIN
		SET @ErrorNumber = 3
		SET @ErrorMessage = N'This operation is supported only for selective copy.'
		GOTO SCRIPT_EXIT
	END
END
IF (@i_BackupTypes NOT IN (0, 1, 2))
BEGIN
		PRINT 'Invalid BackupType selection'
		SET @ErrorNumber = 4
		SET @ErrorMessage = N'Invalid BackupType selection'
		GOTO SCRIPT_EXIT
END
IF EXISTS (SELECT 1 FROM MMEntityProp where EntityId = @DestCopyId and propertyName = 'JobSelectionType' and EntityType = 2)
BEGIN
	UPDATE MMEntityProp SET intVal = @i_BackupTypes, modified = @modifyTime
	WHERE EntityId = @DestCopyId AND EntityType = 2 AND propertyName = 'JobSelectionType' AND propDataType = 1 AND CommCellId = 2
END
ELSE
BEGIN
	INSERT INTO MMEntityProp (EntityId, EntityType, propertyName, propDataType, intVal, longlongVal, stringVal, created, modified, CommCellId)
	VALUES (@DestCopyId, 2, 'JobSelectionType', 1,  @i_BackupTypes, 0, '', @modifyTime, @modifyTime, 2)
END
IF @@ERROR <> 0
BEGIN
	SELECT @ErrorNumber = ERROR_NUMBER(), @ErrorMessage = ERROR_MESSAGE()
	GOTO SCRIPT_EXIT
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT @ErrorNumber = ERROR_NUMBER(), @ErrorMessage = ERROR_MESSAGE();
END CATCH;
SCRIPT_EXIT:
IF @ErrorNumber <> 0
	Raiserror(@ErrorMessage,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
ELSE
	PRINT 'Successfully added entry'
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SelectAdditionalJobs')
	delete from GxQscripts where name = 'QS_SelectAdditionalJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SelectAdditionalJobs')
	delete from GXDBVersions where aliasname = 'QS_SelectAdditionalJobs'
GO

insert into GXDBVersions values(2, 'QS_SelectAdditionalJobs',  '00010003006000020000', 'QS_SelectAdditionalJobs', '00010003006000020000')
GO

insert into GxQscripts values(2,'QS_SelectAdditionalJobs',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_SelectAdditionalJobs -si @i_SPName = ''SPName'' -si @i_CopyName=''CopyName'' -si @i_BackupTypes = ''BackupTypes''
'
 + CHAR(10) + '-- 	script_name: QS_SelectAdditionalJobs.'
 + CHAR(10) + '-- 	Select additional jobs (incremental, differential etc) with selected full job on selective copy.'
)
GO

