

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_SQLBrowseData.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_SQLBrowseData')
BEGIN
	print '>>> Drop Stored Procedure: QS_SQLBrowseData <<<'
	drop procedure QS_SQLBrowseData
END
IF EXISTS (select * from GxQscripts where name='QS_SQLBrowseData')
	delete from GxQscripts where name = 'QS_SQLBrowseData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SQLBrowseData')
	delete from GXDBVersions where aliasname = 'QS_SQLBrowseData'
GO
print '... Creating Procedure: QS_SQLBrowseData'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SQLBrowseData
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- QScript secure this script does the user validation
--Qscript usage. Use no special char in HTML
-- SP Input params
  @instanceName NVARCHAR(1024) = N'%ws',
  @databaseName NVARCHAR(1024) = N'%ws',
  @copy_precedence INTEGER = 0
AS
SET NOCOUNT ON
-- Input Parameters
DECLARE @i_InstanceName NVARCHAR(1024)
DECLARE @i_DatabaseName NVARCHAR(1024)
DECLARE @i_UNIXTIME BIGINT
DECLARE @i_CopyPrecedence NVARCHAR(1024) = 0
-- OUTPUT PARAMETER
DECLARE @o_XmlOutputString XML
-- error parameters
DECLARE @e_ErrorCode integer
DECLARE @e_ErrorMessage NVARCHAR(1204)
-- Initialization of Variables
SET @i_InstanceName = @instanceName
SET @i_UNIXTIME = CONVERT(BIGINT, CURRENT_TIMESTAMP)
SET @i_DatabaseName = @databaseName
SET @i_CopyPrecedence = @copy_precedence
-- INITIAL Error VALUES
SET @e_ErrorCode = 0
SET @e_ErrorMessage =N''
/*******        USER VALIDATION MODULE (INIT)   *******/
	IF OBJECT_ID('tempdb.dbo.#tempQSUser') IS NULL
	BEGIN
		SET @e_ErrorCode = 7
		SET @e_ErrorMessage  = N'Error, no logged in user found'
		GOTO QS_SQLBROWSEDATA_EXIT
	END
	DECLARE @userId INT = 0
	SET @userId =  ISNULL((select TOP 1 userId from #tempQSUser), 0)
	IF @userId = 0
	BEGIN
		SET @e_ErrorCode = 8
		SET @e_ErrorMessage  = N'Error, no logged in user found'
		GOTO QS_SQLBROWSEDATA_EXIT
	END
	DECLARE @isBrowseOperationPsbl INT = 0
	DECLARE @cap BIGINT = -1
	set @isBrowseOperationPsbl = 0
	IF @cap = -1
		SET @cap = (power(2, 13-1))
	IF OBJECT_ID('tempdb.dbo.#QsBrowse_UserObjects') IS NOT NULL
		DROP TABLE #QsBrowse_UserObjects
	CREATE TABLE #QsBrowse_UserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 0, 0, '#QsBrowse_UserObjects'
	-- Remove entities for which user doesnt have rights for browse.
	DELETE FROM #QsBrowse_UserObjects WHERE (capabilities & @cap) = 0
	-- Table for instance ID
	DECLARE @SelectedInstanceID INTEGER = 0
	-- Get instance name ID and check if any valid entry found.
	SELECT TOP 1 @SelectedInstanceID = id FROM APP_InstanceName WHERE name = @i_InstanceName
	IF @SelectedInstanceID = 0
	BEGIN
		SET @e_ErrorCode = 1
		SET @e_ErrorMessage = N'Invalid Instance Name. Couldn''t find Instance ID for instance :' + @i_InstanceName
		GOTO QS_SQLBROWSEDATA_EXIT
	END
	-- Table for subclient ID
	IF OBJECT_ID('tempdb.dbo.#AppIDTable') IS NOT NULL
		DROP TABLE #AppIDTable
	CREATE TABLE #AppIDTable ( SubClientID INTEGER )
	INSERT INTO #AppIDTable
			SELECT	DISTINCT appId FROM sqlDbBackupInfo SDBI WHERE SDBI.instanceId = @SelectedInstanceID
	IF (SELECT COUNT(*) FROM #AppIDTable) = 0
	BEGIN
		SET @e_ErrorCode = 2
		SET @e_ErrorMessage = N'No backup data found for instance : ' + @i_InstanceName
		GOTO QS_SQLBROWSEDATA_EXIT
	END
	DECLARE @clientID  INT  = 0
	SELECT TOP 1 @clientID = clientID FROM APP_Application WHERE id IN (SELECT SubClientID FROM #AppIDTable) AND instance = @SelectedInstanceID AND appTypeId = 81
	IF EXISTS(SELECT 1
					FROM #QsBrowse_UserObjects sec
					WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND
							sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND
							sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND
							sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND
							sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND
							sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND
							sec.entityId4=0 AND sec.entityId5=0 AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
	BEGIN
		SET @isBrowseOperationPsbl = 1
	END
	IF EXISTS(SELECT 1 FROM #QsBrowse_UserObjects sec WHERE sec.clientId = @clientID AND (sec.appTypeId = 0 OR sec.appTypeId = 81) AND
															(sec.instanceId = 0 OR sec.instanceId = @SelectedInstanceID))
	BEGIN
		SET @isBrowseOperationPsbl = 1
	END
	IF (@isBrowseOperationPsbl = 0)
	BEGIN
		SET @e_ErrorCode = 100
		SET @e_ErrorMessage = N'User does not have rights to browse data on instance : ' + @i_InstanceName
		GOTO QS_SQLBROWSEDATA_EXIT
	END
	-- OUTPUT TABLES VALUES
	-- Table that contains the DB names that are backed up for the current instance.
	IF OBJECT_ID('tempdb.dbo.#OutDbNames') IS NOT NULL
		DROP TABLE #OutDbNames
	CREATE TABLE #OutDbNames ( sqlNameID INT, DataBaseName NVARCHAR(1024) )
	-- Table which includes sqlDBBackupInfo (Latest Cycle)
	IF OBJECT_ID('tempdb.dbo.#outBackupInfo') IS NOT NULL
		DROP TABLE #outBackupInfo
	CREATE TABLE #outBackupInfo ( BackupID INTEGER, BackupSetID INTEGER, sqlNameID INTEGER, DatabaseID INTEGER, MajorVersion INTEGER,
		MinorVersion INTEGER, typeBackup CHAR, BackupStartData INTEGER, BackupFinishDate INTEGER )
	-- Table which will holds physical file names for each DB.
	IF OBJECT_ID('tempdb.dbo.#outFileInfo') IS NOT NULL
		DROP TABLE #outFileInfo
	CREATE TABLE #outFileInfo ( ID INTEGER, phyFileName NVARCHAR(1024), LogicalFileName NVARCHAR(1024), FileGroupName NVARCHAR(1024) )
	--- other TABLE values
	--  table with DBBackupInfo entries for (given) single instance.
	IF OBJECT_ID('tempdb.dbo.#dbBackupInfo') IS NOT NULL
		DROP TABLE #dbBackupInfo
	CREATE TABLE #dbBackupInfo ( BackupID INTEGER, BackupSetID INTEGER, sqlNameID INTEGER, DatabaseID INTEGER, MajorVersion INTEGER,
		MinorVersion INTEGER, typeBackup CHAR, BackupStartData INTEGER, BackupFinishDate INTEGER )
	-- Table for storing SQL Database Name ID.
	IF OBJECT_ID('tempdb.dbo.#SQLNamesID') IS NOT NULL
		DROP TABLE #SQLNamesID
	CREATE TABLE #SQLNamesID (SqlNameID INTEGER)
	/* Get archive file from ArchFile, ArchFileCopy, ArchGroupCopy table */
	IF OBJECT_ID('tempdb.dbo.#archFileIdTable') IS NOT NULL
		DROP TABLE #archFileIdTable
	CREATE TABLE #archFileIdTable(archFileId INT, commCellId INT, jobId INT)
	IF @i_CopyPrecedence = 0
	BEGIN
		-- Get information from arch tables considering copy precedence as 0.
		INSERT  INTO #archFileIdTable
			SELECT  a.id, a.commCellId, a.jobid
				FROM
					archFile a, archFileCopy b, archGroupCopy c
				WHERE
					a.appId IN (SELECT SubClientID FROM #appIdTable) AND a.id = b.archFileId AND
					a.commCellId = b.commCellId AND a.fileType in (1, 4) AND b.isValid > 0 AND
					((b.flags & 256) = 0) AND b.archCopyId = c.id AND c.type <> 5
	END
	ELSE
	BEGIN
		-- Get information from arch tables considering given copy precedence.
		INSERT  INTO #archFileIdTable
			SELECT  a.id, a.commCellId, a.jobid
				FROM
					archFile a, archFileCopy b, archGroupCopy c
				WHERE
					a.appId IN (SELECT SubClientID FROM #appIdTable) AND a.id = b.archFileId AND
					a.commCellId = b.commCellId AND a.fileType in (1, 4) AND b.isValid > 0 AND
					((b.flags & 256) = 0) AND b.archCopyId = c.id AND c.type <> 5 AND
					(c.copy = @i_copyPrecedence OR @i_copyPrecedence = -1 AND c.id IN (SELECT defaultCopy FROM archGroup))
	END
	-- cross update information from JM tables.
	UPDATE #archFileIdTable
		SET #archFileIdTable.commCellId = JMPreparedJob.commCellId, #archFileIdTable.jobId = JMPreparedJob.jobId, #archFileIdTable.archFileId = archFile.id
		FROM JMPreparedJob, archFile
		WHERE JMPreparedJob.preparedJobId = #archFileIdTable.jobId AND JMPreparedJob.preparedJobCCId = #archFileIdTable.commCellId AND
				archFile.jobId = JMPreparedJob.jobId AND archFile.commCellId = JMPreparedJob.commCellId
	/*********      Get Client and Instance & Check for browse capability   *********/
	-- Get Database Name ID from SqlDBBackupInfo. And Check if any valid entry found.
	--	If not found, send error XML.
	INSERT INTO #SQLNamesID
		SELECT DISTINCT sqlNameId
			FROM SQLDBBackupInfo
				WHERE instanceId = @SelectedInstanceID AND
						appId IN (SELECT SubClientID FROM #AppIDTable)
	IF (SELECT COUNT(*) FROM #SQLNamesID) = 0
	BEGIN
		SET @e_ErrorCode = 3
		SET @e_ErrorMessage = N'No Backup history found for the instance : ' + @i_InstanceName
		GOTO QS_SQLBROWSEDATA_EXIT
	END
	-- Get database Names backed up for this instance. And Check if any valid entry found.
	--	If not found, send error XML.
	-- if Database Name is provided, find that database alone.
	IF @i_DatabaseName IS NULL or @i_DatabaseName = ''
	BEGIN
		INSERT INTO #outDbNames
			SELECT SN.id, SN2.name
				FROM
						sqlNames SN
					JOIN
						sqlNames2 SN2
					ON SN.sqlId = SN2.id
					INNER JOIN #SQLNamesID SNID
					ON SN.id = SNID.SQLNameID
				WHERE SN.type  = 1
	END
	ELSE
	BEGIN
		INSERT INTO #outDbNames
			SELECT SN.id, SN2.name
				FROM
						sqlNames SN
					JOIN
						sqlNames2 SN2
					ON SN.sqlId = SN2.id
					INNER JOIN #SQLNamesID SNID
					ON SN.id = SNID.SQLNameID
			WHERE SN.type  = 1 AND SN2.NAME = @i_DatabaseName
	END
	IF (SELECT COUNT(*) FROM #outDbNames) = 0
	BEGIN
		SET @e_ErrorCode = 4
		SET @e_ErrorMessage = N' No Database backup history found. '
		GOTO QS_SQLBROWSEDATA_EXIT
	END
	-- Populate all DB backup info for the instance. And Check if any valid entry found.
	--	If not found, send error XML.
	INSERT INTO #dbBackupInfo
		SELECT id, backup_set_id, sqlNameId, dbId, majorVersion, minorVersion, type, backup_start_date, backup_finish_date
			FROM
				SQLDBBackupInfo
			WHERE
				sqlNameID in (SELECT sqlNameID FROM #outDbNames) AND
				instanceId = @SelectedInstanceID AND
				jobId in (SELECT jobId FROM #archFileIdTable)
	IF (SELECT COUNT(*) FROM #dbBackupInfo) = 0
	BEGIN
		SET @e_ErrorCode = 5
		SET @e_ErrorMessage = N' No Database backup history found. '
		GOTO QS_SQLBROWSEDATA_EXIT
	END
	-- Find the last (latest) backup cycle for each database.
	DECLARE CurDbName CURSOR FOR SELECT * from #outDbNames
	OPEN CurDbName
	Declare @NameID integer
	Declare @DbName nvarchar(1024)
	DECLARE @sqlDBBackupInfoID_first integer
	Fetch next from CurDbName into @NameID, @DbName
	-- Loop all DBs
	WHILE @@FETCH_STATUS = 0
	BEGIN
		-- Loop till you find the Last Full for the current DB
		DECLARE backupInfoCur CURSOR FOR
			SELECT backupid, typeBackup
				FROM #dbBackupInfo
					WHERE sqlNameID = @NameID
						ORDER BY BackupFinishDate DESC
		OPEN backupInfoCur
		DECLARE @TypeOfBackup CHAR
		DECLARE @backupID INTEGER
		FETCH NEXT FROM backupInfoCur INTO @backupID, @TypeOfBackup
		-- Using last backup ID as reference, physical files for current DB are identified.
		IF @@FETCH_STATUS = 0
			SET @sqlDBBackupInfoID_first = @backupID
		-- This will calculate only latest backup chain for the latest backup data.
		DECLARE @SkipOthersBackupInChain INTEGER = 0
		WHILE @@FETCH_STATUS = 0
		BEGIN
			IF @typeOfbackup = 'D'
			BEGIN
				INSERT INTO #outBackupInfo
					SELECT * FROM #dbBackupInfo WHERE BackupID = @backupID
				BREAK
			END
			-- Add the backup information if skip flag is not set.
			IF @SkipOthersBackupInChain = 0
			BEGIN
				INSERT INTO #outBackupInfo
					SELECT * FROM #dbBackupInfo WHERE BackupID = @backupID
			END
			IF @typeOfbackup = 'I'
			BEGIN
				set @SkipOthersBackupInChain = 1
			END
			FETCH NEXT FROM backupInfoCur INTO @backupID, @TypeOfBackup
		END
		CLOSE backupInfoCur
		DEALLOCATE backupInfoCur
		-- Get physical filenames using SqlDBBackupInfoID
		DECLARE @FgID INTEGER
		DECLARE @PhyId INTEGER
		DECLARE @LogID integer
		DECLARE CurFileInfo CURSOR FOR
			SELECT sqlNameFgid, sqlNamePhyId, SqlNameLogID  from sqlfileBackupInfo where sqlDbBackupInfoId = @sqlDBBackupInfoID_first
		OPEN CurFileInfo
		FETCH NEXT FROM CurFileInfo INTO @FgID, @PhyId, @LogID
		WHILE @@FETCH_STATUS = 0
		BEGIN
			INSERT INTO #outFileInfo
				VALUES (@NameID,
						(select SN2.name FROM sqlNames SN  JOIN sqlNames2 SN2 ON SN.sqlId = SN2.id  WHERE SN.id = @PhyId),
						(select SN2.name FROM sqlNames SN  JOIN sqlNames2 SN2 ON SN.sqlId = SN2.id  WHERE SN.id = @LogID),
						(select SN2.name FROM sqlNames SN  JOIN sqlNames2 SN2 ON SN.sqlId = SN2.id  WHERE SN.id = @FgID))
			FETCH NEXT FROM CurFileInfo INTO @FgID, @PhyId, @LogID
		END
		CLOSE CurFileInfo
		DEALLOCATE CurFileInfo
		FETCH NEXT FROM CurDbName INTO @NameID, @DbName
	END
	CLOSE CurDbName
	DEALLOCATE CurDbName
	-- convert to XML string
	set @o_XmlOutputString = ( select ( select * from #outDbNames FOR XML PATH('DatabaseInfo'), ROOT('BackupDatabases'), TYPE ),
									( select * from #outFileInfo for XML PATH('FileInfo'), ROOT('SQLDBFileInfo'), TYPE ),
									( select * from #outBackupInfo for XML PATH('DatabaseBackupInfo'), ROOT('SQLDBBackupInfo'), TYPE )
									FOR XML PATH(''), ROOT('App_SQLBackupBrowseResp'), TYPE )
QS_SQLBROWSEDATA_EXIT:
	IF @e_ErrorCode > 0
	BEGIN
		SET @o_XmlOutputString = (select (SELECT @e_ErrorCode as ErrorCode, @e_ErrorMessage as ErrorMessage
									FOR XML PATH('Error'), ROOT('App_SQLBackupBrowseResp'), TYPE))
	END
SELECT @o_XmlOutputString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SQLBrowseData')
	delete from GxQscripts where name = 'QS_SQLBrowseData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SQLBrowseData')
	delete from GXDBVersions where aliasname = 'QS_SQLBrowseData'
GO

insert into GXDBVersions values(2, 'QS_SQLBrowseData',  '00000000000000000000', 'QS_SQLBrowseData', '00000000000000000000')
GO

insert into GxQscripts values(2+8,'QS_SQLBrowseData',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '    qoperation execscript -sn QS_SQLBrowseData -si instance_name -si database_name -si copy_precedence
'
 + CHAR(10) + '--   script_name : QS_SQLBrowseData'
)
GO

