

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ReviewPendingBadChunks.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: anarulkar
--	Date:   05/22/2014
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_ReviewPendingBadChunks.sp,v $ $Id: QS_ReviewPendingBadChunks.sp,v 1.1.2.3 2020/09/30 02:31:06 sjohnson Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_ReviewPendingBadChunks')
BEGIN
	print '>>> Drop Stored Procedure: QS_ReviewPendingBadChunks <<<'
	drop procedure QS_ReviewPendingBadChunks
END
IF EXISTS (select * from GxQscripts where name='QS_ReviewPendingBadChunks')
	delete from GxQscripts where name = 'QS_ReviewPendingBadChunks'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ReviewPendingBadChunks')
	delete from GXDBVersions where aliasname = 'QS_ReviewPendingBadChunks'
GO
print '... Creating Procedure: QS_ReviewPendingBadChunks'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_ReviewPendingBadChunks
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_SIDBStoreId integer,
  @i_MountPathId integer,
  @i_sourceJobId integer,
  @i_StartTime datetime,
  @i_EndTime datetime,
  @i_Action integer,
  @i_ChunkCommCellId integer = 2
AS
  DECLARE @o_ChunksAffected integer
  DECLARE @o_StoreRemovedFromReview integer
  DECLARE @o_ErrorCode integer
  DECLARE @o_ErrorString varchar(1024)
SET NOCOUNT ON
IF @i_ChunkCommCellId = 0
BEGIN
	SET @i_ChunkCommCellId = 2 --DEFAULT CCID
END
DECLARE @ActionApprove integer = 0
DECLARE @ActionReject integer = 1
DECLARE @OutMessage varchar(1024)
DECLARE @BadChunksToReview TABLE (archChunkId bigint, chunkCommCellId int)
SET @o_StoreRemovedFromReview = 0
SET @o_ErrorCode = 0
SET @o_ErrorString = 'No Error'
BEGIN TRAN
BEGIN TRY
INSERT INTO @BadChunksToReview
SELECT ACDrop.archChunkId, ACDrop.chunkCommCellId
FROM  ArchChunkDDBDrop ACDrop
LEFT OUTER JOIN  ArchChunk AC ON ACDrop.archChunkId = AC.id AND ACDrop.chunkCommCellId = AC.commCellId
LEFT OUTER JOIN MMVolume V ON AC.VolumeId = V.VolumeId
LEFT OUTER JOIN MMMountPath MP ON V.MediaSideId = MP.MediaSideId --archCHunkDDBDrop MountPathId may be set to 0
WHERE ACDrop.SIDBStoreId = @i_SIDBStoreId
AND ((ACDrop.MountPathId = @i_MountPathId) OR (MP.MountPathId = @i_MountPathId) OR @i_MountPathId = 0)
AND insertTime >= dbo.GetUnixTime(dbo.ClientLocalToUTCTime(@i_StartTime, 2))
AND (insertTime <= dbo.GetUnixTime(dbo.ClientLocalToUTCTime(@i_EndTime, 2))
	OR (dbo.GetUnixTime(dbo.ClientLocalToUTCTime(@i_EndTime, 2)) = 0))
AND ((reserveInt = @i_sourceJobId) OR (@i_sourceJobId = 0))
AND chunkCommCellId = @i_ChunkCommCellId
AND (ACDrop.flags & 1) <> 0
SET @o_ChunksAffected = @@ROWCOUNT
IF @i_Action = @ActionApprove
BEGIN
	UPDATE ACDrop
SET ACDrop.flags = ((ACDrop.flags & ~1) | 8),
		ACDrop.insertTime = dbo.GetUnixTime(GETUTCDATE())
	FROM ArchChunkDDBDrop ACDrop
	JOIN @BadChunksToReview BC ON ACDrop.archChunkId = BC.archChunkId AND ACdrop.chunkCommCellId = BC.chunkCommCellId
END
ELSE IF @i_Action= @ActionReject
BEGIN
	DECLARE @archFileCopyTable TABLE (archFileId INTEGER, commCellId INTEGER, archCopyId INTEGER)
	DECLARE @now int = dbo.GetUnixTime(GETUTCDATE())
	DELETE ACDrop
	FROM ArchChunkDDBDrop ACDrop
	JOIN @BadChunksToReview BC ON ACDrop.archChunkId = BC.archChunkId AND ACdrop.chunkCommCellId = BC.chunkCommCellId
	--Here we should reset chunks marked bad flag. Since we are rejecting these bad chunks.
	UPDATE AC
SET flags = flags & ~8192, ModifiedTime = @now
	FROM ArchChunk AC
	JOIN @BadChunksToReview BC ON AC.id = BC.archChunkId AND AC.commCellId = BC.chunkCommCellId
	UPDATE ACM
SET flags = flags & ~8192, ModifiedTime = @now
	OUTPUT INSERTED.archFileId, INSERTED.CommCellId, INSERTED.archCopyId INTO @archFileCopyTable
	FROM ArchChunkMapping ACM
	JOIN @BadChunksToReview BC ON ACM.archChunkId = BC.archChunkId AND ACM.chunkCommCellId = BC.chunkCommCellId
	/*
	Now reset flags on AFC if there are no ACM entries with bad flags.
	This may still not be true reversal as while marking AFC bad we consider the request that comes in.
	Which means we can have archFiles referencing bad chunks also marked as bad and we dont have this info from request saved anywhere.
	But this change should be okay since we dont modify verification status even on rejection
	*/
	UPDATE AFC
SET flags = AFC.flags & ~8192, ModifiedTime = @now
	FROM ArchFileCopy AFC
	JOIN archFile AF ON AF.id = AFC.archFileId AND AF.CommCellId = AFC.CommCellId
	JOIN @archFileCopyTable AFCT ON AFCT.archFileId = AFC.archFileId AND AFCT.CommCellId = AFC.CommCellId
AND ((AF.flags & (32768|2097152)) > 0 OR AFCT.archCopyId = AFC.archCopyId)
	LEFT OUTER JOIN ArchChunkMapping ACM ON ACM.archFileId = AFC.archFileId AND ACM.CommCellId = AFC.CommCellId
AND ((AF.flags & (32768|2097152)) > 0 OR ACM.archCopyId = AFC.archCopyId)
AND ACM.flags & 8192 > 0
	WHERE ACM.archChunkId IS NULL
END
IF NOT EXISTS (SELECT 1 FROM archChunkDDBDrop
				WHERE SIDBStoreId = @i_SIDBStoreId
AND (flags  & 1) <> 0)
BEGIN
	UPDATE IdxSIDBStore
SET extendedFlags = extendedFlags & ~16
	WHERE SIDBStoreId = @i_SIDBStoreId
AND (extendedFlags & 16) <> 0
	SET @o_StoreRemovedFromReview = 1
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_ErrorCode = ERROR_NUMBER()
	SET @o_ErrorString = ERROR_MESSAGE()
END CATCH
SELECT @o_ChunksAffected, @o_StoreRemovedFromReview,@o_ErrorCode, @o_ErrorString
IF @o_ErrorCode = 0
BEGIN
	COMMIT TRAN
	SET @OutMessage = 'Reviewed ' + CAST(@o_ChunksAffected AS VARCHAR) + ' Chunks.'
	IF @o_StoreRemovedFromReview = 1
	BEGIN
		SET @OutMessage = @OutMessage + ' Store removed from review pending state.'
	END
	PRINT 'Successfully completed running script ReviewPendingBadChunks. ' + @OutMessage
END
ELSE
BEGIN
	IF @@TRANCOUNT > 0
		ROLLBACK TRAN
	Raiserror(@o_ErrorString,
				15, --Severity (>10 to force DOS Error Code = 1)
				1 	--State
				)
END
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ReviewPendingBadChunks')
	delete from GxQscripts where name = 'QS_ReviewPendingBadChunks'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ReviewPendingBadChunks')
	delete from GXDBVersions where aliasname = 'QS_ReviewPendingBadChunks'
GO

insert into GXDBVersions values(2, 'QS_ReviewPendingBadChunks',  '00010001000200030000', 'QS_ReviewPendingBadChunks', '00010001000200030000')
GO

insert into GxQscripts values(2,'QS_ReviewPendingBadChunks',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '    Command to review pending bad chunks: qoperation execscript -sn ReviewPendingBadChunks -si SIDBStoreId -si MountPathId -si sourceJobId -si StartTime -si EndTime -si Action -si ChunkCommCellId
'
 + CHAR(10) + '--   Action: '
 + CHAR(10) + '--   0 - Approve bad Chunks '
 + CHAR(10) + '--   1 - Reject bad Chunks '
 + CHAR(10) + '-- 	Please enter mountpathId as 0 to act on all MountPaths '
 + CHAR(10) + '-- 	Please enter empty StartTime and/or endTime to disregard these parameters'
)
GO

