

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_RetainJobsOnMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_RetainJobsOnMedia.sp,v $ $Id: QS_RetainJobsOnMedia.sp,v 1.1.2.1 2019/02/10 20:24:13 pkrishnan Exp $";
--
--  +========================================================================+
--  | Stored Precedure: QS_RetainJobsOnMedia()
--  +========================================================================+
--
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_RetainJobsOnMedia')
BEGIN
	print '>>> Drop Stored Procedure: QS_RetainJobsOnMedia <<<'
	drop procedure QS_RetainJobsOnMedia
END
IF EXISTS (select * from GxQscripts where name='QS_RetainJobsOnMedia')
	delete from GxQscripts where name = 'QS_RetainJobsOnMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_RetainJobsOnMedia')
	delete from GXDBVersions where aliasname = 'QS_RetainJobsOnMedia'
GO
print '... Creating Procedure: QS_RetainJobsOnMedia'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_RetainJobsOnMedia
--Stored procedure inputs
  @i_filePath NVARCHAR(1024),
  @i_pinOrUnpin INT,
  @i_retainUntilDate NVARCHAR(1024) = N'INFINITE'
AS
SET NOCOUNT ON
BEGIN TRY
DECLARE @errorCode INT = 0
DECLARE @errorMessage VARCHAR(MAX) = ''
IF @i_filePath = N''  -- If input file path not passed
BEGIN
	SET @errorMessage = 'Please provide file path with list of media barcodes for the operation'
    RAISERROR(@errorMessage, 15, 1)
END
DECLARE @pinEndTime BIGINT
DECLARE @pinTimeForGAT VARCHAR(30) = ''
IF(@i_pinOrUnpin > 0)
BEGIN
	IF(LOWER(@i_retainUntilDate) = 'infinite')
	BEGIN
		SET @pinEndTime = -1
		SET @pinTimeForGAT = 'Infinite'
	END
	ELSE
	BEGIN
		SET @pinEndTime = dbo.GetUnixTimeBig(dbo.ClientLocalToUTCTime(@i_retainUntilDate, 2))
		SET @pinTimeForGAT = CAST(dbo.UTCToClientLocalTime(dbo.GetDateTimeBig(@pinEndTime), 2) AS VARCHAR(30))
	END
END
ELSE
	SET @pinEndTime = 0
IF OBJECT_ID('tempdb..#BarCodeList') IS NOT NULL
    DROP TABLE #BarCodeList
CREATE TABLE #BarCodeList(BarCode varchar(256), PRIMARY KEY(BarCode) WITH(ignore_dup_key = ON))
IF OBJECT_ID('tempdb..#jobsToRetain') IS NOT NULL
    DROP TABLE #jobsToRetain
CREATE TABLE #jobsToRetain(jobId int, commCellId int, archGrpCopyId int, Primary Key(jobId, commCellId, archGrpCopyId) WITH(ignore_dup_key = ON))
IF OBJECT_ID('tempdb..#jobsToRetainInBatch') IS NOT NULL
    DROP TABLE #jobsToRetainInBatch
CREATE TABLE #jobsToRetainInBatch(jobId int, commCellId int, archGrpCopyId int, Primary Key(jobId, commCellId, archGrpCopyId) WITH(ignore_dup_key = ON))
IF OBJECT_ID('tempdb..#MediaListAll') IS NOT NULL
	DROP TABLE #MediaListAll
CREATE TABLE #MediaListAll(archGroupCopyId INT, VolumeId INT, PRIMARY KEY(archGroupCopyId, VolumeId) WITH(ignore_dup_key = ON))
IF OBJECT_ID('tempdb..#MediaListInBatch') IS NOT NULL
	DROP TABLE #MediaListInBatch
CREATE TABLE #MediaListInBatch(VolumeId INT, PRIMARY KEY(VolumeId) WITH(ignore_dup_key = ON))
IF OBJECT_ID('tempdb..#tblResultArchPinJobsOnCopy') IS NOT NULL
		DROP TABLE #tblResultArchPinJobsOnCopy
CREATE TABLE #tblResultArchPinJobsOnCopy (errorCode int)
DECLARE @SQLString NVARCHAR(MAX)
SET @SQLString= 'BULK INSERT #BarCodeList FROM '''+ @i_filePath + ''' WITH (ROWTERMINATOR = ''\n'')'
EXEC sp_executesql @SQLString
INSERT INTO #MediaListAll
SELECT S.archGroupCopyId, V.volumeId
FROM #BarCodeList L INNER JOIN MMMedia M WITH(NOLOCK) ON L.barCode = M.barCode
INNER JOIN MMVolume V WITH(NOLOCK) ON M.mediaId = V.mediaId
INNER JOIN ArchStream S WITH(NOLOCK) ON V.mediaGroupId = S.mediaGroupId
IF OBJECT_ID('tempdb..#BarCodeList') IS NOT NULL
    DROP TABLE #BarCodeList
WHILE(EXISTS(SELECT 1 FROM #MediaListAll))
BEGIN
	TRUNCATE TABLE #MediaListInBatch
	--Pick volume list to process in this batch and remove them from original table so next batch will pick a new set. Order by copyId so that we process jobs of a copy as much together as possible
	;WITH CTE
	AS (SELECT TOP 1000 *
	FROM #MediaListAll
	ORDER BY archGroupCopyId, volumeId)
	DELETE FROM CTE
	OUTPUT DELETED.VolumeId INTO #MediaListInBatch
	TRUNCATE TABLE #jobsToRetain
	INSERT INTO #jobsToRetain
	SELECT DISTINCT ACM.jobId, ACM.commcellId, ACM.archCopyId
	FROM ArchChunkMapping ACM WITH(NOLOCK)
	INNER JOIN ArchChunk AC WITH(NOLOCK) ON ACM.archChunkId = AC.id AND ACM.chunkCommcellId = AC.commcellId
	INNER JOIN #MediaListInBatch V ON AC.VolumeId = V.VolumeId
WHERE ACM.flags & 256 = 0
	IF(@i_pinOrUnpin = 0)
	BEGIN
		--If the operation is to unpin jobs, process only those jobs that have manual retention set
		DELETE #jobsToRetain
		FROM #jobsToRetain T INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON T.jobId = JDS.jobId AND T.commcellId = JDS.commcellId
AND T.archGrpCopyId = JDS.archGrpCopyId AND (JDS.disabled & 2 = 0)
	END
	IF NOT EXISTS(SELECT 1 FROM #jobsToRetain)
	BEGIN
		--SET @errorMessage = 'No jobs are eligible to process for the operation in the given media.'
	    --RAISERROR(@errorMessage, 15, 1)
	    CONTINUE
	END
	DECLARE @l_copyid INT
	--Batching by copy
	DECLARE COPYLIST_CURSOR CURSOR FOR
	SELECT DISTINCT archGrpCopyId FROM #jobsToRetain
	OPEN COPYLIST_CURSOR
	FETCH NEXT FROM COPYLIST_CURSOR INTO @l_copyId
	WHILE(@@FETCH_STATUS = 0)
	BEGIN
		WHILE(EXISTS(SELECT 1 FROM #jobsToRetain WHERE archGrpCopyId = @l_copyId))
		BEGIN
			DECLARE @opMsgId        INT = 0
			DECLARE @opEvMsgId      INT = 0
			DECLARE @opId           INT = 0
			DECLARE @paramMsgId     INT = 0
			DECLARE @UserId INT = 1    --Assume admin user.
			DECLARE @spName NVARCHAR(1024) = ''
			DECLARE @copyName NVARCHAR(1024) = ''
			DECLARE @l_archGroupId INT = 0
			DECLARE @jobListXml XML
			TRUNCATE TABLE #jobsToRetainInBatch
			--Pick jobs to process in this batch and remove them from original table so next batch will pick a new set
			;WITH CTE
			AS (SELECT TOP 5000 *
			FROM #jobsToRetain WHERE archGrpCopyId = @l_copyId
			ORDER BY jobId, commcellId)
			DELETE FROM CTE
			OUTPUT DELETED.* INTO #jobsToRetainInBatch
			SET @jobListXml =
			    (
			        SELECT jobId, commCellId, archGrpCopyId
			        FROM #jobsToRetainInBatch JobInfo
			        FOR XML AUTO,ROOT('GalaxyOperations_PinJobs')
			    )
			TRUNCATE TABLE #tblResultArchPinJobsOnCopy
			EXEC archPinJobsOnCopy @i_pinOrUnpin, @pinEndTime, @UserId, @jobListXml
			SELECT top 1 @errorCode = errorCode FROM #tblResultArchPinJobsOnCopy
			--Ignore the errors about index backup job
IF(@errorCode & ~(195) <> 0)
			BEGIN
				SET @errorMessage = 'Failed to modify retention. Stored proc: ArchPinJobsOnCopy failed with error code - ' + CAST(@errorCode AS VARCHAR(10))
				RAISERROR(@errorMessage, 15, 1)
			END
			SELECT @spName = AG.name, @copyName = AGC.name, @l_archGroupId = AG.id
		            FROM    archGroup AG WITH (NOLOCK),archGroupCopy AGC WITH (NOLOCK)
		            WHERE   AG.id = AGC.archGroupId
		                AND AGC.id = @l_copyId
			IF(@i_pinOrUnpin > 0)
SET @opMsgId = (24 | (CAST(POWER(2, 24) AS BIGINT) * 84))
			ELSE
SET @opMsgId = (25 | (CAST(POWER(2, 24) AS BIGINT) * 84))
		    EXEC EvGuiAuditSetOpWithEntity @opMsgId, @UserId, 17, @l_archGroupId, @opEvMsgId OUTPUT, @opId OUTPUT
SET @paramMsgId = (26 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		    EXEC EvGuiAuditSetParamData @opId, @spName, 0
		    EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @UserId
SET @paramMsgId = (27 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		    EXEC EvGuiAuditSetParamData @opId, @copyName, 0
		    EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @UserId
			IF(@i_pinOrUnpin > 0)
			BEGIN
SET @paramMsgId = (1164 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			    EXEC EvGuiAuditSetParamData @opId, @pinTimeForGAT, 0
			    EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @UserId
			END
		    DECLARE @jobList nvarchar(max) = NULL
		    SELECT @jobList = COALESCE(@jobList+', ' ,'') + CAST(jobId as varchar(10))
			FROM #jobsToRetainInBatch
SET @paramMsgId = (3 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		    EXEC EvGuiAuditSetParamData @opId, @jobList, 0
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @UserId
		END
		FETCH NEXT FROM COPYLIST_CURSOR INTO @l_copyId
	END
	CLOSE COPYLIST_CURSOR
	DEALLOCATE COPYLIST_CURSOR
END
END TRY
BEGIN CATCH
	IF (CURSOR_STATUS('global', 'COPYLIST_CURSOR') >= -1) OR (CURSOR_STATUS('local', 'COPYLIST_CURSOR') >= -1)
	BEGIN
		IF (CURSOR_STATUS('global', 'COPYLIST_CURSOR') >= 0) OR (CURSOR_STATUS('local', 'COPYLIST_CURSOR') >= 0)
		BEGIN
			CLOSE COPYLIST_CURSOR
		END
		DEALLOCATE COPYLIST_CURSOR
	END
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    ;THROW
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'QS_RetainJobsOnMedia')
	delete from GxQscripts where name = 'QS_RetainJobsOnMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_RetainJobsOnMedia')
	delete from GXDBVersions where aliasname = 'QS_RetainJobsOnMedia'
GO

insert into GXDBVersions values(2, 'QS_RetainJobsOnMedia',  '00010001000200010000', 'QS_RetainJobsOnMedia', '00010001000200010000')
GO

insert into GxQscripts values(2,'QS_RetainJobsOnMedia',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '--   QOperation execscript -sn QS_RetainJobsOnMedia -si BarCodeListFilePath -si <OpType 1- Set manual retention 0- Unset manual retention> [-si RetainUntilDate = ''mm/dd/yyyy'' or ''Infinite'']'
)
GO

