

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ResetWormCopyToRegularCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_ResetWormCopyToRegularCopy')
BEGIN
	print '>>> Drop Stored Procedure: QS_ResetWormCopyToRegularCopy <<<'
	drop procedure QS_ResetWormCopyToRegularCopy
END
IF EXISTS (select * from GxQscripts where name='QS_ResetWormCopyToRegularCopy')
	delete from GxQscripts where name = 'QS_ResetWormCopyToRegularCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ResetWormCopyToRegularCopy')
	delete from GXDBVersions where aliasname = 'QS_ResetWormCopyToRegularCopy'
GO
print '... Creating Procedure: QS_ResetWormCopyToRegularCopy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_ResetWormCopyToRegularCopy
-- Qscript is enabled
-- Set to low audit level
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_StoragePolicy nvarchar(2048)='',
  @i_StoragePolicyCopy nvarchar(2048)='',
  @i_authCode nvarchar(1024)=''
AS
SET NOCOUNT ON
DECLARE  @errorCode 	INTEGER = 0
DECLARE	 @errorString  	VARCHAR(1024)
-- Declare temp variables for Gui Audit
DECLARE @opMsgId 			INTEGER
DECLARE @opEvMsgId 		INTEGER
DECLARE @opId 				INTEGER
DECLARE @paramMsgId 	INTEGER
DECLARE @GUIAuditUserId INT
SELECT	@GUIAuditUserId = 1
-- Reset the WORM COPY as regular copy to allow the copy deletion
DECLARE @i_SPId INTEGER
SET     @i_SPId = -1
DECLARE @i_SPCId INTEGER
SET     @i_SPCId = -1
DECLARE @decryptedAuthCode 	NVARCHAR(1024)
DECLARE @commCellGUIDCode		VARCHAR(256)
SELECT @i_SPId = Id
FROM archGroup WITH (NOLOCK)
WHERE name = @i_StoragePolicy
SET @errorCode = @@ERROR
IF  @errorCode <> 0 GOTO CX_EXIT
IF @i_SPId = -1
BEGIN
    SET @errorCode = -1
    SET @errorString = 'Error: Invalid Storage Policy Name [' + @i_StoragePolicyCopy + ']'
    GOTO CX_EXIT
END
SELECT @i_SPCId = id
FROM archGroupCopy WITH (NOLOCK)
WHERE   name = @i_StoragePolicyCopy
        AND archGroupId = @i_SPId
SET @errorCode = @@ERROR
IF  @errorCode <> 0 GOTO CX_EXIT
IF @i_SPCId = -1
BEGIN
    SET @errorCode = -2
    SET @errorString = 'Error: Invalid Storage Policy Copy Name [' + @i_StoragePolicyCopy + ']'
    GOTO CX_EXIT
END
IF EXISTS (SELECT * FROM archGroupCopy WHERE id = @i_SPCId AND archGroupId = @i_SPId AND ((flags & 16777216) = 0))
BEGIN
    SET @errorCode = -3
    SET @errorString = 'Error: Storage Policy Copy [' + @i_StoragePolicyCopy + '] is not worm copy'
    GOTO CX_EXIT
END
-- Get GUID from DB
SELECT @commCellGUIDCode = RIGHT(csGUID, 10) FROM APP_CommCell WHERE id = 2
-- form GUID as user see XXX-XXX-XXXX
SET @commCellGUIDCode = ( SELECT (LEFT(@commCellGUIDCode, 3) + '-' + SUBSTRING(@commCellGUIDCode, 4, 3) + '-' + RIGHT(@commCellGUIDCode, 4)))
SET @commCellGUIDCode = 'RESET_WORM_' + @i_StoragePolicy + '_' + @i_StoragePolicyCopy + '_' + @commCellGUIDCode
SELECT  @errorCode = @@ERROR, @errorString = ERROR_MESSAGE()
IF  @errorCode <> 0 GOTO CX_EXIT
IF(@i_authCode = '' OR @i_authCode = '%s') --IF Authentication code is not passed
BEGIN
    SET @errorCode = -4
    SET @errorString = 'Need Auth code to execute this script, please contact customer support for auth code.'
    GOTO CX_EXIT
END
ELSE
BEGIN
	EXEC miscProc2 @i_authCode, @decryptedAuthCode OUTPUT
	IF @commCellGUIDCode != @decryptedAuthCode
  BEGIN
  	SET @errorCode = -5
    SET @errorString = 'Error: Invalid Auth code, please contact customer support for valid auth code.'
    GOTO CX_EXIT
  END
END;
-- Disable Trigger
DISABLE TRIGGER ArchGroupCopyUpgTrigger ON archgroupcopy;
UPDATE  archGroupCopy
SET     flags = flags & ~16777216
WHERE   Id = @i_SPCId
        AND (flags & 16777216) <> 0
SELECT  @errorCode = @@ERROR, @errorString = ERROR_MESSAGE()
IF  @errorCode <> 0 GOTO CX_EXIT
-- Set Gui Audit Operation
SET @opMsgId = (14 | (CAST(POWER(2, 24) AS BIGINT) * 84))
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @GUIAuditUserId, 17, @i_SPId, @opEvMsgId OUTPUT, @opId OUTPUT
-- Set Gui Audit Parameter - Storage Policy Name
SET @paramMsgId = (26 | (CAST(POWER(2, 24) AS BIGINT) * 85))
EXEC EvGuiAuditSetParamData @opId, @i_StoragePolicy, 0
EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @GUIAuditUserId
-- Set Gui Audit Parameter - Copy Name
SET @paramMsgId = (27 | (CAST(POWER(2, 24) AS BIGINT) * 85))
EXEC EvGuiAuditSetParamData @opId, @i_StoragePolicyCopy, 0
EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @GUIAuditUserId
SET @paramMsgId = (676 | (CAST(POWER(2, 24) AS BIGINT) * 84))
EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @GUIAuditUserId
CX_EXIT:
-- Re enable Trigger
ENABLE TRIGGER ArchGroupCopyUpgTrigger ON archgroupcopy;
    IF (@errorCode <> 0)
    BEGIN
        Raiserror(@errorString,
                    15,  --Severity (> 10 to force DOS Error Code = 1)
                    1    --State
                    )
    END
RETURN @errorCode -- return the error code as well
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ResetWormCopyToRegularCopy')
	delete from GxQscripts where name = 'QS_ResetWormCopyToRegularCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ResetWormCopyToRegularCopy')
	delete from GXDBVersions where aliasname = 'QS_ResetWormCopyToRegularCopy'
GO

insert into GXDBVersions values(2, 'QS_ResetWormCopyToRegularCopy',  '00000000000000000000', 'QS_ResetWormCopyToRegularCopy', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ResetWormCopyToRegularCopy',  2, GETDATE(), GETDATE(), '' + CHAR(10) + ' Qscript to update the device access path for a given library name and media agent client name.
'
 + CHAR(10) + ' Usage:
'
 + CHAR(10) + '--  qoperation execscript -sn ResetWormCopyToRegularCopy -si Storage_Policy_Name -si Storage_Policy_Copy_Name -si Auth_Code'
)
GO

