

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ResetSearchEngineCloudId.sp] ---------- 

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ResetSearchEngineCloudId <<<'

IF EXISTS (select * from sysobjects where name='QS_ResetSearchEngineCloudId')
	drop procedure QS_ResetSearchEngineCloudId
IF EXISTS (select * from GxQscripts where name='QS_ResetSearchEngineCloudId')
	delete from GxQscripts where name = 'QS_ResetSearchEngineCloudId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ResetSearchEngineCloudId')
	delete from GXDBVersions where aliasname = 'QS_ResetSearchEngineCloudId'
GO
print '... Creating Procedure: QS_ResetSearchEngineCloudId'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_ResetSearchEngineCloudId
--This script is used to set  new cloudId in commserver database in case of disaster recovery case.
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--  4 Corresponds to "high", same as same functionality in GUI.  Macro doesn't expand right for some reason
-- Qscript Usage.
-- SP Input Params
  @oldSearchEngineName nvarchar(1024)=N'%s',
  @newSearchEngineName NVARCHAR(1024)=N'%s'
AS
Set NOCOUNT ON
------------ Convenience Definitions    -----------
	DECLARE @scriptName	varchar(64)
	SET		@scriptName	= 'QS_ResetSearchEngineCloudId'
	DECLARE @lastError	integer
	SET		@lastError	= 0
	DECLARE @localErrorMsg		nvarchar(512)
	SET		@localErrorMsg			=N'Successful.'
	DECLARE @now				integer
	SET @now = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @NoParameter		nvarchar(4)
	SET     @NoParameter            =N'%'                        -- Get Around QScript Parameter
	SET     @NoParameter            =@NoParameter + N's'         -- .. Substitution
	DECLARE @oldCloudId INT =0
	DECLARE @newCloudId INT =0
------------------------Check for input parameters------------------------
	IF @oldSearchEngineName = @NoParameter
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg =N'Error. Old Search Engine name is not provided.'
		GOTO PROC_ERROR
	END
	IF @newSearchEngineName = @NoParameter
	BEGIN
		SET @lastError = 2
		SET @localErrorMsg =N'Error. New Search Engine name is not provided.'
		GOTO PROC_ERROR
	END
------------------------Check if search engine exists or not------------------------
	SET @oldCloudId = ISNULL ((SELECT id FROM APP_ComponentProp WITH (NOLOCK) WHERE componentType = 1 AND componentid = 2 AND propertyTypeId = 1 AND stringVal =@oldSearchEngineName),0)
	IF @oldCloudId =0
	BEGIN
		SET @lastError = 3
		SET @localErrorMsg =N'Error. Old Search Engine ['+ @oldSearchEngineName +'] does not exists.'
		GOTO PROC_ERROR
	END
	SET @newCloudId = ISNULL ((SELECT id FROM APP_ComponentProp WITH (NOLOCK) WHERE componentType = 1 AND componentid = 2 AND propertyTypeId = 1 AND stringVal =@newSearchEngineName),0)
	IF @newCloudId =0
	BEGIN
		SET @lastError = 4
		SET @localErrorMsg =N'Error. New Search Engine ['+ @newSearchEngineName +'] does not exists.'
		GOTO PROC_ERROR
	END
BEGIN TRY
BEGIN TRAN
------------------------Update newer CloudId everywhere in CS tables ------------------------
		UPDATE	archContentIndexingAged
		SET		cloudId = @newCloudId
		WHERE	cloudId = @oldCloudId
		IF (@@ERROR <> 0)
		BEGIN
			SET @lastError = @@ERROR
			SET @localErrorMsg = 'Failed to update new cloudId into archContentIndexingAged table.'
			GOTO ERROR_EXIT
		END
		UPDATE ArchFile
		SET		cloudId = @newCloudId
		WHERE	cloudId = @oldCloudId
		IF (@@ERROR <> 0)
		BEGIN
			SET @lastError = @@ERROR
			SET @localErrorMsg = 'Failed to update new cloudId into ArchFile table.'
			GOTO ERROR_EXIT
		END
		UPDATE archContentIndexingRestart
		SET		cloudId = @newCloudId
		WHERE	cloudId = @oldCloudId
		IF (@@ERROR <> 0)
		BEGIN
			SET @lastError = @@ERROR
			SET @localErrorMsg = 'Failed to update new cloudId into archContentIndexingRestart table.'
			GOTO ERROR_EXIT
		END
----------------------------------------------------------------------------------------------
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @lastError = @@error
	SET @localErrorMsg = (SELECT ERROR_MESSAGE())
END CATCH
ERROR_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
PROC_ERROR:
	PRINT ''
	PRINT @scriptName + ' completed at '
					+ Convert(varchar(60), getdate())+' with parameters '
					+ 'OldSearchEngineName ['+ @oldSearchEngineName + '],'
					+ 'NewSearchEngineName ['+ @newSearchEngineName + '].'
					+ ' ErrorCode (' + Convert(varchar(2),@lastError) +').'
	if @lastError <> 0
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ResetSearchEngineCloudId')
	delete from GxQscripts where name = 'QS_ResetSearchEngineCloudId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ResetSearchEngineCloudId')
	delete from GXDBVersions where aliasname = 'QS_ResetSearchEngineCloudId'
GO

insert into GXDBVersions values(2, 'QS_ResetSearchEngineCloudId',  '00000000000000000000', 'QS_ResetSearchEngineCloudId', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ResetSearchEngineCloudId',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		qoperation execscript -sn QS_ResetSearchEngineCloudId -si OldSearchEngineName -si NewSearchEngineName'
 + CHAR(10) + '-- 		Reset search engine cloudId in Commserver database.'
 + CHAR(10) + '-- 		OldSearchEngineName: Name of the previous search engine'
 + CHAR(10) + '-- 		NewSearchEngineName: Name of the new search engine'
)
GO

