

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ResetIndexServerForReviewSet.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2015 Commvault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_ResetIndexServerForReviewSet')
BEGIN
	print '>>> Drop Stored Procedure: QS_ResetIndexServerForReviewSet <<<'
	drop procedure QS_ResetIndexServerForReviewSet
END
IF EXISTS (select * from GxQscripts where name='QS_ResetIndexServerForReviewSet')
	delete from GxQscripts where name = 'QS_ResetIndexServerForReviewSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ResetIndexServerForReviewSet')
	delete from GXDBVersions where aliasname = 'QS_ResetIndexServerForReviewSet'
GO
print '... Creating Procedure: QS_ResetIndexServerForReviewSet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_ResetIndexServerForReviewSet
  @i_indexServerClientName NVARCHAR(255) = '%s'
AS
SET NOCOUNT ON
--
DECLARE @scriptName nvarchar(32) = 'QS_ResetIndexServerForReviewSet';
DECLARE @errorCode int = 0;
DECLARE @errorString nvarchar(1024) = 'Success';
IF @i_indexServerClientName = '%s'
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Please provide Index Server client name as input.'
	GOTO ARGS_ERROR
END
DECLARE @CloudId INT =ISNULL((SELECT cloudId FROM DM2Cloud DC (NOLOCK) JOIN APP_Client C (NOLOCK) ON DC.pseudoClientId = C.Id WHERE C.name = @i_indexServerClientName ),0)
IF @CloudId = 0
BEGIN
	SET @errorCode = 2
	SET @errorString = 'Error. Invalid Index server client name is provided.'
	GOTO ARGS_ERROR
END
--RESET CLOUDiD INTO DM2Container table
UPDATE DM2Container
SET cloudId = 0
WHERE cloudId = @CloudId
--
ARGS_ERROR:
 SELECT @scriptName + ' completed at ' + CONVERT(nvarchar(60), GETDATE())
+ '. Error Code ['+ CONVERT(nvarchar(2), @errorCode) +'].'
IF @errorCode <> 0
	RAISERROR(@errorString, 15 /* Severity > 10 to force DOS error code 1 */, 1);
GO
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ResetIndexServerForReviewSet')
	delete from GxQscripts where name = 'QS_ResetIndexServerForReviewSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ResetIndexServerForReviewSet')
	delete from GXDBVersions where aliasname = 'QS_ResetIndexServerForReviewSet'
GO

insert into GXDBVersions values(2, 'QS_ResetIndexServerForReviewSet',  '00000000000000000000', 'QS_ResetIndexServerForReviewSet', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ResetIndexServerForReviewSet',  0, GETDATE(), GETDATE(), '' + CHAR(10) + ' This qscript is used to disassociate the given Index Server from all review sets.
'
 + CHAR(10) + ' You must run this qscript when you perform the following operations:
'
 + CHAR(10) + ' * Before deleting an Index Server. Associated review set data may be lost after disassociation.
'
 + CHAR(10) + ' * After performing a hardware refresh for the Web Server. The review sets are automatically reassociated with the correct Index Server.
'
 + CHAR(10) + '--  qoperation execscript -sn QS_ResetIndexServerForReviewSet -si Index_Server_Client_Name'
 + CHAR(10) + '--  Index_Server_Client_Name -   The client name of the index server.'
 + CHAR(10) + ' 
'
)
GO

