

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ResetDDBMaintenanceStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_ResetDDBMaintenanceStatus.sp,v $ $Id: QS_ResetDDBMaintenanceStatus.sp,v 1.5.50.3 2018/05/23 22:12:06 sjohnson Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ResetDDBMaintenanceStatus <<<'

IF EXISTS (select * from sysobjects where name='QS_ResetDDBMaintenanceStatus')
	drop procedure QS_ResetDDBMaintenanceStatus
IF EXISTS (select * from GxQscripts where name='QS_ResetDDBMaintenanceStatus')
	delete from GxQscripts where name = 'QS_ResetDDBMaintenanceStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ResetDDBMaintenanceStatus')
	delete from GXDBVersions where aliasname = 'QS_ResetDDBMaintenanceStatus'
GO
print '... Creating Procedure: QS_ResetDDBMaintenanceStatus'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_ResetDDBMaintenanceStatus
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @PARAM1 VARCHAR(1024) = '',
  @PARAM2 VARCHAR(1024) = '',
  @PARAM3 VARCHAR(1024) = ''
AS
SET NOCOUNT ON
-- Proc Inputs
DECLARE @i_StoreId INT
DECLARE @i_AuthCode INT
DECLARE @i_MarkAsCorrupt INT
-- Locals
DECLARE @ErrorCode INT = 0
DECLARE @ErrorString VARCHAR(1024) = ''
DECLARE @NoParam VARCHAR(10) = ''
-- Validate inputs
IF @PARAM1 = @NoParam OR @PARAM2 = @NoParam
BEGIN
	SET @ErrorString = 'Insufficient command line parameters.'
	SET @ErrorCode = -1
	GOTO SCRIPT_EXIT
END
-- Populate inputs
SET @i_StoreId = CONVERT (INT, @PARAM1)
SET @i_AuthCode = CONVERT (INT, @PARAM2)
IF @PARAM3 = @NoParam
	SET @i_MarkAsCorrupt = 0
ELSE
	SET @i_MarkAsCorrupt = CONVERT (INT, @PARAM3)
DECLARE @i_CommcellNo INT
SELECT @i_CommcellNo = number from APP_CommCell where id = 2
DECLARE @ScriptName VARCHAR(256) = 'ResetDDBMaintenanceStatus'
/*
SELECT	(checksum(HASHBYTES('SHA1','<'+@ScriptName+'><'+CAST(@i_CommcellNo AS VARCHAR(100))+'><'+CAST(@i_StoreId AS VARCHAR(100))+'><COMMVAULT>')) & 2147483646)
*/
-- Validate inputs -
-- Validate authcode.
-- If authcode is odd,
IF @i_AuthCode % 2 <> 0
BEGIN
	IF((CHECKSUM(HASHBYTES('SHA1','<'+@ScriptName+'><'+CAST(@i_CommcellNo AS VARCHAR(100))+'><'+CAST(@i_StoreId AS VARCHAR(100))+'><COMMVAULT>')) & 2147483646)+1 <>  @i_authcode)
	BEGIN
		RAISERROR ('Error: Incorrect Authentication code passed.', 15, 2)
		GOTO SCRIPT_EXIT
	END
END
-- If authcode is even,
ELSE
BEGIN
	IF((CHECKSUM(HASHBYTES('SHA1','<'+@ScriptName+'><'+CAST(@i_CommcellNo AS VARCHAR(100))+'><'+CAST(@i_StoreId AS VARCHAR(100))+'><COMMVAULT>')) & 2147483646) <> @i_authcode)
	BEGIN
		RAISERROR ('Error: Incorrect Authentication code passed.', 15, 2)
		GOTO SCRIPT_EXIT
	END
END
-- Make sure the store is actually in maintenance.
IF NOT EXISTS (SELECT * FROM IdxSIDBStore WHERE SIDBStoreId = @i_StoreId AND (Flags & (16777216 | 33554432)) <> 0)
BEGIN
	RAISERROR ('Input store not found or is not in maintenance. Cannot proceed.', 15, 1)
	GOTO SCRIPT_EXIT
END
-- Do the work now.
BEGIN TRY
BEGIN TRAN
-- Reset maintenance status.
EXEC MMDDBSetMaintenanceStatus @i_StoreId, 0, 0, 0
-- Mark store as corrupt.
IF @i_MarkAsCorrupt = 1
BEGIN
	UPDATE IdxSIDBSubStore
	SET Status = 1
	WHERE SIDBStoreId = @i_StoreId
	UPDATE IdxSIDBStore
	SET Status = 1
	WHERE SIDBStoreId = @i_StoreId
END
COMMIT TRAN
END TRY
-- Process errors
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @ErrorCode = ERROR_STATE ()
	SET @ErrorString = ERROR_MESSAGE ()
	IF @@TranCount > 0
		ROLLBACK TRAN
END CATCH
SCRIPT_EXIT:
IF @ErrorCode <> 0
	RAISERROR (@ErrorString, 15, 1)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ResetDDBMaintenanceStatus')
	delete from GxQscripts where name = 'QS_ResetDDBMaintenanceStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ResetDDBMaintenanceStatus')
	delete from GXDBVersions where aliasname = 'QS_ResetDDBMaintenanceStatus'
GO

insert into GXDBVersions values(2, 'QS_ResetDDBMaintenanceStatus',  '00010005005000030000', 'QS_ResetDDBMaintenanceStatus', '00010005005000030000')
GO

insert into GxQscripts values(2,'QS_ResetDDBMaintenanceStatus',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '--       Reset maintenance status for given deduplication database:-'
 + CHAR(10) + '--           qoperation execscript -sn ResetDDBMaintenanceStatus -si <StoreId> -si <AuthCode> -si <MarkForRecon> '
 + CHAR(10) + '--       		StoreId - Id of the deduplication database whose maintenance status has to be reset.'
 + CHAR(10) + '--       		AuthCode - Authcode from CommVault '
 + CHAR(10) + '--           	MarkForRecon - Optional argument. When set to ''1'', marks the store as corrupt.'
)
GO

