

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_RepickSnapJobsOnCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_RepickSnapJobsOnCopy.sp,v $ $Id: QS_RepickSnapJobsOnCopy.sp,v 1.1.4.11 2018/11/14 19:23:12 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_RepickSnapJobsOnCopy')
BEGIN
	print '>>> Drop Stored Procedure: QS_RepickSnapJobsOnCopy <<<'
	drop procedure QS_RepickSnapJobsOnCopy
END
IF EXISTS (select * from GxQscripts where name='QS_RepickSnapJobsOnCopy')
	delete from GxQscripts where name = 'QS_RepickSnapJobsOnCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_RepickSnapJobsOnCopy')
	delete from GXDBVersions where aliasname = 'QS_RepickSnapJobsOnCopy'
GO
print '... Creating Procedure: QS_RepickSnapJobsOnCopy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_RepickSnapJobsOnCopy
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @inputSnapJobID INT ,
  @inputCCID INT,
  @authCode INT
AS
DECLARE @snapjobtime AS INT = 0;
DECLARE @sourceCopy AS INT = 0;
DECLARE @retSTr AS NVARCHAR (100) = '';
DECLARE @errorCode AS INT = 0;
IF ISNULL(@authCode, 0) = 0 --IF Authorization code is not passed
BEGIN
    SET @retSTr = N'No Authorization code passed. Authorization code required.'
    SET @errorCode = -1
    GOTO SCRIPT_EXIT
END
DECLARE @l_CommCellNumber int = 0
SELECT @l_CommCellNumber = number from APP_CommCell WITH(NOLOCK) where id = 2
IF ((CHECKSUM(HASHBYTES('SHA1', '<' + CAST(@l_commCellNumber AS VARCHAR(100)) + 'RepickSnapJobsOnCopy' + '><COMMVAULT>')) & 2147483646) <> @authCode)
BEGIN
    SET @retSTr = N'Incorrect Authorization code passed. Correct Authorization code required.'
    SET @errorCode = -1
    GOTO SCRIPT_EXIT
END
--DECLARE @inputSnapJobID AS INT = 3381;
DECLARE @snapJObs TABLE (
    jobId                INT     ,
    commcellId           INT     ,
    materiaLisationJobId INT     ,
    archGrpId            INT     ,
    unPickReason         SMALLINT,
    flags                INT     );
DECLARE @appID AS INT = 0;
DECLARE @archiveFileXML AS XML = '';
SET NOCOUNT ON;
BEGIN TRANSACTION;
SELECT @appID = appid,
       @snapjobtime = servStartDate
FROM   JMBkpStats WITH (NOLOCK)
WHERE  jobid = @inputSnapJobID
	   AND CommCellId = @inputCCID;
IF(@appID = 0 OR @snapjobtime = 0)
BEGIN
	SET @retSTr = 'Invalid input job id';
    SET @errorCode = 1;
    GOTO SCRIPT_EXIT;
END
-- Step 1.
IF EXISTS (SELECT *
           FROM   JMBkpJobInfo WITH (NOLOCK)
           WHERE  applicationId = @appID
		   AND CommCellId = @inputCCID)
    BEGIN
        SET @retSTr = 'There are Backup Jobs Running For the SubClient, Please wait for the Jobs to complete';
        SET @errorCode = 2;
        GOTO SCRIPT_EXIT;
    END
--Step 2.
INSERT INTO @snapJObs
SELECT snaps.jobID,
       snaps.commcellId,
       snaps.materializationJobId,
       snaps.archGrpId,
       snaps.unpickReason,
       snaps.flags
FROM   JMbkpstats AS bkp WITH (NOLOCK)
       INNER JOIN
       JMJobSnapshotStats AS snaps WITH (NOLOCK)
       ON bkp.jobId = snaps.jobID
WHERE  bkp.appId = @appID
       AND bkp.servStartDate >= @snapjobtime
       AND snaps.materializationStatus = 100
	   AND bkp.CommCellId = @inputCCID
	   AND snaps.CommCellId = @inputCCID
IF @@ROWCOUNT = 0
BEGIN
	SET @retSTr = 'Job is not moved to tape';
    SET @errorCode = 3;
    GOTO SCRIPT_EXIT;
END
--If there are synthetic full that exists in the cycles that we are recopying
IF EXISTS(SELECT 1 FROM JMBkpStats WITH(NOLOCK) WHERE bkpLevel = 64 AND appId = @appID AND servStartDate > @snapjobtime AND status IN (1, 3, 14))
BEGIN
	SET @retSTr = 'Synthetic full exists. Cannot recopy';
    SET @errorCode = -1;
    GOTO SCRIPT_EXIT;
END
IF OBJECT_ID('tempdb..#tblJobToDelete') IS NOT NULL DROP TABLE #tblJobToDelete
CREATE TABLE #tblJobToDelete
    (
        jobId           int,
        commCellId  int,
        primary key (jobId, commCellId)
    )
/*If there are later jobs that are backup copied but aged from all copies clean up their backup copy stats record so backup copy of re-picked job doesn't fail validation*/
DELETE J
OUTPUT DELETED.jobId, DELETED.commcellId INTO #tblJobToDelete
FROM @snapJobs J LEFT OUTER JOIN JMJobDataStats JDS WITH(NOLOCK) ON J.jobId = JDS.jobId AND J.commcellId = JDS.commCellId AND JDS.status IN (100, 102, 103)
LEFT OUTER JOIN ArchFile AF WITH(NOLOCK) ON J.jobId = AF.jobId AND J.commcellId = AF.commcellId
WHERE JDS.jobId IS NULL AND AF.id IS NULL AND NOT (J.jobId = @inputSnapJobID AND J.commcellId = @inputCCID)
DELETE JSS
FROM JMJobSnapShotStats JSS WITH(NOLOCK) INNER JOIN #tblJobToDelete T ON JSS.jobId = T.jobId AND JSS.commcellId = T.commcellId
IF OBJECT_ID('tempdb..#tblJobToDelete') IS NOT NULL DROP TABLE #tblJobToDelete
--Step 3
IF EXISTS (SELECT *
           FROM   JMJObDataStats AS jds WITH (NOLOCK)
                  INNER JOIN
                  @snapJObs AS t
                  ON (t.jobId = jds.JobID AND t.CommCellId = jds.CommCellId ), archMaterializeSnapshotProp AS SnapProps
           WHERE  ((SnapProps.sourceCopyId <> 0
                        AND jds.archGrpCopyId = SnapProps.sourceCopyId)
                       OR (SnapProps.sourceCopyId = 0
                           AND jds.archGrpCopyId = (SELECT defaultSnapCopy
                                                 FROM   archGroup WITH (NOLOCK)
                                                 WHERE  id = t.archGrpId)))
                  AND SnapProps.archGroupId = t.archGrpId
AND (jds.Status != 100 OR jds.Disabled & 256 > 0)) --cva_aged
    BEGIN
        SET @retSTr = 'One Of the Archive File for the given job and Subsequent Jobs for the SubClient is invalid or not present in source snap copy';
        SET @errorCode = 4;
        GOTO SCRIPT_EXIT;
    END
--Step 4we need to check copyid also
SET @archiveFileXML = (SELECT *
                       FROM   (SELECT DISTINCT AF.id AS archFileId,
                                      AF.commCellId AS commCelld --considering only non snap copy
                               FROM   archFile AS AF WITH (NOLOCK), archfilecopy AS AFC WITH (NOLOCK), @snapJObs AS t, archGroupCopy AS AGC WITH (NOLOCK)
                               WHERE  AFC.archFileId = AF.id
                                      AND AFC.commCellId = AF.commCellId
                                      AND AF.jobid = t.jobid
									  AND AF.CommCellID = t.commCellId
									  AND AFC.archCopyId = AGC.id
									  AND AGC.isSnapCopy = 0
AND AF.flags & 2 = 0) AS archFileInfo -- CVA_AF_SNAP_DATA_FLAG Archive file of a snap job
                       FOR    XML AUTO, ROOT ('GalaxyOperations_PruneArchiveFiles'));
BEGIN TRY
	IF(@archiveFileXML IS NOT NULL)
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#tblResultarchDeleteArchiveFiles') IS NOT NULL  DROP TABLE #tblResultarchDeleteArchiveFiles
		CREATE TABLE #tblResultarchDeleteArchiveFiles(retCode int, retStr varchar(1024))
EXECUTE @errorCode = archDeleteArchiveFiles @archiveFileXML, 262144, 0; -- 124 #define CVA_AGED_BY_UTILITY                 262144  --(1 << 18)
	    --SET @errorCode = @@ERROR
	    IF ((@errorCode != 0)
	        OR ((SELECT top 1 retCode FROM #tblResultarchDeleteArchiveFiles) != 0))
	        BEGIN
	            SET @retSTr = 'Failed to prune archive files related to the Backup Copy Jobs - ' + ISNULL((SELECT top 1 retStr FROM #tblResultarchDeleteArchiveFiles), '');
	            SET @errorCode = 5;
	            GOTO SCRIPT_EXIT;
	        END
	END
    DELETE JDS
    FROM   JMJobDataStats AS JDS WITH (NOLOCK), @snapJObs AS t, archGroupCopy AS AGC WITH (NOLOCK)
    WHERE  JDS.jobID = t.jobId
		   AND JDS.CommCellId = t.CommCellId
		   AND JDS.archGrpCopyId = AGC.id
		   AND AGC.isSnapCopy = 0
           AND JDS.status = 1000;
    IF @@ROWCOUNT = 0
        BEGIN
            SET @retSTr = 'Failed to mark Backup Copy Jobs as aged - No rows deleted from JMJobDataStats';
            SET @errorCode = 6;
            GOTO SCRIPT_EXIT;
        END
    --Step 5,6
    UPDATE  snaps
        SET materializationStatus = 101,
            materializationJobId  = 0,
flags                 |= 2 --the new flag to be defined in amcdefs.h
    FROM    JMJobSnapShotStats AS snaps WITH (NOLOCK), @snapJObs AS t
    WHERE   snaps.jobId = t.jobId
			And snaps.CommCellId = t.CommCellId;
END TRY
BEGIN CATCH
    SET @errorCode = ERROR_NUMBER();
    SET @retStr = ERROR_MESSAGE();
    GOTO SCRIPT_EXIT;
END CATCH
COMMIT TRANSACTION;
SCRIPT_EXIT:
IF OBJECT_ID('tempdb.dbo.#tblResultarchDeleteArchiveFiles') IS NOT NULL  DROP TABLE #tblResultarchDeleteArchiveFiles
SET NOCOUNT OFF;
IF @errorCode <> 0
BEGIN
	IF @@TRANCOUNT > 0
		ROLLBACK TRANSACTION;
    RAISERROR (@retStr, 15, 1); --Severity (> 10 to force DOS Error Code = 1)State
END
GO

IF EXISTS (select * from GxQscripts where name = 'QS_RepickSnapJobsOnCopy')
	delete from GxQscripts where name = 'QS_RepickSnapJobsOnCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_RepickSnapJobsOnCopy')
	delete from GXDBVersions where aliasname = 'QS_RepickSnapJobsOnCopy'
GO

insert into GXDBVersions values(2, 'QS_RepickSnapJobsOnCopy',  '00010001000400110000', 'QS_RepickSnapJobsOnCopy', '00010001000400110000')
GO

insert into GxQscripts values(2,'QS_RepickSnapJobsOnCopy',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		To Repick Snap Job using the Snap JobId for the default commcell( commCellID 2)'
 + CHAR(10) + '-- 		qoperation execscript -sn RepickSnapJobsOnCopy -si snapJobId -si 2 -si authCode'
 + CHAR(10) + '-- 		To Repick Snap Job using the Snap JobId for a specific CommCell'
 + CHAR(10) + '-- 		qoperation execscript -sn RepickSnapJobsOnCopy -si snapJobId -si commcellId -si authCode'
)
GO

