

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_RenameSubclientPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_RenameSubclientPolicy <<<'

IF EXISTS (select * from sysobjects where name='QS_RenameSubclientPolicy')
	drop procedure QS_RenameSubclientPolicy
IF EXISTS (select * from GxQscripts where name='QS_RenameSubclientPolicy')
	delete from GxQscripts where name = 'QS_RenameSubclientPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_RenameSubclientPolicy')
	delete from GXDBVersions where aliasname = 'QS_RenameSubclientPolicy'
GO
print '... Creating Procedure: QS_RenameSubclientPolicy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_RenameSubclientPolicy
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @scpolicyName nvarchar(100)='%s',
  @newscpolicyName nvarchar(100)='%s'
AS
SET NOCOUNT ON
----------------------constants--------
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = 'RenameSubclientPolicy'
-----------------------error handling----
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
IF @scpolicyName = ''
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Subclient Policy name missing.'
	GOTO ARGS_ERROR
END
IF @newscpolicyName = ''
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. New Name of Subclient Policy missing.'
	GOTO ARGS_ERROR
END
-- Local Variables
DECLARE @nowTime				integer
SET     @nowTime				= dbo.GetUnixTime (GetUTCdate())
DECLARE @scpId INT=0
--------------------------apptype and default subclient checks..------------------------
SET @scpId =  ISNULL((select BS.id from APP_BackupSetName BS join APP_Application SC on SC.backupSet = BS.id
							where BS.name = @scpolicyName and SC.clientId = 2 and SC.appTypeId = 1030 and (Bs.status & 4 = 0)),0)
IF @scpId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString  = 'Subclient Policy :[' + @scpolicyName + '] does not exist.'
	GOTO ARGS_ERROR
END
IF (LEN(@newscpolicyName) > 100)
BEGIN
	SET @errorCode = 1
SET @errorString = 'Error. Subclient Policy name cannot be more than ' + CAST(100 AS VARCHAR(3)) + ' characters.'
	GOTO ARGS_ERROR
END
IF EXISTS (select BS.id from APP_BackupSetName BS join APP_Application SC on SC.backupSet = BS.id
							where BS.name = @newscpolicyName and SC.clientId = 2 and SC.appTypeId = 1030)
BEGIN
	SET @errorCode = 1
	SET @errorString  = 'Subclient Policy :[' + @newscpolicyName + '] already exists. Please provide a new name'
	GOTO ARGS_ERROR
END
BEGIN TRY
	BEGIN TRANSACTION
		update APP_BackupSetName set name = @newscpolicyName	,modified=@nowTime
		where id = (@scpId)
	COMMIT TRANSACTION
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
	PRINT N'Error occured. ErrorNo(' + CAST(@errorCode AS NVARCHAR) + N') ErrorMsg(' + @errorString + N').'
	PRINT N'So Rolling back Transactions.'
	ROLLBACK TRANSACTION
END CATCH
ARGS_ERROR:
	print @scriptName + ' completed at '	+ Convert(varchar(60), getdate())+'. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_RenameSubclientPolicy')
	delete from GxQscripts where name = 'QS_RenameSubclientPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_RenameSubclientPolicy')
	delete from GXDBVersions where aliasname = 'QS_RenameSubclientPolicy'
GO

insert into GXDBVersions values(2, 'QS_RenameSubclientPolicy',  '00000000000000000000', 'QS_RenameSubclientPolicy', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_RenameSubclientPolicy',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn RenameSubclientPolicy.sql -si old_subclientPolicyName -si new_subclientPolicyName
'
 + CHAR(10) + '--   script_name : QS_RenameSubclientPolicy'
)
GO

