

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_RenameSubclientName.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_RenameSubclientName <<<'

IF EXISTS (select * from sysobjects where name='QS_RenameSubclientName')
	drop procedure QS_RenameSubclientName
IF EXISTS (select * from GxQscripts where name='QS_RenameSubclientName')
	delete from GxQscripts where name = 'QS_RenameSubclientName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_RenameSubclientName')
	delete from GXDBVersions where aliasname = 'QS_RenameSubclientName'
GO
print '... Creating Procedure: QS_RenameSubclientName'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_RenameSubclientName
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @newSubClientName varchar(1030) = '%s',
  @param1 varchar(1030) = '%s',
  @param2 varchar(1030) = '%s',
  @param3 varchar(1030) = '%s',
  @param4 varchar(1030) = '%s',
  @param5 varchar(1030) = '%s'
AS
SET NOCOUNT ON
---------------command line inputs-------
--DECLARE @newSubClientName NVARCHAR(1030)
--SET @newSubClientName = '%s'
--DECLARE @param1  NVARCHAR(1030)
--SET @param1 = '%s'
--DECLARE @param2  NVARCHAR(1030)
--SET @param2 = '%s'
--DECLARE @param3  NVARCHAR(1030)
--SET @param3 = '%s'
--DECLARE @param4  NVARCHAR(1030)
--SET @param4 = '%s'
--DECLARE @param5  NVARCHAR(1030)
--SET @param5 = '%s'
--DECLARE @MAX_ENTITY_SIZE smallint
--SET @MAX_ENTITY_SIZE = 100
------------------------------------------
--SET @newSubClientName = 'newsubclientname'
--SET @param1 = 'c=stargate'
--SET @param2 = 'a=Q_LINUX_FS'
--SET @param3 = 'b=defaultbackupset'
--SET @param4 = 's=sc'
--SET @param5 = '%s'
--select @newSubClientName, @param1, @param2, @param3, @param4, @param5
-----------------------------------------
----------------------constants--------
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = 'RenameSubclientName'
--DECLARE @nowTime   integer
--SET		@nowTime  =   dbo.GetUnixTime (GetUTCdate())
-----------------------error handling----
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @noParameter varchar(4)
SET     @noParameter            ='%'                        -- Get Around QScript Parameter
SET     @noParameter            =@noParameter + 's'         -- .. Substitution
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
IF @newSubClientName = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. No New Subclient name given.'
	GOTO ARGS_ERROR
END
DECLARE @ClientId int
DECLARE @AppTypeId int
DECLARE @InstanceId int
DECLARE @BackupsetId int
DECLARE @subclientId int
if  OBJECTPROPERTY(object_id(N'[dbo].[QscriptGetAppIdsFromNames]'), N'IsProcedure') IS NULL
BEGIN
	SET @errorCode = 1
	SET @errorString  = 'This script requires Stored procedure QscriptGetAppIdsFromNames to be installed. Please install it and try again.'
	GOTO ARGS_ERROR
END
EXECUTE @errorCode = QscriptGetAppIdsFromNames @PARAM1, @PARAM2, @PARAM3, @PARAM4, @PARAM5,
	@subclientId OUTPUT, @BackupsetId OUTPUT, @InstanceId OUTPUT, @AppTypeId OUTPUT, @ClientId OUTPUT,
    @errorString OUTPUT
IF @errorCOde != 0
BEGIN
	GOTO ARGS_ERROR
END
--------------------------apptype and default subclient checks..------------------------
IF ((SELECT SubclientStatus & 2 FROM APP_APPLICATION WHERE id = @subclientid) = 2  OR
(SELECT SubclientStatus & 4 FROM APP_APPLICATION WHERE id = @subclientid) = 4 )
BEGIN
	SET @errorCode = 1
	SET @errorString  = 'Error. Subclient is deleted or uninstalled.'
	GOTO ARGS_ERROR
END
IF EXISTS (SELECT * from APP_Application where clientId = @Clientid and instance = @InstanceId and AppTypeId = @AppTypeId and Backupset = @BackupsetId and subclientName=@newSubClientName)
BEGIN
	SET @errorCode = 1
	SET @errorString  = 'Error. Subclient with this name already exists.'
	GOTO ARGS_ERROR
END
IF (LEN(@newSubClientName) > 100)
BEGIN
	SET @errorCode = 1
SET @errorString = 'Error. Subclient name cannot be more than ' + CAST(100 AS VARCHAR(3)) + ' characters.'
	GOTO ARGS_ERROR
END
-------------------reset empty options so that script exit message does not have [%s] as parameter--------
IF @PARAM1 = @noParameter
	SET @PARAM1 = ''
IF @PARAM2 = @noParameter
	SET @PARAM2 = ''
IF @PARAM3 = @noParameter
	SET @PARAM3 = ''
IF @PARAM4 = @noParameter
	SET @PARAM4 = ''
IF @PARAM5 = @noParameter
	SET @PARAM5 = ''
------------------------set contents or filters or exception to filter depending on input---------
--get correct slash
UPDATE APP_Application
    SET subclientName=@newSubClientName
    WHERE id=@subclientId
ARGS_ERROR:
print @scriptName + ' completed at '	+ Convert(varchar(60), getdate())+'. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_RenameSubclientName')
	delete from GxQscripts where name = 'QS_RenameSubclientName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_RenameSubclientName')
	delete from GXDBVersions where aliasname = 'QS_RenameSubclientName'
GO

insert into GXDBVersions values(2, 'QS_RenameSubclientName',  '00000000000000000000', 'QS_RenameSubclientName', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_RenameSubclientName',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn RenameSubclientName.sql -si newsubclientname -si c=client_name -si a=Ida_type -si b=backupsetName -si s=old_subclient_name
'
 + CHAR(10) + '--   script_name : RenameSubclientName'
)
GO

