

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_RenameBackupSet.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_RenameBackupSet <<<'

IF EXISTS (select * from sysobjects where name='QS_RenameBackupSet')
	drop procedure QS_RenameBackupSet
IF EXISTS (select * from GxQscripts where name='QS_RenameBackupSet')
	delete from GxQscripts where name = 'QS_RenameBackupSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_RenameBackupSet')
	delete from GXDBVersions where aliasname = 'QS_RenameBackupSet'
GO
print '... Creating Procedure: QS_RenameBackupSet'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_RenameBackupSet
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientName varchar(1024) = '%s',
  @AppTypeName varchar(1024) = '%s',
  @OldBackupset varchar(1024) = '%s',
  @Newbackupset varchar(1024) = '%s',
  @InstanceName varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @ClientName			nvarchar(1024)
--SET		@ClientName			= N'%s'
--DECLARE @AppTypeName		nvarchar(1024)
--SET 	@AppTypeName		= N'%s'
--DECLARE @OldBackupSet		nvarchar(1024)
--SET		@OldBackupSet		= N'%s'
--DECLARE @NewBackupSet		nvarchar(1024)
--SET		@NewBackupSet		= N'%s'
--DECLARE @InstanceName		nvarchar(1024)
--SET		@InstanceName		= N'%s'
--DECLARE @MAX_ENTITY_SIZE	smallint
--SET		@MAX_ENTITY_SIZE	= 100
---------------------------------------
--test
--SET		@ClientName			= 'c=uxustnst302'
--SET		@OldBackupSet		= 'o=defaultBackupSet'
--SET		@NewBackupSet		= 'n=zzz-defaultBackupSet'
--SET		@InstanceName		= 'i=default'
---------------------------------------
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'RenameBackupSet'
DECLARE @nowTime				integer
SET     @nowTime				= dbo.GetUnixTime (GetUTCdate())
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter			=@NoParameter + 's'			-- .. Substitution
-------- Local Variables    -------------
DECLARE @clientId				integer
SET @clientId					= 0
DECLARE @instanceId				integer
SET @instanceId					= 0
DECLARE @oldBackupSetId			integer
SET @oldBackupSetId				= 0
DECLARE @lastError				integer
SET @lastError					= 0
DECLARE @appTypeId				integer
SET @appTypeId					= 0
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			= 'No error encountered when running script.'
DECLARE @tmpAppTbl	TABLE(
						id integer,
						appTypeId integer,
						instance integer,
						backupset integer,
						clientId integer
					)
-- Process client name parameter
IF @ClientName = @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Client name not specified.'
	goto ARGS_ERROR
END
ELSE
BEGIN
	IF LOWER(SUBSTRING(@ClientName, 1, 2)) = N'c='
	BEGIN
		SET @ClientName = (SELECT SUBSTRING(@ClientName, 3, LEN(@ClientName)-2))
		SET @clientId = ISNULL((SELECT TOP(1) id FROM App_Client WHERE name = @ClientName),0)
		IF @clientId = 0
		BEGIN
			SET @lastError = 2
			SET @localErrorMsg = 'Error. Client not found.'
			goto ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SET @lastError = 3
		SET @localErrorMsg = 'Error. Invalid format to mention client name. Use c=<clientName>'
		goto ARGS_ERROR
	END
END
INSERT INTO @tmpAppTbl
SELECT id, appTypeId, instance, backupset, clientId FROM App_Application
WHERE clientId = @clientId
-- Process AppType name parameter
IF @AppTypeName = @NoParameter
BEGIN
	SET @lastError = 9
	SET @localErrorMsg = 'Error. App Type name not spcified.'
	goto ARGS_ERROR
END
ELSE
BEGIN
	IF LOWER(SUBSTRING(@AppTypeName, 1, 2)) = N'a='
	BEGIN
		SET @AppTypeName = UPPER(SUBSTRING(@AppTypeName, 3, LEN(@AppTypeName)-2))
		SET @appTypeId = (SELECT type FROM app_IDAType WHERE name=@AppTypeName AND type IN
							(SELECT appTypeId FROM @tmpAppTbl WHERE clientId = @clientId)
						)
		IF @appTypeId IS null
		BEGIN
			SET @appTypeId = (SELECT appTypeId FROM app_idaname
								WHERE clientid = @clientId AND appTypeId IN
									(SELECT DISTINCT type FROM APP_IDAType
											WHERE displayName = @AppTypeName)
							)
		END
		IF @appTypeId IS NULL
		BEGIN
			SET @lastError = 10
			SET @localErrorMsg = 'Error. AppType ['+ @apptypeName + '] does not exist on Client ['+ @clientName+'].'
			GOTO ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SET @lastError = 11
		SET @localErrorMsg = 'Error. Invalid format to mention app type name. Use a=<appTypeName>'
		goto ARGS_ERROR
	END
END
-- Process instance name parameter
IF @InstanceName <> @NoParameter
BEGIN
	IF LOWER(SUBSTRING(@InstanceName, 1, 2)) = N'i='
	BEGIN
		SET @InstanceName = (SELECT SUBSTRING(@InstanceName, 3, LEN(@InstanceName)-2))
		SET @instanceId = ISNULL(
			(SELECT TOP(1) I.id FROM App_InstanceName I INNER JOIN @tmpAppTbl A ON A.instance = I.id
				WHERE I.name = @InstanceName AND A.clientId = @clientId AND A.appTypeId = @appTypeId)
		,0)
		IF @instanceId = 0
		BEGIN
			SET @lastError = 4
			SET @localErrorMsg = 'Error. Instance not found.'
			goto ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SET @lastError = 5
		SET @localErrorMsg = 'Error. Invalid format to mention instance name. Use i=<instanceName>'
		goto ARGS_ERROR
	END
END
-- Process old BackupSet name
IF @OldBackupSet = @NoParameter
BEGIN
	SET @lastError = 6
	SET @localErrorMsg = 'Error. Old backup set not spcified.'
	goto ARGS_ERROR
END
ELSE
BEGIN
	IF LOWER(SUBSTRING(@OldBackupSet, 1, 2)) = N'o='
	BEGIN
		SET @OldBackupSet = (SELECT SUBSTRING(@OldBackupSet, 3, LEN(@OldBackupSet)-2))
		IF @instanceId = 0
		BEGIN
			IF  ( (SELECT COUNT(T.id) FROM (
					SELECT DISTINCT B.id AS id FROM App_BackupSetName B INNER JOIN @tmpAppTbl A ON
					B.id = A.BackupSet WHERE B.name = @OldBackupSet AND
					A.clientId = @clientId AND A.appTypeId = @appTypeId
				) T)
					> 1
				)
			BEGIN
				SET @lastError = 12
				SET @localErrorMsg = 'Error. Multiple backupsets found, please specify instance name.'
				goto ARGS_ERROR
			END
			SET @oldBackupSetId = ISNULL(
					(SELECT TOP(1) B.id FROM App_BackupSetName B INNER JOIN @tmpAppTbl A ON B.id = A.BackupSet
						WHERE B.name = @OldBackupSet AND A.clientId = @clientId AND A.appTypeId = @appTypeId)
				,0)
		END
		ELSE
		BEGIN
			SET @oldBackupSetId = ISNULL(
					(SELECT TOP(1) B.id FROM App_BackupSetName B INNER JOIN @tmpAppTbl A ON B.id = A.BackupSet
						WHERE B.name = @OldBackupSet AND A.clientId = @clientId AND A.appTypeId = @appTypeId AND A.instance = @instanceId)
				,0)
		END
		IF @oldBackupSetId = 0
		BEGIN
			SET @lastError = 7
			SET @localErrorMsg = 'Error. Backup set not found.'
			goto ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SET @lastError = 8
		SET @localErrorMsg = 'Error. Invalid format to mention old backup set name. Use o=<oldBackupSet>'
		goto ARGS_ERROR
	END
END
-- Process new BackupSet name
IF @NewBackupSet = @NoParameter
BEGIN
	SET @lastError = 6
	SET @localErrorMsg = 'Error. New backup set not spcified.'
	goto ARGS_ERROR
END
ELSE
BEGIN
	IF LOWER(SUBSTRING(@NewBackupSet, 1, 2)) = N'n='
	BEGIN
		SET @NewBackupSet = (SELECT SUBSTRING(@NewBackupSet, 3, LEN(@NewBackupSet)-2))
	END
	ELSE
	BEGIN
		SET @lastError = 8
		SET @localErrorMsg = 'Error. Invalid format to mention new backup set name. Use n=<newBackupSet>'
		goto ARGS_ERROR
	END
END
-- Check if backup set name already exists
IF @instanceId = 0
BEGIN
	IF EXISTS (SELECT B.name
	FROM App_Application A INNER JOIN App_BackupSetName B ON A.backupSet = B.id
	WHERE A.clientId = @clientId AND B.name = @NewBackupSet AND A.appTypeId IN (@appTypeId))
	BEGIN
		SET @lastError = 9
		SET @localErrorMsg = 'Error. New Backup Set name already exists. Please specify a different name.'
		goto ARGS_ERROR
	END
END
ELSE
BEGIN
	IF EXISTS (SELECT B.name
	FROM App_Application A INNER JOIN App_BackupSetName B ON A.backupSet = B.id
	WHERE A.clientId = @clientId AND B.name = @NewBackupSet AND A.appTypeId IN (@appTypeId) AND A.instance = @instanceId)
	BEGIN
		SET @lastError = 9
		SET @localErrorMsg = 'Error. New Backup Set name already exists. Please specify a different name.'
		goto ARGS_ERROR
	END
END
IF LEN(@NewBackupSet ) > 100
BEGIN
	SET @lastError = 1
SET @localErrorMsg = 'Error. Backupset name cannot be more than ' + CAST(100 AS VARCHAR(3)) + ' characters.'
	GOTO ARGS_ERROR
END
BEGIN TRY
	BEGIN TRANSACTION
		IF @instanceId = 0
		BEGIN
			UPDATE App_BackupSetName SET name = @NewBackupSet
			FROM App_Application A INNER JOIN App_BackupSetName B ON A.backupSet = B.id
			WHERE A.clientId = @clientId AND B.name = @OldBackupSet AND A.appTypeId IN (@appTypeId)
		END
		ELSE
		BEGIN
			UPDATE App_BackupSetName SET name = @NewBackupSet
			FROM App_Application A INNER JOIN App_BackupSetName B ON A.backupSet = B.id
			WHERE A.clientId = @clientId AND B.name = @OldBackupSet AND A.appTypeId IN (@appTypeId) AND A.instance = @instanceId
		END
	COMMIT TRANSACTION
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT @lastError = ERROR_NUMBER(), @localErrorMsg = ERROR_MESSAGE()
	PRINT N'Error occured. ErrorNo(' + CAST(@lastError AS NVARCHAR) + N') ErrorMsg(' + @localErrorMsg + N').'
	PRINT N'So Rolling back Transactions.'
	ROLLBACK TRANSACTION
END CATCH
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with '
         + ' Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_RenameBackupSet')
	delete from GxQscripts where name = 'QS_RenameBackupSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_RenameBackupSet')
	delete from GXDBVersions where aliasname = 'QS_RenameBackupSet'
GO

insert into GXDBVersions values(2, 'QS_RenameBackupSet',  '00000000000000000000', 'QS_RenameBackupSet', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_RenameBackupSet',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qoperation execscript -sn RenameBackupSet.sql -si c=clientName -si a=appTypeName -si o=oldBackupSetName -si n=newBackupSetName [-si i=instanceName]
'
 + CHAR(10) + '--   script_name : RenameBackupSet'
)
GO

