

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_RemoveUserGUIPreferences.sp] ---------- 

--  +========================================================================+
--  |		 		Name:  QS_RemoveUserGUIPreferences
--  | Description:  This SP is from Permanent QScript - RemoveUserGUIPreferences.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_RemoveUserGUIPreferences.sp,v $ $Id: QS_RemoveUserGUIPreferences.sp,v 1.3.60.2 2018/03/22 01:51:42 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_RemoveUserGUIPreferences <<<'

IF EXISTS (select * from sysobjects where name='QS_RemoveUserGUIPreferences')
	drop procedure QS_RemoveUserGUIPreferences
IF EXISTS (select * from GxQscripts where name='QS_RemoveUserGUIPreferences')
	delete from GxQscripts where name = 'QS_RemoveUserGUIPreferences'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_RemoveUserGUIPreferences')
	delete from GXDBVersions where aliasname = 'QS_RemoveUserGUIPreferences'
GO
print '... Creating Procedure: QS_RemoveUserGUIPreferences'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_RemoveUserGUIPreferences
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_userLogin NVARCHAR(2048)
AS
	DECLARE @scriptName				varchar(32)
	SET		@scriptName				= 'removeUserGUIpreferences'
	DECLARE @lastError				integer
	DECLARE @errorMsg				varchar(512)
	DECLARE @userId					INT
	DECLARE @NoParameter			varchar(10)
	SET		@errorMsg				='Error Encountered when running script.'
	SET     @lastError				= 0		-- Be optimistic
	SET		@userId					= 0
	SET		@NoParameter			='%'						-- Get Around QScript Parameter
	SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
	SET NOCOUNT ON
BEGIN TRY
	IF @i_userLogin = @NoParameter
	BEGIN
		Set @lastError = 1
		SET @errorMsg	='Error. user login  not specified.'
		goto   ARGS_ERROR
	END
	SET @userId = ISNULL((Select [id] from UMUsers Where login = @i_userLogin), 0)
	IF	@userId <= 0
	BEGIN
		Set @lastError      = 2
		SET @errorMsg  = 'User with login [' + @i_userLogin + '] does not exist on this commserver.'
		goto   ARGS_ERROR
	END
	--  DO THE WORK:
	DELETE UMUserPrefs where userId = @userId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    Set @lastError = ERROR_NUMBER()
    SET @errorMsg  = ERROR_MESSAGE()
END CATCH
ARGS_ERROR:
print @scriptName + ' completed at '	+ Convert(varchar(60), getdate())+'. ErrorCode ('+	Convert(varchar(2),@lastError) +').'
if @lastError <> 0
	Raiserror(@errorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_RemoveUserGUIPreferences')
	delete from GxQscripts where name = 'QS_RemoveUserGUIPreferences'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_RemoveUserGUIPreferences')
	delete from GXDBVersions where aliasname = 'QS_RemoveUserGUIPreferences'
GO

insert into GXDBVersions values(2, 'QS_RemoveUserGUIPreferences',  '00010003006000020000', 'QS_RemoveUserGUIPreferences', '00010003006000020000')
GO

insert into GxQscripts values(2,'QS_RemoveUserGUIPreferences',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn RemoveUserGUIPreferences.sql -si UserLoginName 
'
)
GO

