

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_RemoveEventMsgIDs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Pratima Kudale
--	Date:   01/11/2018
-- ----------------------------------------------------------------------*/
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_RemoveEventMsgIDs <<<'

IF EXISTS (select * from sysobjects where name='QS_RemoveEventMsgIDs')
	drop procedure QS_RemoveEventMsgIDs
IF EXISTS (select * from GxQscripts where name='QS_RemoveEventMsgIDs')
	delete from GxQscripts where name = 'QS_RemoveEventMsgIDs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_RemoveEventMsgIDs')
	delete from GXDBVersions where aliasname = 'QS_RemoveEventMsgIDs'
GO
print '... Creating Procedure: QS_RemoveEventMsgIDs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_RemoveEventMsgIDs
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage.
-- Stored Procedure Inputs
  @MessageID BIGINT
AS
    if @MessageID = 0
    begin
           DELETE FROM EvMsgsToIgnoreCustom
           select 'Events will no longer be diverted to log files'
    end
    else if @MessageID is null
           select 'Please specify either 0 to remove all messages OR a valid message ID which needs to be removed'
    else
    begin
           DELETE FROM EvMsgsToIgnoreCustom where MessageID = @MessageID
           IF @@ROWCOUNT > 0
                  select 'The specified message will no longer be diverted to a log file'
           else
                  select 'The specified message was not found in the event diversion list'
    end
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'QS_RemoveEventMsgIDs')
	delete from GxQscripts where name = 'QS_RemoveEventMsgIDs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_RemoveEventMsgIDs')
	delete from GXDBVersions where aliasname = 'QS_RemoveEventMsgIDs'
GO

insert into GXDBVersions values(2, 'QS_RemoveEventMsgIDs',  '00000000000000000000', 'QS_RemoveEventMsgIDs', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_RemoveEventMsgIDs',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		qoperation execscript -sn RemoveEventMsgIDs -si MessageID'
 + CHAR(10) + '-- 		Script to remove event message ID which are marked for diversion to a log file'
 + CHAR(10) + '-- 	    MessageID: valid event message ID or ''0'' if all event message IDs needs to be removed'
)
GO

