

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ReassociateWorkflowSchedules.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ReassociateWorkflowSchedules <<<'

IF EXISTS (select * from sysobjects where name='QS_ReassociateWorkflowSchedules')
	drop procedure QS_ReassociateWorkflowSchedules
IF EXISTS (select * from GxQscripts where name='QS_ReassociateWorkflowSchedules')
	delete from GxQscripts where name = 'QS_ReassociateWorkflowSchedules'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ReassociateWorkflowSchedules')
	delete from GXDBVersions where aliasname = 'QS_ReassociateWorkflowSchedules'
GO
print '... Creating Procedure: QS_ReassociateWorkflowSchedules'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_ReassociateWorkflowSchedules
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--SP Input Params
  @oldWorkflowName varchar(1024) = '%s',
  @newWorkflowName varchar(1024) = '%s'
AS
SET NOCOUNT ON
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'QS_ReassociateWorkflowSchedules'
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET	@localErrorMsg			='Error Encountered when running script.'
----------------------- check inputs -----------------
IF @oldWorkflowName	= @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Old workflow name is Expected as parameter 1.'
	GOTO ARGS_ERROR
END
IF @newWorkflowName	= @NoParameter
BEGIN
	SET @lastError = 2
	SET @localErrorMsg = 'Error. New workflow name is Expected as parameter 2.'
	GOTO ARGS_ERROR
END
	DECLARE @oldWorkflowId INT = 0
	DECLARE @newWorkflowId INT = 0
	SELECT @oldWorkflowId = WorkflowId
	FROM WF_Definition (NOLOCK)
	WHERE Name=@oldWorkflowName
	SELECT @newWorkflowId = WorkflowId
	FROM WF_Definition (NOLOCK)
	WHERE Name=@newWorkflowName
	IF @oldWorkflowId = 0
	BEGIN
		SET @lastError = 3
		SET @localErrorMsg = 'Error. Old workflow [' + @oldWorkflowName + '] not found in database.'
		GOTO ARGS_ERROR
	END
	IF @newWorkflowId = 0
	BEGIN
		SET @lastError = 4
		SET @localErrorMsg = 'Error. New workflow [' + @newWorkflowName + '] not found in database.'
		GOTO ARGS_ERROR
	END
BEGIN TRY
BEGIN TRAN
	UPDATE TM_AssocEntity SET workflowId = @newWorkflowId WHERE workflowId = @oldWorkflowId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @lastError = @@ERROR
	SET @localErrorMsg = (SELECT ERROR_MESSAGE())
	goto ARGS_ERROR
END CATCH
TRANS_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
ARGS_ERROR:
PRINT ''
PRINT @scriptName + ' completed at '
		+ Convert(varchar(60), getdate())
		+ ' with Parameters: ['+@oldWorkflowName+', '+@newWorkflowName+
		+ ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ReassociateWorkflowSchedules')
	delete from GxQscripts where name = 'QS_ReassociateWorkflowSchedules'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ReassociateWorkflowSchedules')
	delete from GXDBVersions where aliasname = 'QS_ReassociateWorkflowSchedules'
GO

insert into GXDBVersions values(2, 'QS_ReassociateWorkflowSchedules',  '00000000000000000000', 'QS_ReassociateWorkflowSchedules', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ReassociateWorkflowSchedules',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn reassociateWorkflowSchedules -si @oldWorkflowName -si @newWorkflowName
'
)
GO

