

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_RePickJobsForContentIndexing.sp] ---------- 

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_RePickJobsForContentIndexing')
BEGIN
	print '>>> Drop Stored Procedure: QS_RePickJobsForContentIndexing <<<'
	drop procedure QS_RePickJobsForContentIndexing
END
IF EXISTS (select * from GxQscripts where name='QS_RePickJobsForContentIndexing')
	delete from GxQscripts where name = 'QS_RePickJobsForContentIndexing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_RePickJobsForContentIndexing')
	delete from GXDBVersions where aliasname = 'QS_RePickJobsForContentIndexing'
GO
print '... Creating Procedure: QS_RePickJobsForContentIndexing'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_RePickJobsForContentIndexing
--This script repicks only those jobs whose CI status is Success and skips others. Returns in output on what what jobs are affected and the number of rows updated in database.
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--  4 Corresponds to "high", same as same functionality in GUI.  Macro doesn't expand right for some reason
-- Qscript Usage.
  @JobIDList varchar(max) = '',
  @optType varchar(36) = 'REPICK'
AS
SET NOCOUNT ON
CREATE TABLE #FlatFileJobList
(
JobID INT
)
DECLARE @scriptName	varchar(64)
DECLARE @localMsg	varchar(max)
DECLARE @localErrorCode int
DECLARE @rowCount int
DECLARE @Authenticate		BIGINT = 0
DECLARE @ciStateFlags		INTEGER = 0
DECLARE @JOBSPicked VARCHAR(MAX)
DECLARE @CI_SUCCESS_FLAG INT
DECLARE @CI_PARTIAL_FLAG INT
DECLARE @CI_REQUIRED_FLAG INT
DECLARE @TArchFile TABLE
(
	ID INT,
	JobID INT,
	commcellId INT,
	cloudId int,
	appid int,
	flags int
)
DECLARE @BulkInsertSql varchar(max)
SELECT
@scriptName	= 'QS_RePickJobsForContentIndexing',
@localMsg	= @scriptName + ' Script completed successfully.',
@localErrorCode = 0,
@rowCount = 0
SET @CI_SUCCESS_FLAG = 64
SET @CI_PARTIAL_FLAG = 32
SET @CI_REQUIRED_FLAG = 16
BEGIN TRY
IF @optType IN ( 'REPICK', 'DELETE')
	SET @ciStateFlags = (@CI_SUCCESS_FLAG + @CI_PARTIAL_FLAG)
ELSE IF @optType = 'UNPICK'
	SET @ciStateFlags = (@CI_PARTIAL_FLAG + @CI_REQUIRED_FLAG)
IF ISNULL(@JobIDList, '') = 'ALL'
BEGIN
	INSERT INTO @TArchFile
	SELECT ID, JOBID, commCellId, cloudId, appId, flags
	FROM archFile with (nolock)
	WHERE Flags & @ciStateFlags  <> 0
END
ELSE IF ISNULL(@JobIDList, '') <> ''
BEGIN
	IF CHARINDEX('filePath=', @JobIDList) > 0
	BEGIN
		SET @JobIDList = REPLACE(@JobIDList, 'filePath=', '') -- filePath= is a prefix that indicates our script to read from given path. So we shall remove that from input string.
		SET @BulkInsertSql = 'BULK INSERT #FlatFileJobList FROM "' + @JobIDList + '" WITH(DATAFILETYPE=''char'',ROWTERMINATOR='','')'
		EXEC (@BulkInsertSql)
		INSERT INTO @TArchFile
		SELECT ID, JOBID, commCellId, cloudId, appId, flags
		FROM archFile with (nolock)
		WHERE Flags & @ciStateFlags <> 0
		AND jobId IN (SELECT JOBID FROM #FlatFileJobList)
	END
	ELSE
	BEGIN
		INSERT INTO @TArchFile
		SELECT ID, JOBID, commCellId, cloudId, appId, flags
		FROM archFile with (nolock)
		WHERE Flags & @ciStateFlags <> 0
		AND jobId IN (SELECT J._ID FROM dbo.SplitIDs(@JobIDList) J)
	END
END
ELSE
BEGIN
	SET @localMsg = 'Usage: JobID List must be equal to ALL or the list of Job IDs or just one job id as desired.'
END
IF EXISTS (SELECT TOP 1 * FROM @TArchFile)
BEGIN
	INSERT INTO archContentIndexingAged (archFileId, commCellId, cloudId, appId, pruneType, agedFlag, operationType, jobId)
SELECT  id, commCellId, cloudId, appId, 1 /*CVA_AGEDCI_PRUNETYPE_AFILE_ONLY*/, 0, 1, JobID
	FROM @TArchFile
	WHERE flags & (@CI_SUCCESS_FLAG + @CI_PARTIAL_FLAG) <> 0 AND flags & 256 /*CVA_AF_CI_EXPIRED_FLAG*/ = 0
	SELECT  @localErrorCode = @@ERROR
	IF @localErrorCode = 0
	BEGIN
		IF @optType = 'REPICK'
		BEGIN
			UPDATE archFile
			SET Flags = (Flags & ~@ciStateFlags) | @CI_REQUIRED_FLAG
			WHERE ID IN (SELECT ID FROM @TArchFile)
			SELECT  @localErrorCode = @@ERROR
			SET @rowCount = @@ROWCOUNT
			SELECT @JOBSPicked =  COALESCE( @JOBSPicked + ',', '') + CONVERT(VARCHAR(10),JOBID) FROM @TArchFile
			GROUP BY JOBID
			SET @localMsg = @localMsg + '. CI Jobs REPICKED: ' + @JOBSPicked
		END
		ELSE IF @optType IN ('DELETE', 'UNPICK')
		BEGIN
			UPDATE archFile
SET Flags  = (Flags & ~496)
			WHERE ID IN (SELECT ID FROM @TArchFile)
			SELECT  @localErrorCode = @@ERROR
			SET @rowCount = @@ROWCOUNT
			SELECT @JOBSPicked =  COALESCE( @JOBSPicked + ',', '') + CONVERT(VARCHAR(10),JOBID) FROM @TArchFile
			GROUP BY JOBID
			SET @localMsg = @localMsg + '. CI Jobs [' + @optType + '] '  + @JOBSPicked
		END
	END
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @localErrorCode = ERROR_NUMBER()
	SELECT @localMsg = @scriptName + ' Failed with error: ' + ERROR_MESSAGE()
END CATCH
IF @rowCount > 0 AND @localErrorCode <= 0
BEGIN
	SET @localMsg = @localMsg + '. Number of rows affected in database: ' + CONVERT(VARCHAR(10), @rowCount)
END
PROC_ERROR:
SELECT @localMsg
IF OBJECT_ID('tempdb..#FlatFileJobList') IS NOT NULL
DROP TABLE #FlatFileJobList
IF @localErrorCode > 0
BEGIN
	Raiserror(@localMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
END
GO

IF EXISTS (select * from GxQscripts where name = 'QS_RePickJobsForContentIndexing')
	delete from GxQscripts where name = 'QS_RePickJobsForContentIndexing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_RePickJobsForContentIndexing')
	delete from GXDBVersions where aliasname = 'QS_RePickJobsForContentIndexing'
GO

insert into GXDBVersions values(2, 'QS_RePickJobsForContentIndexing',  '00000000000000000000', 'QS_RePickJobsForContentIndexing', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_RePickJobsForContentIndexing',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		Mark ALL OR desired jobs as Re-Picked or delete for content indexing.'
 + CHAR(10) + '-- 		--'
 + CHAR(10) + '-- 		qoperation execscript -sn QS_RePickJobsForContentIndexing [-si ''JOBID1,JOBID2...|ALL|filePath=C:\JobList.csv''] [-si REPICK|DELETE|UNPICK]'
 + CHAR(10) + '-- 		JobIDList input must be either Comma separated list of Backup Job IDs to be marked as Picked OR ALL OR file path of a CSV file that contains list of jobs as comma seperated values with a prefix as filePath=. '
 + CHAR(10) + '-- 		WARNING: If all jobs need to be repicked for content indexing whose CI state is success, JobIDList parameter should be equal to ALL'
 + CHAR(10) + '-- 		Note: If any JOB ID provided is invalid it will skipped/ignored. Output returns what jobs are affected and number of rows updated in Database.'
 + CHAR(10) + '-- 		Note: If CSV file is used as input, filePath= prefix must be specified and without spaces in suffix or prefix'
 + CHAR(10) + '--       REPICK: mark specified cijob as repick'
 + CHAR(10) + '--       DELETE: mark specified cijob as delete'
 + CHAR(10) + '--       UNPICK: mark specified cijob as not picked'
)
GO

