

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_QueryDB2Backup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_QueryDB2Backup.sp,v $ $Id: QS_QueryDB2Backup.sp,v 1.8.2.5.46.1 2021/02/08 18:09:04 csharma Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='QS_QueryDB2Backup')
BEGIN
	print '>>> Drop Stored Procedure: QS_QueryDB2Backup <<<'
	drop procedure QS_QueryDB2Backup
END
IF EXISTS (select * from GxQscripts where name='QS_QueryDB2Backup')
	delete from GxQscripts where name = 'QS_QueryDB2Backup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_QueryDB2Backup')
	delete from GXDBVersions where aliasname = 'QS_QueryDB2Backup'
GO
print '... Creating Procedure: QS_QueryDB2Backup'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure QS_QueryDB2Backup
-- Qscript is Enabled
-- QScript secure this script does the user validation
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @client nvarchar(1024) = '',
  @instanceName nvarchar(1024) = '',
  @backupsetName nvarchar(1024) = '',
  @queryLog nvarchar(1024) = '',
  @fromTime nvarchar(256) = '',
  @toTime nvarchar(256) = '',
  @includeVersion nvarchar(32) = ''
AS
Set NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
     -------------------------------
      --select @client, @instancename , @homeDir, @version,@defSP,@logSP,@cmdSP,@user ,@pwd , @service , @useCat, @catUser, @catPwd , @catService , @hostuser , @ntpwd
      -------------------------------
      ----------------------Error Handling----------------------------------------------
      DECLARE @errorCode integer
      SET @errorCode = 0
      DECLARE @errorString nvarchar(1024)
      SET @errorString = ''
      DECLARE @noParameter nvarchar(4)
      SET @noParameter = '%%'
      SET @noParameter = @noParameter + 's'
     ----------------------const------------------------------
      DECLARE @scriptName nvarchar(128)
      SET @scriptName = 'QueryDB2Backup'
      DECLARE @nowTime integer
      SET @nowTime =  dbo.GetUnixTime (GetUTCdate())
      DECLARE @instanceId integer
      SET @instanceId = 0
      DECLARE @backupsetId integer
      SET @backupsetId = 0
      DECLARE @userId integer
      SET @userId = 0
DECLARE @browseCapMask bigint = POWER(2,13-1)
	  DECLARE @fromUnixTime integer
      SET @fromUnixTime = dbo.GetUnixTime('1970-01-01 00:00:00')
      DECLARE @toUnixTime integer
      SET @toUnixTime = @nowTime
     ---------------------parameter 1 - client name--------------------------------------------
     IF @client = @noParameter
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Client Name was not supplied as an input.'
     	GOTO ERROR_EXIT
     END
     DECLARE @clientId integer
     SET @clientId = ISNULL((SELECT Id FROM APP_client WHERE name = @client), 0)
     IF @clientId = 0
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Client ['+@client+'] not found.'
     	GOTO ERROR_EXIT
     END
     DECLARE @DB2Apptype varchar(128)
     SET @DB2Apptype = ISNULL ((SELECT apptypeId FROM APP_IdaName WHERE clientid = @clientId and apptypeId in (37, 62, 103)), 0)
	IF @DB2Apptype = 0
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Client ['+@client+'] does not have DB2 iDataAgent.'
     	GOTO ERROR_EXIT
     END
	 DECLARE @clTimeZone VARCHAR(256)
	 SET @clTimeZone = dbo.GetClientTimeZone(@clientId)
     -----------------------------instance name ----------------------------
     IF @instanceName = @noParameter
     BEGIN
     	SET @errorCode = 1
     	SET @errorString = 'Error. Instance Name was not supplied as an input.'
     	GOTO ERROR_EXIT
     END
     -----------------Validate other parameters---------------
     IF
    	@backupsetName = @noParameter
     	BEGIN
     		SET @errorCode = 1
    		SET @errorString = 'Error. The parameters supplied are not sufficient to create subclient. Please try again with all inputs.'
     		GOTO ERROR_EXIT
     END
     SET @instanceId =   ISNULL((SELECT distinct I.id
							from  APP_Application APP INNER JOIN  APP_InstanceName I
							ON APP.instance = I.id
							where APP.clientId = @clientId
							and APP.appTypeId = @DB2Apptype
							and I.name = @instanceName),0)
	IF (@instanceId = 0)
	BEGIN
     	SET @errorCode = 1
    	SET @errorString = 'Error. Instance ['+@instanceName+'] not found in client ['+@client+'] , apptype [' + @DB2Apptype + '].'
     	GOTO ERROR_EXIT
     END
     --get backupset id
    SET @backupsetId = ISNULL(( select distinct APP_BackupSetName.id
							from APP_BackupSetName, APP_Application, APP_Client, APP_InstanceName
							where APP_Application.clientId = APP_Client.id
							and APP_Application.appTypeId = @DB2Apptype
							and APP_Application.instance = APP_InstanceName.id
							and APP_BackupSetName.id = APP_Application.backupSet
							and APP_Client.name = @client
							and APP_InstanceName.name = @instanceName
							and APP_BackupSetName.name = @backupsetName), 0)
	IF (@backupsetId = 0)
	BEGIN
     	SET @errorCode = 1
    	SET @errorString = 'Error. Backupset ['+@backupsetName+'] not found in client ['+@client+'] , apptype [' + @DB2Apptype + '], instanceName [' +  @instanceName +'].'
     	GOTO ERROR_EXIT
     END
	SET @fromTime = RTRIM(LTRIM(@fromTime))
    SET @toTime = RTRIM(LTRIM(@toTime))
    IF @fromTime = N''
	BEGIN
	SET @fromTime = dbo.UTCToLocalTime('1970-01-01 00:00:00', @clTimeZone)
	END
	IF ISDATE(@fromTime) <> 1
	BEGIN
	SET @errorCode = 1
	SET @errorString = 'Invalid from time ['+@fromTime+']. Please provide valid time MM-DD-YYYY  hh:mm:ss'
	GOTO ERROR_EXIT
	END
    IF @toTime = N''
	BEGIN
	SET @toTime = dbo.UTCToLocalTime(GetUTCdate(), @clTimeZone)
	END
	IF ISDATE(@toTime) <> 1
	BEGIN
	SET @errorCode = 1
	SET @errorString = 'Invalid to time ['+@toTime+']. Please provide valid time MM-DD-YYYY  hh:mm:ss'
	GOTO ERROR_EXIT
	END
	DECLARE @timediff integer
	SET @timediff = dbo.GetUnixTime(@toTime) - dbo.GetUnixTime(@fromTime)
	IF @timediff < 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Invalid time range. FROM time ['+@fromTime+'] should be less than TO time ['+@toTime+'].'
		GOTO ERROR_EXIT
	END
	SET @fromUnixTime = dbo.GetUnixTime(dbo.LocalToUTCTime(@fromTime, @clTimeZone))
    SET @toUnixTime = dbo.GetUnixTime(dbo.LocalToUTCTime(@toTime, @clTimeZone))
	DECLARE @version INT = 0
	IF (@includeVersion = @noParameter OR @includeVersion = '' OR @includeVersion = 'N' OR @includeVersion = 'No')
		SET @version = 0
	ELSE
		SET @version = 1
     -- get quser id
     SET @userId =  ISNULL( (select userId from #tempQSUser),0)
     IF (@userId = 0)
     BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error, no logged in user found'
		GOTO ERROR_EXIT
     END
     --validate user for cabailities
     IF object_id('tempdb.dbo.#tempDB2UtilObjects') IS NOT NULL
		DROP TABLE #tempDB2UtilObjects
create table  #tempDB2UtilObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	 ---- 2012 is backupset item
     EXEC sec_getUserObjects @userId,2012,0,#tempDB2UtilObjects
     -- delete no browse capable objects from temp table
     DELETE FROM #tempDB2UtilObjects where capabilities&@browseCapMask=0
	 DECLARE @userAllowed integer
	 SET @userAllowed=0
     ---- check the user has access to the backupset by checking at different levels
	 IF EXISTS (SELECT * FROM #tempDB2UtilObjects WHERE
	 ----  comm cell level capability
	 ((commCellId=2 AND clientGroupId=0 AND clientId=0 AND appTypeId=0 AND instanceId=0 AND backupsetId=0 AND subClientId=0)
	 OR
	 ------ comm client group capability
	 (commCellId=2 AND clientGroupId in (select clientGroupId from APP_ClientGroupAssoc where clientId=@clientId) AND clientId=0 AND
	 appTypeId=0 AND instanceId=0 AND backupsetId=0 AND subClientId=0)
	 OR
	 ----  client level capability
	 (commCellId=2 AND clientId=@clientId AND appTypeId=0 AND instanceId=0 AND backupsetId=0 AND subClientId=0)
	 OR
	 ----  instance level capability
	 (commCellId=2 AND clientId=@clientId AND (appTypeId in (37,62,103)) AND instanceId=@instanceId AND backupsetId=0 AND subClientId=0)
	 OR
	 ----- backupset level capability
	 (commCellId=2 AND clientId=@clientId AND (appTypeId in (37,62,103) AND instanceId=@instanceId AND
	 backupsetId=@backupsetId AND subClientId=0))
	 AND mediaAgentId=0 AND libraryId=0 AND archGroupId=0 AND vtContainerId=0 AND vtPolicyId=0 AND vtShelfId=0 AND
	 reviewSetId=0 AND querySetId=0 AND downloadSetId=0 AND ermId=0 AND legalHoldId=0 AND tagId=0 AND cdPolicyId=0 AND
	 complianceReportId=0 AND taskId=0 AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0 AND cloudId=0 AND
	 userGroupId=0 AND providerId=0 AND entityId1=0 AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0
     AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0))
	 BEGIN
		SET @userAllowed=1
	 END
	IF ( @userAllowed = 0)
	BEGIN
    	SET @errorCode = 1
    	SET @errorString = 'User does not have browse/view capabilities on the given entity.'
     	GOTO ERROR_EXIT
	END
    --query logs
    IF (@queryLog = 'LOGS')
    BEGIN
		IF object_id('tempdb.dbo.#temparchGetDB2LogByLogNumber') IS NOT Null DROP TABLE #temparchGetDB2LogByLogNumber
create table #temparchGetDB2LogByLogNumber (  r_afileId integer, r_afileName varchar(2048), r_appId integer, r_createTime integer, r_backupLevel integer, r_agroupId integer,  r_copyId integer,
			r_firstLogTime integer,
			r_lastLogTime integer,
			r_firstLogNumber integer,
			r_lastLogNumber integer,
			r_commCellId integer)
		insert into #temparchGetDB2LogByLogNumber
		execute archGetDB2LogByLogNumber 2,@clientId,@instanceId,@backupsetId,'%%',0,0,-1
		select af.jobId as 'JOB ID',
			SUBSTRING(r_afileName, LEN(RTRIM(LTRIM(@instanceName))) + 3 + LEN(@backupsetName) , 8) as 'NODE NUMBER' ,
			SUBSTRING(r_afileName, LEN(RTRIM(LTRIM(@instanceName))) + 3 + LEN(@backupsetName) +9 , 8)as 'CHAIN NUMBER',
			Left(CAST(r_firstLogNumber as char(15)) + '.'  , 16) as 'FIRST LOG NUMBER',
			Left(CAST(r_lastLogNumber as char(14)) + '.'  , 15)as 'LAST LOG NUMBER',
			CONVERT(varchar(19),dbo.UTCToLocalDateTimeConversionManaged(DATEADD(second, r_firstLogTime, '01/01/1970'), @clTimeZone), 120) as '   FIRST LOG TIME   ',
			CONVERT(varchar(19),dbo.UTCToLocalDateTimeConversionManaged(DATEADD(second, r_lastLogTime, '01/01/1970'), @clTimeZone), 120) as '   LAST LOG TIME   '
  from #temparchGetDB2LogByLogNumber temp
			INNER JOIN archFile af on temp.r_afileId = af.id
		where
			(temp.r_firstLogTime <= @fromUnixTime AND temp.r_lastLogTime >=@fromUnixTime) OR
			(temp.r_firstLogTime <= @toUnixTime AND temp.r_lastLogTime >=@toUnixTime) OR
			(temp.r_firstLogTime >= @fromUnixTime AND temp.r_lastLogTime <=@toUnixTime)
		IF object_id('tempdb.dbo.#temparchGetDB2LogByLogNumber') IS NOT Null DROP TABLE #temparchGetDB2LogByLogNumber
    END
	ELSE IF (@queryLog = 'LOAD')
	BEGIN
	IF object_id('tempdb.dbo.#archFileForDB2LoadBackupset') IS NOT Null DROP TABLE #archFileForDB2LoadBackupset
		create table #archFileForDB2LoadBackupset (
		   r_afileId integer,
		   r_commCellId integer,
		   r_fileName char(2048),
		   r_creationTime integer,
		   r_backupLevel integer,
		   r_numStreams integer,
		   r_initFrom integer,
		   r_attributes bigint,
		   r_afcFlags integer,
		   r_copyPrec integer,
		   r_physicalSize bigint)
		insert into #archFileForDB2LoadBackupset
		execute archFileForDB2Backupset @clientId,@DB2Apptype,@instanceId,@backupsetId,0,-1,1
		update #archFileForDB2LoadBackupset set r_fileName=RTRIM(r_fileName)
		DELETE #archFileForDB2LoadBackupset
FROM	#archFileForDB2LoadBackupset A inner join archFile AF ON A.r_afileId = AF.id AND A.r_commCellId = AF.commCellId AND AF.fileType = 4
		CREATE TABLE #loadResultSet (
			jobId INT,
			backupLevel NVARCHAR(32),
			nodeNumber NVARCHAR(32),
			timeStamp NVARCHAR(64),
			streams	NVARCHAR(16),
			timeStampDT DATETIME,
			createTime INT
		)
		INSERT INTO #loadResultSet(jobId, backupLevel, timeStamp, streams, nodeNumber, createTime)
		SELECT af.jobId,   case  r_backupLevel when 1 then 'Full' when 2 then 'Load Copy' else 'Delta' end + SPACE(4) +'.' AS backupLevel,
			parsename(replace(
			SUBSTRING(
			   r_fileName,
				CHARINDEX('_', r_fileName) + 1,
				LEN(r_fileName) - CHARINDEX('_', r_fileName) - CHARINDEX('_', REVERSE(rtrim(r_fileName)))
			)
			, '_', '.'), 1) as timeStamp,
			 CONVERT(int, REVERSE(SUBSTRING(REVERSE(r_fileName),0,charindex('_',reverse(r_fileName))))) as streams,
			 SUBSTRING(r_fileName, LEN(RTRIM(LTRIM(@instanceName))) + 3 + LEN(@backupsetName) , 8) as NodeNumber,
			 r_creationTime as CreateTime
			 FROM #archFileForDB2LoadBackupset temp
			INNER JOIN archFile af on temp.r_afileId = af.id AND temp.r_commCellId = af.commCellId
			INNER JOIN JMBkpStats jbs on af.JobId = jbs.jobId AND af.commCellId = jbs.commCellId
			Where jbs.bkpAttributes & 0x8000000000000 > 0
		UPDATE	R
		SET		R.timeStampDT = SUBSTRING(R.timestamp,5,2) + '-' + SUBSTRING(R.timestamp,7,2) + '-' + SUBSTRING(R.timeStamp,1,4) + ' '
				+ SUBSTRING(R.timestamp,9,2) + ':' + SUBSTRING(R.timestamp,11,2) + ':' + SUBSTRING(R.timestamp,13,2)
		FROM	#loadResultSet R
		IF OBJECT_ID('IsInvalidTimeManaged') IS NOT NULL
		BEGIN
			UPDATE	R
			SET		R.timeStampDT = DATEADD(HOUR, 1, R.timeStampDT)
			FROM	#loadResultSet R
			WHERE	dbo.IsInvalidTimeManaged(R.timeStampDT, @clTimeZone) = 1
		END
		IF (@version = 0)
		BEGIN
			SELECT A.jobId as 'JOB ID', A.backupLevel as 'BACKUP TYPE', NodeNumber as 'NODE NUMBER',timeStamp as '  TIMESTAMP   ', max(streams) as STREAMS
			FROM #loadResultSet A
			WHERE	dbo.GetUnixTime(dbo.LocalToUTCTime(A.timeStampDT, @clTimeZone)) >= @fromUnixTime
				AND	dbo.GetUnixTime(dbo.LocalToUTCTime(A.timeStampDT, @clTimeZone)) <= @toUnixTime
			GROUP BY A.jobId,A.backupLevel,A.NodeNumber,A.timeStamp
		END
		ELSE
		BEGIN
			IF object_id('tempdb.dbo.#tempDb2VersionLoadTbl') IS NOT Null DROP TABLE #tempDb2VersionLoadTbl
			create table #tempDb2VersionLoadTbl (  instanceId integer, version nvarchar(MAX), created INT, modified INT)
			INSERT INTO #tempDb2VersionLoadTbl
			SELECT	componentNameId, attrVal, created, modified
			FROM	APP_InstanceProp
			WHERE	componentNameId = @instanceId
				AND attrName = 'DB2 Version'
			SELECT A.jobId as 'JOB ID', A.backupLevel as 'BACKUP TYPE', NodeNumber as 'NODE NUMBER',timeStamp as '  TIMESTAMP   ', max(streams) as STREAMS, MAX(V.version) as 'DB2 VERSION'
			FROM #loadResultSet A
				INNER JOIN #tempDb2VersionLoadTbl V
					ON V.instanceId = @instanceId
						AND V.created < A.createTime AND (V.modified = 0 OR V.modified >= A.createTime)
			WHERE	dbo.GetUnixTime(dbo.LocalToUTCTime(A.timeStampDT, @clTimeZone)) >= @fromUnixTime
				AND	dbo.GetUnixTime(dbo.LocalToUTCTime(A.timeStampDT, @clTimeZone)) <= @toUnixTime
			GROUP BY A.jobId,A.backupLevel,A.NodeNumber,A.timeStamp
		END
		DROP TABLE #archFileForDB2LoadBackupset
		DROP TABLE #loadResultSet
	END
    ELSE
    --query Data Backup
	BEGIN
		IF object_id('tempdb.dbo.#archFileForDB2Backupset') IS NOT Null DROP TABLE #archFileForDB2Backupset
		create table #archFileForDB2Backupset (
		   r_afileId integer,
		   r_commCellId integer,
		   r_fileName char(2048),
		   r_creationTime integer,
		   r_backupLevel integer,
		   r_numStreams integer,
		   r_initFrom integer,
		   r_attributes bigint,
		   r_afcFlags integer,
		   r_copyPrec integer,
		   r_physicalSize bigint)
		insert into #archFileForDB2Backupset
		execute archFileForDB2Backupset @clientId,@DB2Apptype,@instanceId,@backupsetId,0,-1,0
		update #archFileForDB2Backupset set r_fileName=RTRIM(r_fileName)
		DELETE #archFileForDB2Backupset
FROM	#archFileForDB2Backupset A inner join archFile AF ON A.r_afileId = AF.id AND A.r_commCellId = AF.commCellId AND AF.fileType = 4
		CREATE TABLE #resultSet (
			jobId INT,
			backupLevel NVARCHAR(32),
			nodeNumber NVARCHAR(32),
			timeStamp NVARCHAR(64),
			streams	NVARCHAR(16),
			timeStampDT DATETIME,
			createTime INT
		)
		INSERT INTO #resultSet(jobId, backupLevel, timeStamp, streams, nodeNumber, createTime)
		SELECT af.jobId,   case  r_backupLevel when 1 then 'Full' when 2 then 'Incr' else 'Delta' end + SPACE(4) +'.' AS backupLevel,
			parsename(replace(
			SUBSTRING(
			   r_fileName,
				CHARINDEX('_', r_fileName) + 1,
				LEN(r_fileName) - CHARINDEX('_', r_fileName) - CHARINDEX('_', REVERSE(rtrim(r_fileName)))
			)
			, '_', '.'), 1) as timeStamp,
			 CONVERT(int, REVERSE(SUBSTRING(REVERSE(r_fileName),0,charindex('_',reverse(r_fileName))))) as streams,
			 SUBSTRING(r_fileName, LEN(RTRIM(LTRIM(@instanceName))) + 3 + LEN(@backupsetName) , 8) as NodeNumber,
			 r_creationTime as CreateTime
			 FROM #archFileForDB2Backupset temp
			INNER JOIN archFile af on temp.r_afileId = af.id AND temp.r_commCellId = af.commCellId
		UPDATE	R
		SET		R.timeStampDT = SUBSTRING(R.timestamp,5,2) + '-' + SUBSTRING(R.timestamp,7,2) + '-' + SUBSTRING(R.timeStamp,1,4) + ' '
				+ SUBSTRING(R.timestamp,9,2) + ':' + SUBSTRING(R.timestamp,11,2) + ':' + SUBSTRING(R.timestamp,13,2)
		FROM	#resultSet R
		IF OBJECT_ID('IsInvalidTimeManaged') IS NOT NULL
		BEGIN
			UPDATE	R
			SET		R.timeStampDT = DATEADD(HOUR, 1, R.timeStampDT)
			FROM	#resultSet R
			WHERE	dbo.IsInvalidTimeManaged(R.timeStampDT, @clTimeZone) = 1
		END
		IF (@version = 0)
		BEGIN
			SELECT A.jobId as 'JOB ID', A.backupLevel as 'BACKUP TYPE', NodeNumber as 'NODE NUMBER',timeStamp as '  TIMESTAMP   ', max(streams) as STREAMS
			FROM #resultSet A
			WHERE	dbo.GetUnixTime(dbo.LocalToUTCTime(A.timeStampDT, @clTimeZone)) >= @fromUnixTime
				AND	dbo.GetUnixTime(dbo.LocalToUTCTime(A.timeStampDT, @clTimeZone)) <= @toUnixTime
			GROUP BY A.jobId,A.backupLevel,A.NodeNumber,A.timeStamp
		END
		ELSE
		BEGIN
			IF object_id('tempdb.dbo.#tempDb2VersionTbl') IS NOT Null DROP TABLE #tempDb2VersionTbl
			create table #tempDb2VersionTbl (  instanceId integer, version nvarchar(MAX), created INT, modified INT)
			INSERT INTO #tempDb2VersionTbl
			SELECT	componentNameId, attrVal, created, modified
			FROM	APP_InstanceProp
			WHERE	componentNameId = @instanceId
				AND attrName = 'DB2 Version'
			SELECT A.jobId as 'JOB ID', A.backupLevel as 'BACKUP TYPE', NodeNumber as 'NODE NUMBER',timeStamp as '  TIMESTAMP   ', max(streams) as STREAMS, MAX(V.version) as 'DB2 VERSION'
			FROM #resultSet A
				INNER JOIN #tempDb2VersionTbl V
					ON V.instanceId = @instanceId
						AND V.created < A.createTime AND (V.modified = 0 OR V.modified >= A.createTime)
			WHERE	dbo.GetUnixTime(dbo.LocalToUTCTime(A.timeStampDT, @clTimeZone)) >= @fromUnixTime
				AND	dbo.GetUnixTime(dbo.LocalToUTCTime(A.timeStampDT, @clTimeZone)) <= @toUnixTime
			GROUP BY A.jobId,A.backupLevel,A.NodeNumber,A.timeStamp
		END
		DROP TABLE #archFileForDB2Backupset
		DROP TABLE #resultSet
    END
     ERROR_EXIT:
    -- Print @scriptName + ' completed at '+ Convert(varchar(60), getdate())+'. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
    if @errorCode <> 0
     	Raiserror(@errorString,
     			    15,  --Severity (> 10 to force DOS Error Code = 1)
    				1	 --State
     				)
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_QueryDB2Backup')
	delete from GxQscripts where name = 'QS_QueryDB2Backup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_QueryDB2Backup')
	delete from GXDBVersions where aliasname = 'QS_QueryDB2Backup'
GO

insert into GXDBVersions values(2, 'QS_QueryDB2Backup',  'v1.8.2.5.46.1', 'QS_QueryDB2Backup', 'v1.8.2.5.46.1')
GO

insert into GxQscripts values(2+8,'QS_QueryDB2Backup',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_QueryDB2Backup.sql -si clientname -si instancename  -si backupsetname -si DATA | LOGS -si fromtime -si totime -si includeversion <YES | NO>
'
 + CHAR(10) + '-- 	script_name: QS_QueryDB2Backup.'
 + CHAR(10) + '-- 	Reports available Database and Log backups for the specified database(backupset) in Commvault catalog.'
 + CHAR(10) + '-- 	includeversion is an optional parameter. This is applicable only when the DATA option is used.'
)
GO

