

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_PruneJobsOnClientCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_PruneJobsOnClientCopy.sp,v $ $Id: QS_PruneJobsOnClientCopy.sp,v 1.1.2.2 2018/03/22 01:12:52 jiechen Exp $";
-- 	+-------------------------------------------------------------------+
--	|			Stored Procedure: "QS_PruneJobsOnClientCopy"			    				|
--	|-------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_PruneJobsOnClientCopy <<<'

IF EXISTS (select * from sysobjects where name='QS_PruneJobsOnClientCopy')
	drop procedure QS_PruneJobsOnClientCopy
IF EXISTS (select * from GxQscripts where name='QS_PruneJobsOnClientCopy')
	delete from GxQscripts where name = 'QS_PruneJobsOnClientCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_PruneJobsOnClientCopy')
	delete from GXDBVersions where aliasname = 'QS_PruneJobsOnClientCopy'
GO
print '... Creating Procedure: QS_PruneJobsOnClientCopy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_PruneJobsOnClientCopy
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_ClientName NVARCHAR(MAX),
  @i_SPName NVARCHAR(MAX),
  @i_CopyName NVARCHAR(MAX)
AS
SET NOCOUNT ON
DECLARE @retVal INTEGER = 0
DECLARE @ErrorNumber INTEGER = 0
DECLARE @ErrorMessage NVARCHAR(MAX) = ''
DECLARE	@clientId INTEGER = 0
DECLARE	@archGrpId INTEGER = 0
DECLARE	@archGrpCopyId INTEGER = 0
DECLARE @maxJobsToPruneInBatch 	INTEGER = 2000
DECLARE @jobsToPruneXML	XML
IF OBJECT_ID('tempdb.dbo.#tmpJobsOnClientCopy') is not null DROP TABLE #tmpJobsOnClientCopy
CREATE	TABLE #tmpJobsOnClientCopy (
	JobId						int,
	CommCellId			int,
	archGroupId			int,
	archCopyId			int,
	PRIMARY KEY (JobId, CommCellId, archCopyId)
)
IF OBJECT_ID('tempdb.dbo.#tmpJobsOnClientCopyToProcess') is not null DROP TABLE #tmpJobsOnClientCopyToProcess
CREATE	TABLE #tmpJobsOnClientCopyToProcess (
	JobId						int,
	CommCellId			int,
	archGroupId			int,
	archCopyId			int,
	PRIMARY KEY (JobId, CommCellId, archCopyId)
)
BEGIN TRY
	--Validate Client
	SELECT @clientId = id FROM App_Client WITH (NOLOCK) WHERE name = @i_ClientName
	IF @clientId = 0
	BEGIN
		SET @ErrorNumber = 1
		SET @ErrorMessage = N'Invalid Client Name.'
		GOTO SCRIPT_EXIT
	END
	--Validate Storage Policy
	SELECT @archGrpId = id FROM archGroup WITH (NOLOCK) WHERE name = @i_SPName
	IF @archGrpId = 0
	BEGIN
		SET @ErrorNumber = 2
		SET @ErrorMessage = N'Invalid Storage Policy Name.'
		GOTO SCRIPT_EXIT
	END
	--Validate Storage Policy Copy
	SELECT @archGrpCopyId = id FROM archGroupCopy WITH (NOLOCK) WHERE name = @i_CopyName AND archGroupId = @archGrpId
	IF @archGrpCopyId = 0
	BEGIN
		SET @ErrorNumber = 3
		SET @ErrorMessage = N'Invalid Storage Policy Copy Name.'
		GOTO SCRIPT_EXIT
	END
	SELECT @maxJobsToPruneInBatch = isnull(value, 2000)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_MAX_JOB_HISTORIES_TO_PRUNE_IN_BATCH'
	SET	@ErrorNumber = @@ERROR
	IF	@ErrorNumber != 0
	BEGIN
		SET @ErrorMessage = N'Failed to get jobs to prune in batch count.'
		GOTO SCRIPT_EXIT
	END
	-- Get jobs on given client\copy
	INSERT INTO #tmpJobsOnClientCopy
	SELECT DISTINCT JDS.JobId, JDS.CommCellId, JDS.archGrpId, JDS.archGrpCopyId
	FROM JMJobDataStats JDS WITH (NOLOCK), App_Application APP WITH (NOLOCK)
	WHERE JDS.appId = APP.id
	AND		APP.clientId = @clientId
	AND		JDS.archGrpCopyId = @archGrpCopyId
AND		JDS.disabled & 256 = 0
	SET	@ErrorNumber = @@ERROR
	IF	@ErrorNumber != 0
	BEGIN
		SET @ErrorMessage = N'Failed to get jobs on client\copy.'
		GOTO SCRIPT_EXIT
	END
	WHILE EXISTS (SELECT jobId FROM #tmpJobsOnClientCopy)
	BEGIN
		INSERT INTO #tmpJobsOnClientCopyToProcess
		SELECT TOP (@maxJobsToPruneInBatch) JobId, CommCellId, archGroupId, archCopyId
		FROM #tmpJobsOnClientCopy
		SET	@ErrorNumber = @@ERROR
		IF	@ErrorNumber != 0
		BEGIN
			SET @ErrorMessage = N'Failed to get jobs to process on client\copy.'
			GOTO SCRIPT_EXIT
		END
		SET @jobsToPruneXML = CAST(('<GalaxyOperations_PruneJobs>' +
																CAST ((SELECT jobId AS JobId, commCellId AS commCellId, 0 AS fileType, archGroupId AS archGrpId, archCopyId AS archGrpCopyId
																			FROM #tmpJobsOnClientCopyToProcess AS JobInfo
																			FOR XML AUTO) AS NVARCHAR(MAX)) +
																'</GalaxyOperations_PruneJobs>') AS XML)
		SET	@ErrorNumber = @@ERROR
		IF	@ErrorNumber != 0
		BEGIN
			SET @ErrorMessage = N'Failed to set job XML for pruning.'
			GOTO SCRIPT_EXIT
		END
		EXEC @retVal = deleteMultipleBackupByJobCopy 1, @jobsToPruneXML
		SET	@ErrorNumber = @@ERROR
		IF @ErrorNumber = 0
			SET @ErrorNumber = @retVal
		IF	@ErrorNumber != 0
		BEGIN
			SET @ErrorMessage = N'Failed to prune jobs.'
			GOTO SCRIPT_EXIT
		END
		DELETE #tmpJobsOnClientCopy
		FROM #tmpJobsOnClientCopy T1, #tmpJobsOnClientCopyToProcess T2
		WHERE T1.jobId = T2.jobId
		AND		T1.commcellId = T2.commCellId
		AND		T1.archCopyId = T2.archCopyId
		TRUNCATE TABLE #tmpJobsOnClientCopyToProcess
	END
	SET @ErrorMessage = N'Jobs pruned successfully for Client [' + @i_ClientName + '], Storage Policy [' + @i_SPName + '], Copy [' + @i_CopyName + '].'
	GOTO SCRIPT_EXIT
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT @ErrorNumber = ERROR_NUMBER(), @ErrorMessage = ERROR_MESSAGE();
END CATCH;
SCRIPT_EXIT:
	IF OBJECT_ID('tempdb.dbo.#tmpJobsOnClientCopy') is not null DROP TABLE #tmpJobsOnClientCopy
	IF OBJECT_ID('tempdb.dbo.#tmpJobsOnClientCopyToProcess') is not null DROP TABLE #tmpJobsOnClientCopyToProcess
	IF @ErrorNumber != 0
		RAISERROR(@ErrorMessage,
							15,  	-- Severity (> 10 to force DOS Error Code = 1)
							1	 		-- State
							)
	ELSE
		PRINT @ErrorMessage
GO

IF EXISTS (select * from GxQscripts where name = 'QS_PruneJobsOnClientCopy')
	delete from GxQscripts where name = 'QS_PruneJobsOnClientCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_PruneJobsOnClientCopy')
	delete from GXDBVersions where aliasname = 'QS_PruneJobsOnClientCopy'
GO

insert into GXDBVersions values(2, 'QS_PruneJobsOnClientCopy',  '00010001000200020000', 'QS_PruneJobsOnClientCopy', '00010001000200020000')
GO

insert into GxQscripts values(2,'QS_PruneJobsOnClientCopy',  1, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_PruneJobsOnClientCopy -si @i_ClientName = ''ClientName'' -si @i_SPName = ''SPName'' -si @i_CopyName = ''CopyName''
'
 + CHAR(10) + '-- 	script_name: QS_PruneJobsOnClientCopy'
 + CHAR(10) + '-- 	Prune all jobs of given client on given copy.'
)
GO

