

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_PruneDanglingJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_PruneDanglingJobs.sp,v $ $Id: QS_PruneDanglingJobs.sp,v 1.1.2.2 2019/06/24 23:31:05 hkapadia Exp $";
-- 	+-------------------------------------------------------------------+
--	|			Stored Procedure: "QS_PruneDanglingJobs"			    				|
--	|-------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_PruneDanglingJobs')
BEGIN
	print '>>> Drop Stored Procedure: QS_PruneDanglingJobs <<<'
	drop procedure QS_PruneDanglingJobs
END
IF EXISTS (select * from GxQscripts where name='QS_PruneDanglingJobs')
	delete from GxQscripts where name = 'QS_PruneDanglingJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_PruneDanglingJobs')
	delete from GXDBVersions where aliasname = 'QS_PruneDanglingJobs'
GO
print '... Creating Procedure: QS_PruneDanglingJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_PruneDanglingJobs
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_opType NVARCHAR(20)
AS
SET NOCOUNT ON
-- Any dangling jobs created before 7 days can be deleted
DECLARE  @archFileCTime INTEGER
SELECT  @archFileCTime = (dbo.GetUnixTime(GETUTCDATE()) - 7 * 24 * 60 * 60)
DECLARE @currentTime INTEGER
SET		@currentTime = dbo.GetUnixTime(GETUTCDATE())
DECLARE @retVal INTEGER
SET		@retVal = 0
DECLARE @ErrorNumber INTEGER
SET			@ErrorNumber = 0
DECLARE @ErrorMessage NVARCHAR(MAX)
SET			@ErrorMessage = ''
IF object_id('tempdb.dbo.#ToBeAgedJob') IS NOT null DROP TABLE #ToBeAgedJob
CREATE TABLE #ToBeAgedJob (
	jobId					INT,
	archGrpId			INT,
	archGrpCopyId	INT,
	dataType			INT,
	commCellId		INT,
	appId					INT,
	PRIMARY KEY (jobId, archGrpCopyId, dataType, commCellId)
)
BEGIN TRY
	--Validate opType
	IF UPPER(@i_opType) NOT IN ('VIEW', 'PRUNE')
	BEGIN
		SET @ErrorMessage = N'Invalid Operation Type.'
		RAISERROR(@ErrorMessage, 15, 1)
	END
	-- Get all jobs that does not exist in the JMJobDataStats table
	INSERT INTO #ToBeAgedJob
	SELECT AF.JobId, AF.archGroupId, AFC.archCopyId, AF.fileType, AF.commCellId, AF.appId
	from archFile AF WITH (NOLOCK) INNER JOIN archFileCopy AFC WITH (NOLOCK)
	ON AF.id = AFC.archFileId
	AND AF.commCellId = AFC.commCellId
	LEFT OUTER JOIN JMJobDataStats JDS WITH (NOLOCK)
	ON AF.jobId = JDS.jobId
	AND	AF.commcellid = JDS.commcellid
	AND	AFC.archCopyId = JDS.archGrpCopyId
	AND	AF.fileType = JDS.dataType
	WHERE JDS.jobId IS NULL
	AND	  AFC.flags & 256 = 0
	GROUP BY AF.JobId, AF.archGroupId, AFC.archCopyId, AF.fileType, AF.commCellId, AF.appId
	HAVING MAX(AF.cTime) < @archFileCTime
	IF	@@ERROR != 0
	BEGIN
		SET @ErrorMessage = N'Failed to lookup dangling jobs.'
		RAISERROR(@ErrorMessage, 15, 1)
	END
	-- Exclude transitive copy entries
	DELETE #ToBeAgedJob
	FROM #ToBeAgedJob T, archGroupCopy AGC WITH (NOLOCK)
	WHERE T.archGrpCopyId = AGC.id
AND		AGC.type = 5
	IF	@@ERROR != 0
	BEGIN
		SET @ErrorMessage = N'Failed to exclude jobs on transitive copy.'
		RAISERROR(@ErrorMessage, 15, 1)
	END
	-- Do not delete any running jobs
	DELETE #ToBeAgedJob
	FROM #ToBeAgedJob T, JMJobInfo JI WITH (NOLOCK)
	WHERE T.jobId = JI.jobId
	AND T.commCellId = JI.commCellId
	IF	@@ERROR != 0
	BEGIN
		SET @ErrorMessage = N'Failed to check for running jobs.'
		RAISERROR(@ErrorMessage, 15, 1)
	END
	-- Race condition in case if job just completed after inserting into temp table
	DELETE #ToBeAgedJob
	FROM #ToBeAgedJob T, JMJobDataStats JDS
	WHERE T.jobId = JDS.jobId
	AND	  T.commcellid = JDS.commcellid
	AND	  T.archGrpCopyId = JDS.archGrpCopyId
	AND	  T.dataType = JDS.dataType
	AND	  JDS.disabled & 256 = 0
	IF	@@ERROR != 0
	BEGIN
		SET @ErrorMessage = N'Failed to check for valid jobs.'
		RAISERROR(@ErrorMessage, 15, 1)
	END
	IF UPPER(@i_opType) = 'VIEW'
	BEGIN
		SELECT 	jobId, commCellId, archGrpId, archGrpCopyId, dataType
		FROM #ToBeAgedJob
	END
	ELSE
	BEGIN
		IF EXISTS (SELECT jobId FROM #ToBeAgedJob)
		BEGIN
			BEGIN TRAN
			EXEC @retVal = archSetJobsAgedViaTable 262144, @currentTime --CVA_AGED_BY_UTILITY
			IF	@@ERROR != 0
			BEGIN
				SET @ErrorMessage = N'Failed to delete the dangling jobs.'
				RAISERROR(@ErrorMessage, 15, 1)
			END
			ELSE
			BEGIN
				SET	@ErrorNumber = @retVal
				IF @ErrorNumber != 0
				BEGIN
					SET @ErrorMessage = N'Failed to delete the dangling jobs.'
					RAISERROR(@ErrorMessage, 15, 1)
				END
				ELSE
				BEGIN
					SET @ErrorMessage = N'Successfully deleted the dangling jobs.'
					COMMIT TRAN
				END
			END
		END
		ELSE
		BEGIN
			SET @ErrorMessage = N'No jobs to delete.'
		END
	END
	PRINT @ErrorMessage
	IF object_id('tempdb.dbo.#ToBeAgedJob') IS NOT null DROP TABLE #ToBeAgedJob
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT @ErrorNumber = ERROR_NUMBER(), @ErrorMessage = ERROR_MESSAGE();
	PRINT @ErrorMessage
	IF object_id('tempdb.dbo.#ToBeAgedJob') IS NOT null DROP TABLE #ToBeAgedJob
  IF @@TRANCOUNT > 0
      ROLLBACK TRAN
END CATCH;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_PruneDanglingJobs')
	delete from GxQscripts where name = 'QS_PruneDanglingJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_PruneDanglingJobs')
	delete from GXDBVersions where aliasname = 'QS_PruneDanglingJobs'
GO

insert into GXDBVersions values(2, 'QS_PruneDanglingJobs',  '00010001000200020000', 'QS_PruneDanglingJobs', '00010001000200020000')
GO

insert into GxQscripts values(2,'QS_PruneDanglingJobs',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_PruneDanglingJobs -si [VIEW|PRUNE]
'
 + CHAR(10) + '-- 	script_name: QS_PruneDanglingJobs'
 + CHAR(10) + '-- 	Prune all dangling archive files without job info'
)
GO

