

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_PruneContentDirectorPolicies.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_PruneContentDirectorPolicies.sp,v $ $Id: QS_PruneContentDirectorPolicies.sp,v 1.2.76.3 2018/03/27 09:16:59 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_PruneContentDirectorPolicies <<<'

IF EXISTS (select * from sysobjects where name='QS_PruneContentDirectorPolicies')
	drop procedure QS_PruneContentDirectorPolicies
IF EXISTS (select * from GxQscripts where name='QS_PruneContentDirectorPolicies')
	delete from GxQscripts where name = 'QS_PruneContentDirectorPolicies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_PruneContentDirectorPolicies')
	delete from GXDBVersions where aliasname = 'QS_PruneContentDirectorPolicies'
GO
print '... Creating Procedure: QS_PruneContentDirectorPolicies'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_PruneContentDirectorPolicies
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @username NVARCHAR(256),
  @deleteAll varchar(10) = 'false',
  @cdrNames nvarchar(max) = ''
AS
Set NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @localErrorMsg	varchar(512)
	SET		@localErrorMsg	='Error Encountered when running script.'
	DECLARE @NoParameter			varchar(10)
	SET     @NoParameter			=''
	--check for user
	IF( ISNULL(@username,'') = @NoParameter Or NOT EXISTS (SELECT 1 FROM UMUsers (NOLOCK) WHERE login = @username))
	BEGIN
		SET @localErrorMsg = 'Error:  Invalid Username. Input username ['+ ISNULL(@username,'EMPTY') + '] doesnt exists.'
		GOTO CV_EXIT
	END
	IF(@deleteAll = @NoParameter ANd @cdrNames = @NoParameter)
	BEGIN
		SET @localErrorMsg = 'Error:  Insufficient input.'
		GOTO CV_EXIT
	END
	IF(@deleteAll <> 'TRUE' AND ISNULL(@cdrNames,'') = @NoParameter)
	BEGIN
		SET @localErrorMsg = 'Error: No Content direcor names are provided.'
		GOTO CV_EXIT
	END
	--now get the userid to be passed
	DECLARE @l_userId INT
	SELECT @l_userId = id FROM UMUsers WITH (NOLOCK) WHERE login = @username
	--check if any valid entries exists.
	DECLARE @tempTable table (complianceId Int, policyName nvarchar(1024))
	INSERT INTO @tempTable
	SELECT S.complianceId, S.policyName FROM SchedAdminComplianceXMLOptions AS S WHERE status <> 1 AND (@deleteAll = 'true'
			OR  policyName IN ( SELECT _ID FROM dbo.SplitIDString(@cdrNames)))
	IF EXISTS( SELECT TOP 1 * FROM @tempTable )
	BEGIN
		/*
		--populate xml to be passed for delete
		<DM2ContentIndexing_CompliancePoliciesDeleteReq>
		  <policies complianceId="3105" />
		  <policies complianceId="3107" />
		  <policies complianceId="3108" />
		</DM2ContentIndexing_CompliancePoliciesDeleteReq>
		*/
		DECLARE @xml NVARCHAR(MAX)
		SELECT @xml = (select complianceId '@complianceId' from @tempTable
						for xml path('policies'),
						root('DM2ContentIndexing_CompliancePoliciesDeleteReq'))
		--invoke delete SP, output will be printed..
		exec [SchedDeleteComplianceDirectorList] @l_userId,0, @xml
		SET @localErrorMsg = 'Operation completed.'
	END
	ELSE
	BEGIN
		SET @localErrorMsg = 'Error: No valid Content director policy exists to be deleted.'
		GOTO CV_EXIT
	END
CV_EXIT:
	SELECT @localErrorMsg
GO

IF EXISTS (select * from GxQscripts where name = 'QS_PruneContentDirectorPolicies')
	delete from GxQscripts where name = 'QS_PruneContentDirectorPolicies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_PruneContentDirectorPolicies')
	delete from GXDBVersions where aliasname = 'QS_PruneContentDirectorPolicies'
GO

insert into GXDBVersions values(2, 'QS_PruneContentDirectorPolicies',  '00010002007600030000', 'QS_PruneContentDirectorPolicies', '00010002007600030000')
GO

insert into GxQscripts values(2,'QS_PruneContentDirectorPolicies',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	To delete content director policy that are created. Option to delete all the entries or can explicitly specify names'
 + CHAR(10) + '
'
 + CHAR(10) + '	qoperation execscript -sn PruneContentDirectorPolicies -si @username=''username'' -si @deleteAll=''deleteFlag'' -si @cdrNames=''cdrNames''
'
 + CHAR(10) + '-- 	''username'' -- login name of the user who have admin permission to delete'
 + CHAR(10) + '-- 	''deleteFlag'' -- TRUE or FALSE Flag to specify if this script needs to delete all content director policy. TRUE to delete all the entries'
 + CHAR(10) + '-- 	''cdrNames'' -- If deleteFlag is set FALSE, we can provide comma(,) separated list of the names. When deleteFlag flag is TRUE, this param can be skipped'
)
GO

