

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ProtectedClientsPerPolicySummary.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ProtectedClientsPerPolicySummary <<<'

IF EXISTS (select * from sysobjects where name='QS_ProtectedClientsPerPolicySummary')
	drop procedure QS_ProtectedClientsPerPolicySummary
IF EXISTS (select * from GxQscripts where name='QS_ProtectedClientsPerPolicySummary')
	delete from GxQscripts where name = 'QS_ProtectedClientsPerPolicySummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ProtectedClientsPerPolicySummary')
	delete from GXDBVersions where aliasname = 'QS_ProtectedClientsPerPolicySummary'
GO
print '... Creating Procedure: QS_ProtectedClientsPerPolicySummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_ProtectedClientsPerPolicySummary
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @LastDays INTEGER = 7,
  @CountAgedJobs INTEGER= 0
AS
SET NOCOUNT ON
DECLARE	@TimeRangeBegin	INT = dbo.GetUnixTime(DATEADD(DAY, -@LastDays, GETUTCDATE()))
SELECT	T.CommCell, T.Policy, T.ProtectedClients, T.SizeOnMediaGB,
		CAST (T.SizeOnMediaGB/T.ProtectedClients AS DECIMAL(20,2)) AS SizePerClientGB
FROM	(SELECT CommCell, Policy, COUNT(Client) AS ProtectedClients, SUM(SizeOnMediaGB) AS SizeOnMediaGB
		FROM dbo.ProtectedClientsPerPolicy(@TimeRangeBegin, 0, @CountAgedJobs)
		GROUP BY CommCell, Policy) T
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ProtectedClientsPerPolicySummary')
	delete from GxQscripts where name = 'QS_ProtectedClientsPerPolicySummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ProtectedClientsPerPolicySummary')
	delete from GXDBVersions where aliasname = 'QS_ProtectedClientsPerPolicySummary'
GO

insert into GXDBVersions values(2, 'QS_ProtectedClientsPerPolicySummary',  '00000000000000000000', 'QS_ProtectedClientsPerPolicySummary', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ProtectedClientsPerPolicySummary',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	qoperation execscript -sn QS_ProtectedClientsPerPolicySummary [-si @LastDays = ''1''] [-si @CountAgedJobs = ''1'']'
 + CHAR(10) + '-- 	Default: LastDays = 7, CountAgedJobs = 0'
)
GO

