

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_PromoteToFullById.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_PromoteToFullById <<<'

IF EXISTS (select * from sysobjects where name='QS_PromoteToFullById')
	drop procedure QS_PromoteToFullById
IF EXISTS (select * from GxQscripts where name='QS_PromoteToFullById')
	delete from GxQscripts where name = 'QS_PromoteToFullById'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_PromoteToFullById')
	delete from GXDBVersions where aliasname = 'QS_PromoteToFullById'
GO
print '... Creating Procedure: QS_PromoteToFullById'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_PromoteToFullById
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @AppIdString varchar(1024) = '%s'
AS
SET QUOTED_IDENTIFIER ON
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @AppIdString	varchar(1024)
--SET		@AppIdString = '%s'
---------------------------------------
--test
--SET		@AppIdString = '10'
---------------------------------------
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'PromoteToFullById'
DECLARE @NoParameter varchar(4)
SET     @NoParameter  ='%'                        -- Get Around QScript Parameter
SET     @NoParameter  =@NoParameter + 's'         -- .. Substitution
DECLARE @nowTime	integer
SET     @nowTime	= dbo.GetUnixTime (GetUTCdate())
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
------------Validata subclient id -----------
IF @AppIdString = @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. No input was given. Please give the subclientId  as input'
	GOTO ARGS_ERROR
END
DECLARE @subclientId integer
SET @subclientId = convert(integer, @AppIdString)
IF (SELECT count(*) from APP_application where id = @subclientId) = 0
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Subclient with id [' +@AppIdString +'] not found.'
	GOTO ARGS_ERROR
END
DECLARE @subclientFlag integer
SET @subclientFlag = (SELECT subclientStatus from APP_Application where id = @subclientId)
IF ((@subclientFlag & 2 = 2) OR  (@subclientFlag & 4 = 4))
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Subclient with id [' +@AppIdString +'] is deleted or uninstalled.'
	GOTO ARGS_ERROR
END
------ To Reset backupset modified time in the end  --------
DECLARE @backupsetId integer
SELECT @backupsetId = backupset FROM App_application where id = @subclientId
------------ change the properties...  -----------
BEGIN TRAN
		IF((select count (*) from App_subclientprop	where attrname like 'sys:last full' and componentnameid = @SubclientId) > 0)
			DELETE FROM App_subclientprop
				where attrname like 'sys:last full' and componentnameid = @SubclientId
		SET @lastError = @@error
		IF @lastError <> 0
		BEGIN
			SET @localErrorMsg = 'Error. Could not promote next backup job to full.'
			GOTO TRANS_EXIT
		END
		IF((select count (*) from App_subclientprop	where attrname like 'sys:last incr' and componentnameid = @SubclientId) > 0)
			DELETE FROM App_subclientprop
				where attrname like 'sys:last incr' and componentnameid = @SubclientId
		SET @lastError = @@error
		IF @lastError <> 0
		BEGIN
			SET @localErrorMsg = 'Error. Could not promote next backup job to full.'
			GOTO TRANS_EXIT
		END
		UPDATE App_subclientprop SET modified = @nowTime
		where attrname like 'Reason last backup time cleared' and componentnameid = @SubclientId
		SET @lastError = @@error
		IF @lastError <> 0
		BEGIN
			SET @localErrorMsg = 'Error. Could not promote next backup job to full.'
			GOTO TRANS_EXIT
		END
		Insert into App_subclientprop (componentnameid, attrname, attrval, attrtype, created, modified)
		Values (@SubclientId, 'Reason last backup time cleared', 18, 7, @nowTime, 0)
		--CV_CLEAR_STORAGEPOLICY_ASSOCIATION_CHANGED 1, PROPERTY_INTEGER  7, 	CV_CLEAR_USER_REQUEST_USING_QSCRIPT 17
		SET @lastError = @@error
		IF @lastError <> 0
		BEGIN
			SET @localErrorMsg = 'Error. Could not promote next backup job to full.'
			GOTO TRANS_EXIT
		END
		-- Reset backupset modified time
		UPDATE APP_backupsetName set modified = @nowTime where id = @BackupsetId
TRANS_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
ARGS_ERROR:
PRINT ''
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@AppIdString+
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_PromoteToFullById')
	delete from GxQscripts where name = 'QS_PromoteToFullById'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_PromoteToFullById')
	delete from GXDBVersions where aliasname = 'QS_PromoteToFullById'
GO

insert into GXDBVersions values(2, 'QS_PromoteToFullById',  '00000000000000000000', 'QS_PromoteToFullById', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_PromoteToFullById',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn PromoteToFullById -si subclientId
'
 + CHAR(10) + '--   script_name : PromoteToFullById'
)
GO

