

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_PinAgingJobsByTimeRange.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_PinAgingJobsByTimeRange <<<'

IF EXISTS (select * from sysobjects where name='QS_PinAgingJobsByTimeRange')
	drop procedure QS_PinAgingJobsByTimeRange
IF EXISTS (select * from GxQscripts where name='QS_PinAgingJobsByTimeRange')
	delete from GxQscripts where name = 'QS_PinAgingJobsByTimeRange'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_PinAgingJobsByTimeRange')
	delete from GXDBVersions where aliasname = 'QS_PinAgingJobsByTimeRange'
GO
print '... Creating Procedure: QS_PinAgingJobsByTimeRange'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_PinAgingJobsByTimeRange
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_startDate VARCHAR(32) ,
  @i_endDate VARCHAR(32) ,
  @i_pinTime VARCHAR(32) ,
  @clientName VARCHAR(32) = 'Not Applicable',
  @storagePolicyName VARCHAR(32) = 'Not Applicable',
  @storagePolicyCopyName VARCHAR(32) = 'Not Applicable'
AS
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#tempJobsToProcessForRetention') IS NOT NULL	DROP TABLE #tempJobsToProcessForRetention
CREATE TABLE #tempJobsToProcessForRetention (jobId INT, commCellID INT, archGrpCopyId INT, appId INT, retentionEndTime BIGINT)
IF OBJECT_ID('tempdb.dbo.#tblResultDaCalculateRetentionTimeForJobs') IS NOT NULL 	DROP TABLE #tblResultDaCalculateRetentionTimeForJobs
CREATE TABLE #tblResultDaCalculateRetentionTimeForJobs (retVal int)
IF OBJECT_ID('tempdb.dbo.#tblResultArchPinJobsOnCopy') IS NOT NULL 	DROP TABLE #tblResultArchPinJobsOnCopy
CREATE TABLE #tblResultArchPinJobsOnCopy (errorCode int)
DECLARE	@startUnixTime		BIGINT
DECLARE	@endUnixTime		BIGINT
DECLARE	@pinUnixTime		BIGINT
DECLARE	@retVal				INT = 0
DECLARE @errorString		NVARCHAR(1024)
DECLARE @tempXMLVariableForPinJobs XML
DECLARE	@jobIdList			NVARCHAR(MAX)
SET @errorString = ''
DECLARE @opMsgId        INT = 0
DECLARE @opEvMsgId      INT = 0
DECLARE @opId           INT = 0
DECLARE @paramMsgId     INT = 0
DECLARE @GUIAuditUserId INT = 1    -- we do not have any way to determine user id.
DECLARE @startDate		DATETIME
DECLARE @endDate 		DATETIME
DECLARE @pinTime 		DATETIME
DECLARE @clientId				INT = 0
DECLARE	@storagePolicyId		INT = 0
DECLARE	@storagePolicyCopyId	INT = 0
DECLARE @currentTime			BIGINT = dbo.getUnixTime(GETUTCDATE())
SET @startDate 	= CONVERT (DATETIME, @i_startDate,101)
SET @retVal = @@ERROR
IF  @retVal <> 0
BEGIN
	SET @errorString = 'Error when converting start date.'
	GOTO CX_EXIT
END
SET @endDate  	= CONVERT (DATETIME, @i_endDate,101)
SET @retVal = @@ERROR
IF  @retVal <> 0
BEGIN
	SET @errorString = 'Error when converting end date.'
	GOTO CX_EXIT
END
SET @pinTime  	= CONVERT (DATETIME, @i_pinTime,101)
SET @retVal = @@ERROR
IF  @retVal <> 0
BEGIN
	SET @errorString = 'Error when converting pin date.'
	GOTO CX_EXIT
END
IF NOT EXISTS(
			SELECT	name
			FROM	APP_Client WITH (NOLOCK)
			WHERE	name = @clientName
) AND @clientName <> 'Not Applicable'
BEGIN
	SET @retVal = 2
	SET @errorString = 'Invalid Client Name.'
	GOTO CX_EXIT
END
ELSE IF @clientName <> 'Not Applicable'
BEGIN
	SELECT	@clientId = id
	FROM	App_Client WITH (NOLOCK)
	WHERE	name = @clientName
END
IF @storagePolicyName = 'Not Applicable' AND @storagePolicyCopyName <> 'Not Applicable'
BEGIN
	SET @retVal = 2
	SET @errorString = 'Invalid Input. Provide storage policy name along with copy name.'
	GOTO CX_EXIT
END
IF NOT EXISTS(
			SELECT	name
			FROM	archGroup WITH (NOLOCK)
			WHERE	name = @storagePolicyName
) AND @storagePolicyName <> 'Not Applicable'
BEGIN
	SET @retVal = 2
	SET @errorString = 'Invalid Storage Policy Name.'
	GOTO CX_EXIT
END
ELSE IF @storagePolicyName <> 'Not Applicable'
BEGIN
	SELECT	@storagePolicyId = id
	FROM	archGroup WITH (NOLOCK)
	WHERE	name = @storagePolicyName
END
IF NOT EXISTS(
			SELECT	AGC.name
			FROM	archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
			WHERE	AG.id = AGC.archGroupId
				AND	AG.name = @storagePolicyName AND AGC.name = @storagePolicyCopyName
) AND @storagePolicyName <> 'Not Applicable' AND @storagePolicyCopyName <> 'Not Applicable'
BEGIN
	SET @retVal = 2
	SET @errorString = 'Invalid Storage Policy Copy Name.'
	GOTO CX_EXIT
END
ELSE IF @storagePolicyName <> 'Not Applicable' AND @storagePolicyCopyName <> 'Not Applicable'
BEGIN
	SELECT	@storagePolicyId = AG.id , @storagePolicyCopyId = AGC.id
	FROM	archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
	WHERE	AG.id = AGC.archGroupId
		AND	AG.name = @storagePolicyName AND AGC.name = @storagePolicyCopyName
END
SET	@startUnixTime = dbo.GetUnixTimeBig(dbo.LocalToUTCTime(@startDate,dbo.GetClientTimeZone(2)))
SET @retVal = @@ERROR
IF  @retVal <> 0
BEGIN
	SET @errorString = 'Error when setting startUnixTime.'
	GOTO CX_EXIT
END
SET	@endDate 	=	DATEADD(DAY, DATEDIFF(DAY, 0, @endDate), '23:59:59')
SET	@endUnixTime = dbo.GetUnixTimeBig(dbo.LocalToUTCTime(@endDate,dbo.GetClientTimeZone(2)))
SET @retVal = @@ERROR
IF  @retVal <> 0
BEGIN
	SET @errorString = 'Error when setting endUnixTime.'
	GOTO CX_EXIT
END
SET	@pinUnixTime = dbo.GetUnixTimeBig(dbo.LocalToUTCTime(@pinTime,dbo.GetClientTimeZone(2)))
SET @retVal = @@ERROR
IF  @retVal <> 0
BEGIN
	SET @errorString = 'Error when setting pinUnixTime.'
	GOTO CX_EXIT
END
IF @startUnixTime > @endUnixTime
BEGIN
	SET @errorString = 'Start time should be greater than end time.'
	SET	@retVal = 1
	GOTO CX_EXIT
END
IF @pinUnixTime < @endUnixTime
BEGIN
	SET @errorString = 'Pin time should be greater than start and end time.'
	SET	@retVal = 1
	GOTO CX_EXIT
END
IF @pinUnixTime < @currentTime
BEGIN
	SET @errorString = 'Pin time should be greater than the current time.'
	SET	@retVal = 1
	GOTO CX_EXIT
END
IF @clientId <> 0
BEGIN
	INSERT INTO #tempJobsToProcessForRetention
	SELECT	DISTINCT JDS.jobId,JDS.commCellId,JDS.archGrpCopyId,JDS.appId,0
	FROM	JMJobDataStats JDS WITH (NOLOCK), JMBkpStats JBS WITH (NOLOCK), APP_Application AAP WITH (NOLOCK)
	WHERE	JDS.jobId = JBS.jobId AND JDS.commCellId = JBS.commCellId
		AND JDS.status IN (100,102,103)
AND JDS.disabled & 256 = 0
		AND	AAP.id = JDS.appId
		AND	(@storagePolicyCopyId = JDS.archGrpCopyId OR @storagePolicyCopyId = 0)
		AND	(@storagePolicyId = JDS.archGrpId OR @storagePolicyId = 0)
		AND	@clientId = AAP.clientId
	SET @retVal = @@ERROR
	IF  @retVal <> 0 GOTO CX_EXIT
	-- Insert admin jobs.
	INSERT INTO #tempJobsToProcessForRetention
	SELECT	DISTINCT JDS.jobId,JDS.commCellId,JDS.archGrpCopyId,JDS.appId,0
	FROM	JMJobDataStats JDS WITH (NOLOCK), JMAdminJobStatsTable JBS WITH (NOLOCK), APP_Application AAP WITH (NOLOCK)
	WHERE	JDS.jobId = JBS.jobId AND JDS.commCellId = JBS.commCellId
		AND JDS.status IN (100,102,103)
AND JDS.disabled & 256 = 0
		AND	AAP.id = JDS.appId
		AND	(@storagePolicyCopyId = JDS.archGrpCopyId OR @storagePolicyCopyId = 0)
		AND	(@storagePolicyId = JDS.archGrpId OR @storagePolicyId = 0)
		AND	@clientId = AAP.clientId
	SET @retVal = @@ERROR
	IF  @retVal <> 0 GOTO CX_EXIT
END
EXEC @retVal = daCalculateRetentionTimeForJobs  @storagePolicyCopyId,@storagePolicyId , 0
IF  @retVal <> 0
BEGIN
	SET @errorString = 'Error when executing daCalculateRetentionTimeForJobs stored procedure.'
	GOTO CX_EXIT
END
DELETE	FROM  #tempJobsToProcessForRetention
WHERE	retentionEndTime NOT BETWEEN @startUnixTime AND @endUnixTime
SET @retVal = @@ERROR
IF  @retVal <> 0
BEGIN
	SET @errorString = 'Failed to delete entries from the temp table.'
	GOTO CX_EXIT
END
IF EXISTS 	(
				SELECT	TOP 1 *
				FROM	#tempJobsToProcessForRetention JobInfo
			)
BEGIN
	SET	@tempXMLVariableForPinJobs =
	(
		SELECT	jobId,commCellId,archGrpCopyId
		FROM	#tempJobsToProcessForRetention JobInfo
		FOR XML AUTO,ROOT('GalaxyOperations_PinJobs')
	)
	SET @retVal = @@ERROR
	IF  @retVal <> 0
	BEGIN
		SET @errorString = 'Error when setting tempXMLVariableForPinJobs.'
		GOTO CX_EXIT
	END
	BEGIN TRAN
	EXEC	@retVal = archPinJobsOnCopy 1 ,@pinUnixTime,1,@tempXMLVariableForPinJobs
	IF  @retVal <> 0
	BEGIN
		SET @errorString = 'Error when executing archPinJobsOnCopy.'
		IF @@TRANCOUNT > 0
			ROLLBACK
		GOTO CX_EXIT
	END
	COMMIT
	SELECT @jobIdList = STUFF
	(
		(
			SELECT	DISTINCT ',' + CONVERT(NVARCHAR(20), jobId)
			FROM 	#tempJobsToProcessForRetention
			FOR XML PATH('')
		),
		1,
		1,
		''
	)
	DECLARE @jobID INT = 0
	DECLARE @retentionEndTime BIGINT = 0
	DECLARE @copyID INT = 0
	DECLARE @prevCopyID INT = 0
	DECLARE	@pinTimeForGAT NVARCHAR(30) = ''
	DECLARE @firstInsert INT = 0
	SET @pinTimeForGAT = CAST (CONVERT ( NVARCHAR(30), DBO.UTCToCellLocalTime( DBO.GetDateTimeBig(@pinUnixTime) , 2),20 ) AS NVARCHAR(30)) -- Need to do this for formatting
	DECLARE @spName 		NVARCHAR(300) = ''
	DECLARE @spCopyName 	NVARCHAR(300) = ''
	DECLARE	@retainTime 	NVARCHAR(30) = ''
	DECLARE @archGroupId 	INT = 0
	DECLARE jobList CURSOR
	FOR SELECT DISTINCT jobID, retentionEndTime,archGrpCopyId FROM #tempJobsToProcessForRetention
	ORDER BY archGrpCopyId,jobID ASC
	OPEN jobList
	FETCH jobList INTO @jobID, @retentionEndTime, @copyID
	SET	@prevCopyID = @copyID
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF @firstInsert = 0 OR @prevCopyID <> @copyID
		BEGIN
			SELECT	@spName = AG.name , @spCopyName = AGC.name , @archGroupId = AG.id
			FROM	archGroup AG WITH (NOLOCK),archGroupCopy AGC WITH (NOLOCK)
			WHERE	AG.id = AGC.archGroupId
				AND	AGC.id = @copyID
			SET @opMsgId = 1409286168 --GUIAUDIT_OPS_PIN_JOB
			EXEC EvGuiAuditSetOpWithEntity @opMsgId, @GUIAuditUserId, 17, @archGroupId, @opEvMsgId OUTPUT, @opId OUTPUT
			SET @paramMsgId = 1426063386 -- GUIAUDIT_PARAMS_STORAGE_POLICY
			EXEC EvGuiAuditSetParamData @opId, @spName, 0
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @GUIAuditUserId
			SET @paramMsgId = 1426063387 -- GUIAUDIT_PARAMS_STORAGE_POLICY_COPY
			EXEC EvGuiAuditSetParamData @opId, @spCopyName, 0
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @GUIAuditUserId
			SET @paramMsgId = 1426064524 -- GUIAUDIT_PARAMS_RETAIN_UNTIL
			EXEC EvGuiAuditSetParamData @opId, @pinTimeForGAT, 0
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @GUIAuditUserId
			SET	@prevCopyID = @copyID
			SET	@firstInsert = 1
		END
		SET @retainTime = CAST (CONVERT ( NVARCHAR(30), DBO.UTCToCellLocalTime( DBO.GetDateTimeBig(@retentionEndTime) , 2),20 ) AS NVARCHAR(30))
		SET @paramMsgId = 1426064697 -- GUIAUDIT_PARAMS_RETAIN_OLD
		EXEC EvGuiAuditSetParamData @opId, @jobID, 0
		EXEC EvGuiAuditSetParamData @opId, @retainTime, 0
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @GUIAuditUserId
			FETCH jobList INTO @jobID, @retentionEndTime, @copyID
	END
	CLOSE jobList
	DEALLOCATE jobList
END
ELSE
BEGIN
	SET @retVal = 10
	SET @errorString = 'No jobs eligible for pinning.'
	GOTO CX_EXIT
END
CX_EXIT:
	IF @retVal <> 0
		IF @retVal = 10
			PRINT @errorString
		ELSE
			PRINT 'Error Code : ' + CAST(@retVal AS VARCHAR(2)) + ', Error String : ' + @errorString
	ELSE
	BEGIN
		PRINT 'Selected Time Range ' + @i_startDate + ' to ' + @i_endDate
		PRINT ''
		PRINT 'Pin Time : ' + @i_pinTime
		PRINT ''
		IF @clientName <> 'Not Applicable'
		BEGIN
			PRINT 'Client Name : ' + @clientName
			PRINT ''
		END
		IF @storagePolicyName <> 'Not Applicable'
		BEGIN
			PRINT 'Storage Policy Name : ' + @storagePolicyName
			PRINT ''
		END
		IF @storagePolicyCopyName <> 'Not Applicable'
		BEGIN
			PRINT 'Storage Policy Copy Name : ' + @storagePolicyCopyName
			PRINT ''
		END
		PRINT 'Listing the jobs which have been retained : '
		PRINT ''
		SELECT	CAST(J.jobId AS NVARCHAR(30))									+ ',' +
				AC.name															+ ',' +
				AIT.displayName													+ ',' +
				ABSN.name														+ ',' +
				AAP.subclientName												+ ',' +
				AG.name															+ ',' +
				AGC.name														+ ',' +
				CAST(dbo.UTCToCellLocalTime( dbo.GetDateTimeBig(retentionEndTime),2) AS NVARCHAR(40))	 AS [JobID,ClientName,AppType,BackupsetName,SubclientName,StoragePolicyName,StoragePolicyCopyName,RetentionEndTime]
		FROM	#tempJobsToProcessForRetention J,APP_Application AAP WITH (NOLOCK), APP_Client AC WITH (NOLOCK), APP_BackupSetName ABSN WITH (NOLOCK),APP_iDAType AIT WITH (NOLOCK), archGroup AG WITH (NOLOCK),archGroupCopy AGC WITH (NOLOCK)
		WHERE	J.appId = AAP.id
			AND	AAP.clientId = AC.id
			AND	ABSN.id = AAP.backupSet
			AND	AIT.type = AAP.appTypeId
			AND	AGC.id = J.archGrpCopyId
			AND	AGC.archGroupId = AG.id
		ORDER BY J.jobId, AC.name, AIT.displayName, ABSN.name, AAP.subclientName, AG.name, AGC.name
	END
	IF OBJECT_ID('tempdb.dbo.#tempJobsToProcessForRetention') IS NOT NULL	DROP TABLE #tempJobsToProcessForRetention
	IF OBJECT_ID('tempdb.dbo.#tblResultDaCalculateRetentionTimeForJobs') IS NOT NULL 	DROP TABLE #tblResultDaCalculateRetentionTimeForJobs
	IF OBJECT_ID('tempdb.dbo.#tblResultArchPinJobsOnCopy') IS NOT NULL 	DROP TABLE #tblResultArchPinJobsOnCopy
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_PinAgingJobsByTimeRange')
	delete from GxQscripts where name = 'QS_PinAgingJobsByTimeRange'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_PinAgingJobsByTimeRange')
	delete from GXDBVersions where aliasname = 'QS_PinAgingJobsByTimeRange'
GO

insert into GXDBVersions values(2, 'QS_PinAgingJobsByTimeRange',  '00000000000000000000', 'QS_PinAgingJobsByTimeRange', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_PinAgingJobsByTimeRange',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '--       qoperation execscript -sn QS_PinAgingJobsByTimeRange -si startTime -si endTime -si retentionTime [-si @clientName = ''Client Name'' -si @storagePolicyName = ''Storage Policy Name'' -si @storagePolicyCopyName = ''Storage Policy Copy Name'']'
 + CHAR(10) + '-- 		Example :'
 + CHAR(10) + '-- 		qoperation execscript -sn QS_PinAgingJobsByTimeRange -si ''2015/12/24'' -si ''2016/03/13'' -si ''2022/03/28'''
 + CHAR(10) + '-- 		qoperation execscript -sn QS_PinAgingJobsByTimeRange -si ''2015/12/24'' -si ''2016/03/13'' -si ''2022/03/28''	-si @clientName = ''Client Name'''
 + CHAR(10) + '-- 		qoperation execscript -sn QS_PinAgingJobsByTimeRange -si ''2015/12/24'' -si ''2016/03/13'' -si ''2022/03/28''	-si @storagePolicyName = ''Storage Policy Name'''
 + CHAR(10) + '-- 		qoperation execscript -sn QS_PinAgingJobsByTimeRange -si ''2015/12/24'' -si ''2016/03/13'' -si ''2022/03/28''	-si @storagePolicyName = ''Storage Policy Name'' -si @storagePolicyCopyName = ''Storage Policy Copy Name'''
 + CHAR(10) + '-- 		qoperation execscript -sn QS_PinAgingJobsByTimeRange -si ''2015/12/24'' -si ''2016/03/13'' -si ''2022/03/28''	-si @clientName = ''Client Name''  -si @storagePolicyName = ''Storage Policy Name'' -si @storagePolicyCopyName = ''Storage Policy Copy Name'''
)
GO

