

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_PickUnpickMediaForRefresh.sp] ---------- 

  -- ----------------------------------------------------------------------
  --
 --           Copyright (c) 1998  CommVault Systems, Inc.
 --                  All rights reserved.
 --
 --
 --        This is unpublished proprietary source code of CommVault
 --        Systems, Inc. The copyright notice above does not evidence
 --        any actual or intended publication of such source code.
 -- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_PickUnpickMediaForRefresh <<<'

IF EXISTS (select * from sysobjects where name='QS_PickUnpickMediaForRefresh')
	drop procedure QS_PickUnpickMediaForRefresh
IF EXISTS (select * from GxQscripts where name='QS_PickUnpickMediaForRefresh')
	delete from GxQscripts where name = 'QS_PickUnpickMediaForRefresh'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_PickUnpickMediaForRefresh')
	delete from GXDBVersions where aliasname = 'QS_PickUnpickMediaForRefresh'
GO
print '... Creating Procedure: QS_PickUnpickMediaForRefresh'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_PickUnpickMediaForRefresh
--QScript is enabled
-- QScript secure this script does the user validation
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
-- SP Input Params
  @MediaOperation NVARCHAR(2048) = N'',
  @BarCodes NVARCHAR(2048) = N''
AS
SET NOCOUNT ON
DECLARE @errorCode INTEGER = 0
DECLARE @ErrorMessage NVARCHAR(MAX) = N''
DECLARE @archGroupCopyCount INTEGER = 0
DECLARE @l_refreshOpType    INTEGER = 0
DECLARE @MediaList VARCHAR(MAX)
DECLARE @userId INTEGER = 0
	IF 'pick' = LOWER(@MediaOperation)
	SET @l_refreshOpType = 1
	ELSE IF 'unpick' = LOWER(@MediaOperation)
	SET @l_refreshOpType = 2
	ELSE IF 'unpickonly' = LOWER(@MediaOperation)
	SET @l_refreshOpType = 3
	ELSE
	BEGIN
		SET	@errorCode = -1
		GOTO CX_EXIT
	END
	DECLARE @InputBarCode TABLE (BarCode VARCHAR(MAX))
	INSERT @InputBarCode
	SELECT *
	FROM dbo.SplitStringByDelimiter(@BarCodes, ',')
	SELECT	@errorCode = @@ERROR, @ErrorMessage = ERROR_MESSAGE()
	IF	@errorCode <> 0
		GOTO CX_EXIT
	IF EXISTS (SELECT * FROM @InputBarCode I LEFT OUTER JOIN MMMedia M ON I.BarCode = M.BarCode WHERE M.MediaId IS NULL)
	BEGIN
		SET	@errorCode = -2
		GOTO CX_EXIT
	END
	IF EXISTS (SELECT * FROM @InputBarCode I WHERE BarCode = 'CV_MAGNETIC')
	BEGIN
		SET	@errorCode = -3
		GOTO CX_EXIT
	END
	SELECT @archGroupCopyCount = COUNT(DISTINCT S.archGroupCopyId) FROM @InputBarCode I, MMMedia M, MMVolume V, archStream S
				WHERE I.BarCode = M.BarCode AND M.MediaId = V.MediaId AND V.MediaGroupId = S.MediaGroupId AND S.flags = 0
	SELECT	@errorCode = @@ERROR, @ErrorMessage = ERROR_MESSAGE()
	IF	@errorCode <> 0
		GOTO CX_EXIT
	IF @archGroupCopyCount = 0
	BEGIN
		SET	@errorCode = -4
		GOTO CX_EXIT
	END
	IF @archGroupCopyCount > 1
	BEGIN
		SET	@errorCode = -5
		GOTO CX_EXIT
	END
	-- get quser id
    SET @userId =  ISNULL( (select userId from #tempQSUser),0)
    IF (@userId = 0)
    BEGIN
       SET @errorCode = -6
        GOTO CX_EXIT
    END
	SELECT @MediaList = COALESCE(@MediaList+',' ,'') + CONVERT(VARCHAR(MAX),M.MediaId)
	FROM @InputBarCode I, MMMedia M
	WHERE I.BarCode = M.BarCode
	SELECT	@errorCode = @@ERROR, @ErrorMessage = ERROR_MESSAGE()
	IF	@errorCode <> 0 GOTO CX_EXIT
	IF (OBJECT_ID('tempdb.dbo.#TmpPickUnpickResult') IS NOT NULL) DROP TABLE #TmpPickUnpickResult
	CREATE TABLE #TmpPickUnpickResult(BucketId INT, SrcMediaId INT, SrcMediaName VARCHAR(256), ReqdMediaId INT,
									   ReqdMediaName VARCHAR(255), Reason INT )
	BEGIN TRAN
	EXEC archMediaRefreshingPickUnpickMedia @l_refreshOpType, @MediaList
	SELECT	@errorCode = @@ERROR, @ErrorMessage = ERROR_MESSAGE()
	IF	@errorCode <> 0
	BEGIN
		ROLLBACK
		GOTO CX_EXIT
	END
	IF EXISTS ( SELECT * FROM #TmpPickUnpickResult WHERE Reason = -1)
	BEGIN
		ROLLBACK
		SET	@errorCode = -7
		GOTO CX_EXIT
	END
	IF EXISTS ( SELECT * FROM #TmpPickUnpickResult WHERE Reason = -5)
	BEGIN
		ROLLBACK
		SET	@errorCode = -8
		GOTO CX_EXIT
	END
	IF EXISTS ( SELECT * FROM #TmpPickUnpickResult WHERE Reason = -3)
	BEGIN
		ROLLBACK
		SET	@errorCode = -9
		GOTO CX_EXIT
	END
	IF EXISTS ( SELECT * FROM #TmpPickUnpickResult WHERE Reason = -4)
	BEGIN
		ROLLBACK
		SET	@errorCode = -10
		GOTO CX_EXIT
	END
	-- Declare temp variables for Gui Audit
	DECLARE @opMsgId 			INTEGER
	DECLARE @opEvMsgId 			INTEGER
	DECLARE @opId 				INTEGER
	DECLARE @paramMsgId 		INTEGER
	-- Assume admin user here
	DECLARE @GUIAuditUserId INT = @userId
	-- Set Gui Audit Operation
	IF @l_refreshOpType = 1
	SET @opMsgId = 1409286435  --GUIAUDIT_OPS_PICK_MEDIA_FOR_REFRESHING
	ELSE
	SET @opMsgId = 1409286436  --GUIAUDIT_OPS_UNPICK_MEDIA_FOR_REFRESHING
	EXEC EvGuiAuditSetOperation @opMsgId, @GUIAuditUserId, @opEvMsgId OUTPUT, @opId OUTPUT
	SET @paramMsgId = 1426063365   --GUIAUDIT_PARAMS_MEDIA_LIST
	EXEC EvGuiAuditSetParamData @opId, @BarCodes , 0
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @GUIAuditUserId
	SELECT	@errorCode = @@ERROR, @ErrorMessage = ERROR_MESSAGE()
	IF	@errorCode <> 0
	BEGIN
		ROLLBACK
		GOTO CX_EXIT
	END
	COMMIT
CX_EXIT:
	IF @errorCode = -1
		SET @ErrorMessage = 'Error: Invalid MediaOperation type.'
	ELSE IF @errorCode = -2
		SET @ErrorMessage = 'Error: Invalid Media BarCode Input.'
	ELSE IF @errorCode = -3
		SET @ErrorMessage = 'Error: This script is not for Magnetic Media.'
	ELSE IF @errorCode = -4
		SET @ErrorMessage = 'Error: Input media does not belong to any copy. Please provide media which is having valid data.'
	ELSE IF @errorCode = -5
		SET @ErrorMessage = 'Error: Multiple copies media cannot be provided as input, Input Barcodes should belong to one copy.'
	ELSE IF @errorCode = -6
		SET @ErrorMessage = 'Error: Logged in user information not found.'
	ELSE IF @errorCode = -7
		SET @ErrorMessage = 'Error: Media Refresh is not enabled.'
	ELSE IF @errorCode = -8
		SET @ErrorMessage = 'Error: Media Refresh Job is running.'
	ELSE IF @errorCode = -9
		SET @ErrorMessage = 'Error: Input or dependent media is bad.'
	ELSE IF @errorCode = -10
		SET @ErrorMessage = 'Error: Input media is not full.'
	ELSE IF @errorCode <> 0
		SET @ErrorMessage = 'Error: Failed to execute script. Error code [' + CAST(@errorCode AS VARCHAR(20)) + '], Error Message [' + @ErrorMessage + ']'
	ELSE
	SET @ErrorMessage = 'Successfully ' +
    CASE @l_refreshOpType
		WHEN 1
		THEN 'picked'
		WHEN 2
		THEN 'unpicked and prevented'
		WHEN 3
		THEN 'unpicked'
		ELSE @MediaOperation
		END  + ' the input media, '	+ CONVERT(VARCHAR(60), GETDATE())+'.'
	IF @errorCode NOT IN (0)
		Raiserror(@ErrorMessage,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
	ELSE
		SELECT	@ErrorMessage
IF (OBJECT_ID('tempdb.dbo.#TmpPickUnpickResult') IS NOT NULL) DROP TABLE #TmpPickUnpickResult
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_PickUnpickMediaForRefresh')
	delete from GxQscripts where name = 'QS_PickUnpickMediaForRefresh'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_PickUnpickMediaForRefresh')
	delete from GXDBVersions where aliasname = 'QS_PickUnpickMediaForRefresh'
GO

insert into GXDBVersions values(2, 'QS_PickUnpickMediaForRefresh',  '00000000000000000000', 'QS_PickUnpickMediaForRefresh', '00000000000000000000')
GO

insert into GxQscripts values(2+8,'QS_PickUnpickMediaForRefresh',  0, GETDATE(), GETDATE(), '' + CHAR(10) + ' qoperation execscript -sn PickUnpickMediaForRefresh -si MediaOperation -si BarCodes
'
 + CHAR(10) + ' Operations are pick, unpick and unpickonly.
'
 + CHAR(10) + ' unpick operation will unpick the media and also prevent the media for refresh, but unpickonly operation will only unpick the media.
'
)
GO

