

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_PickLatestCycleJobsForCIForSps.sp] ---------- 

SET ANSI_NULLS ON
-- ----------------------------------------------------------------------
--
--           Copyright (c) 2014  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_PickLatestCycleJobsForCIForSps.sp,v $ $Id: QS_PickLatestCycleJobsForCIForSps.sp,v 1.4.60.3 2018/03/20 19:58:27 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_PickLatestCycleJobsForCIForSps <<<'

IF EXISTS (select * from sysobjects where name='QS_PickLatestCycleJobsForCIForSps')
	drop procedure QS_PickLatestCycleJobsForCIForSps
IF EXISTS (select * from GxQscripts where name='QS_PickLatestCycleJobsForCIForSps')
	delete from GxQscripts where name = 'QS_PickLatestCycleJobsForCIForSps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_PickLatestCycleJobsForCIForSps')
	delete from GXDBVersions where aliasname = 'QS_PickLatestCycleJobsForCIForSps'
GO
print '... Creating Procedure: QS_PickLatestCycleJobsForCIForSps'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_PickLatestCycleJobsForCIForSps
-- This script will mark backup jobs of latest cycle of each subclient associated to a given Storage policy as Picked for content indexing.
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--  4 Corresponds to "high", same as same functionality in GUI.  Macro doesn't expand right for some reason
-- Qscript Usage.
  @SPName nvarchar(max) = N''		
AS
SET NOCOUNT ON
------------ Convenience Definitions    -----------
	DECLARE @scriptName	varchar(64) = 'QS_PickLatestCycleJobsForCIForSps'
	DECLARE @localErrorCode	integer = 0
	DECLARE @localMsg				varchar(MAX) ='Successful.'
	DECLARE @rowCount int = 0
	DECLARE @JOBSPicked VARCHAR(MAX)
-------------------------------------------------------------
if isnull(@SPName, N'') = N'' begin
 	SET @localMsg = 'Storage Policy not specified.'
	GOTO ERROR_EXIT
end
--
declare @archGroupId int = 0
declare @commCellId int = 2
--
select @archGroupId = id from archGroup G
inner join archContentIndexingRules R on R.archGroupId = G.id
where G.name = @SPName and R.enabled = 1 AND R.operationType = 1
if @archGroupId = 0 begin
	SET @localMsg = 'Storage Policy not found or storage policy not enabled for content indexing.'
	GOTO ERROR_EXIT
end
--
declare @SubclientTable table
(
      AppId int,
      LatestCycleStartJobId int
)
insert into @SubclientTable(AppId, LatestCycleStartJobId)
select
      A.appId, MAX(A.jobId) as JobId
from
      archFile A with (nolock)
inner join
      JMBkpStats J with (nolock)
on
      j.jobId = A.jobId and j.commCellId = A.commCellId
inner join
      APP_Application APP with (nolock)
on
      APP.id = A.appId and (APP.subclientStatus & 2) <> 2
inner join
	  APP_ClientProp CP with (nolock)
on
	  APP.clientId = CP.componentNameId
where
      A.fileType = 1 and A.isValid = 1
      and j.bkpLevel in (0x1 /*FULL*/, 0x40 /*SYNTHETIC_FULL*/, 0x80 /*SYNTHETIC_FULL_AND_INCR*/, 0x4000 /*SYNTHETIC_FULL_AND_INCR_BEFORE*/)
      and j.status = 1
      and A.archGroupId = @archGroupId
	  and CP.attrName ='Content Indexing Enabled' and CP.attrVal = '1' and CP.modified = 0
group by
      A.appId
--
declare @JobsToPick table
(
	jobId int primary key
)
begin try
	begin transaction
	--
	insert into @JobsToPick (jobId)
	select
		distinct jobId
	from
		 archFile A with (nolock)
	inner join
		@SubclientTable S
	on
		A.appId = S.AppId
		and A.filetype = 1
		and A.jobId >= S.LatestCycleStartJobId
		and A.flags = 0
		and A.archGroupId = @archGroupId
	--
	if exists (SELECT TOP 1 * FROM @JobsToPick)
	begin
		update archFile set flags = 16 from archFile A inner join @SubclientTable S
		on  A.appId = S.AppId and A.filetype = 1
		and A.jobId >= S.LatestCycleStartJobId
		and A.flags = 0
		and A.archGroupId = @archGroupId
		--
		if (@@ERROR <> 0)
		begin
			set @localErrorCode = @@ERROR
			set @localMsg = 'Failed to mark jobs as picked.'
			goto ERROR_EXIT
		end
		--
		set @rowCount = @@ROWCOUNT
		select @JOBSPicked = COALESCE( @JOBSPicked + ',', '') + CONVERT(VARCHAR(10), jobId) FROM @JobsToPick
		set @localMsg = @localMsg + '. Jobs affected: ' + @JOBSPicked
	end
	else
	begin
		set @localMsg = 'No jobs picked for the Storage Policy.'
		goto ERROR_EXIT
	end
end try
begin catch
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @localErrorCode = ERROR_NUMBER()
	SELECT @localMsg = @scriptName + ' Failed with error: ' + ERROR_MESSAGE()
	goto ERROR_EXIT
end catch
--
IF @rowCount > 0 AND @localErrorCode = 0 SET @localMsg = @localMsg + '. Number of rows affected in database: ' + CONVERT(VARCHAR(10), @rowCount)
--
--SELECT @localMsg
--
ERROR_EXIT:
    if @@trancount > 0
	begin
		IF @localErrorCode <> 0 ROLLBACK TRANSACTION
		ELSE COMMIT TRANSACTION
	end
--
--
PROC_ERROR:
	PRINT ''
	PRINT @scriptName + ' completed at ' + Convert(varchar(60), getdate())+' with parameters ' + 'Storage Policy ['+ @SPName + ']. '
					+ @localMsg + ' ErrorCode (' + Convert(varchar(2),@localErrorCode) +').'
	--
	if @localErrorCode > 0 begin
		Raiserror(@localMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
	end
GO

IF EXISTS (select * from GxQscripts where name = 'QS_PickLatestCycleJobsForCIForSps')
	delete from GxQscripts where name = 'QS_PickLatestCycleJobsForCIForSps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_PickLatestCycleJobsForCIForSps')
	delete from GXDBVersions where aliasname = 'QS_PickLatestCycleJobsForCIForSps'
GO

insert into GXDBVersions values(2, 'QS_PickLatestCycleJobsForCIForSps',  '00010004006000030000', 'QS_PickLatestCycleJobsForCIForSps', '00010004006000030000')
GO

insert into GxQscripts values(2,'QS_PickLatestCycleJobsForCIForSps',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '		Storage policy name is the name of a specific storage policy
'
 + CHAR(10) + '		Note: Output returns what jobs are affected and number of rows updated in Database.
'
)
GO

