

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_PerformAlertOp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_PerformAlertOp <<<'

IF EXISTS (select * from sysobjects where name='QS_PerformAlertOp')
	drop procedure QS_PerformAlertOp
IF EXISTS (select * from GxQscripts where name='QS_PerformAlertOp')
	delete from GxQscripts where name = 'QS_PerformAlertOp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_PerformAlertOp')
	delete from GXDBVersions where aliasname = 'QS_PerformAlertOp'
GO
print '... Creating Procedure: QS_PerformAlertOp'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_PerformAlertOp
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @name nvarchar(1024), 
  @operation nvarchar(1024) 
AS
  DECLARE @response nvarchar( 1024)
Set NOCOUNT ON
DECLARE @newStatus int
DECLARE @newSatusName VARCHAR(1024)
DECLARE @revision INT
DECLARE @userId INT
DECLARE @alertId INT
DECLARE @ownerId INT
DECLARE @callerID INT
DECLARE @errorCode INT
DECLARE @capability int
SET     @capability             = 18
SET @revision = 1
SET @userId =  ISNULL( (select userId from #tempQSUser),0)
IF (@userId = 0)
BEGIN
  SET @errorCode = 1
  SET @response = 'Error, no logged in user found'
  GOTO procEnd
END
------------------------------
--  Checking the alert name is valid or not.
IF NOT EXISTS ( SELECT *FROM NTnotificationRule
				WHERE notificationName  =  @name
				and (status&2) = 0
				and revision = 1 )
BEGIN
	SET @response = 'Error : Given alert name ['+  @name + '] is invalid.'
	GOTO procEnd
END
-- Checking whether user have permision to do the operation or not.
--  Getting the alertId and ownerId
SELECT @alertId = id ,  @ownerId  = notifOwner  FROM NTnotificationRule
WHERE notificationName  =  @name
and (status&2) = 0
and revision = 1
------------------------------------------------------------------------------------
--  CHECK FOR THE RIGHTS! --
-----------------------------------------------------------------------------
--- Get Caller Id
SET @callerID =  ISNULL( (select userId from #tempQSUser),0)
IF (@ownerId <> @callerID)
BEGIN
    exec br_NTPermCheck @callerID, 0 , @capability, 2018, 2, @errorCode OUTPUT, @response OUTPUT
    IF @errorCode <> 0
        goto procEnd
END
-----------------------------
	IF @operation = 'DELETE'
	BEGIN
	SET @revision = 0
	SET @newStatus = 2
	SET @newSatusName = 'deleted'
	END
	ELSE IF @operation = 'DISABLE'
	BEGIN
	SET @newStatus = 1
	SET @newSatusName = 'disabled'
	END
	ELSE IF @operation = 'ENABLE'
	  BEGIN
		UPDATE NTnotificationRule
		SET  status =  (status&(~1))
		WHERE
		notificationName  =  @name
		SET @response = 'You have enabled Alert: '+ @name +' successfully.'
		GOTO procEnd
	  END
	ELSE
	BEGIN
		  SET @response = 'Error :  Unable to process given operation type [ ' + @operation + ' ].'
		  GOTO procEnd
	END
	-- Handling the delete and disabling case.
	UPDATE NTnotificationRule
	SET  status =  (status|@newStatus),
	     revision = @revision
	WHERE
	notificationName  =  @name
	SET @response = 'You have '+ @newSatusName + ' Alert: '+ @name +' successfully.'
procEnd:
  select   @response
GO

IF EXISTS (select * from GxQscripts where name = 'QS_PerformAlertOp')
	delete from GxQscripts where name = 'QS_PerformAlertOp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_PerformAlertOp')
	delete from GXDBVersions where aliasname = 'QS_PerformAlertOp'
GO

insert into GXDBVersions values(2, 'QS_PerformAlertOp',  '00000000000000000000', 'QS_PerformAlertOp', '00000000000000000000')
GO

insert into GxQscripts values(2+8,'QS_PerformAlertOp',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '    qoperation execscript -sn QS_PerformAlertOp.sql -si alertName -si operation
'
 + CHAR(10) + '--   script_name : QS_PerformAlertOp'
)
GO

