

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_OraMultiDBCGSnapConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_OraMultiDBCGSnapConfig <<<'

IF EXISTS (select * from sysobjects where name='QS_OraMultiDBCGSnapConfig')
	drop procedure QS_OraMultiDBCGSnapConfig
IF EXISTS (select * from GxQscripts where name='QS_OraMultiDBCGSnapConfig')
	delete from GxQscripts where name = 'QS_OraMultiDBCGSnapConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_OraMultiDBCGSnapConfig')
	delete from GXDBVersions where aliasname = 'QS_OraMultiDBCGSnapConfig'
GO
print '... Creating Procedure: QS_OraMultiDBCGSnapConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_OraMultiDBCGSnapConfig
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientGroupName NVARCHAR(1024) = '%s',
  @hourlySchedPolicyName NVARCHAR(1024) = '%s',
  @dailySchedPolicyName NVARCHAR(1024) = '%s',
  @fullScan NVARCHAR(1024) = '%s'
AS
------------------input prefixes-----------------------------------------
DECLARE @clientGroupId			INT
DECLARE @hourlySchePolicyId		INT
DECLARE @dailySchePolicyId		INT
DECLARE @full					INT
----------------------constants------------------------------------------
DECLARE @scriptName nvarchar(128) = 'OraMultiDBCGSnapConfig'
DECLARE @nowTime integer = dbo.GetUnixTime (GetUTCdate())
DECLARE @oracleApptype integer = 22
DECLARE @lastCheckTimeProp nvarchar(128) = 'OraInstanceScanTime'
DECLARE @lastCheckTime	INT = 0
DECLARE @descriptName nvarchar(128) ='User Description'
DECLARE @excludeDescription nvarchar(128) = '%exclude from cvsnap schedule%'
DECLARE @cloneDbSnapName nvarchar(128) = '_clone'
DECLARE @dbSnapName nvarchar(128) = '_snap'
DECLARE @ignorASM nvarchar(128) = '+ASM'
DECLARE @assocType INT = 7 --ENTITY_TYPE_SUBCLIENT_ENTITY
---TEST----
--SET @clientGroupName='Ying'
--SET @hourlySchedPolicyName='cluster_AMFAM'
--SET @dailySchedPolicyName='AMFAM'
--SET @fullScan='y'
-----------------------error handling------------------------------------
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
---------------insufficient parameters -----------------------------------------
DECLARE @noParameter NVARCHAR(32)
SET @noParameter = '%'
SET @noParameter = @noParameter + 's'
IF @clientGroupName = @noParameter
BEGIN
    SET @errorCode = 1
    SET @errorString = 'Error. Client group name was not supplied as an input.'
    GOTO ERROR_EXIT
END
SET @clientGroupId = ISNULL((SELECT id FROM APP_ClientGroup WHERE name like @clientGroupName), 0)
IF @clientGroupId = 0
BEGIN
    SET @errorCode = 1
    SET @errorString = 'Error. Client group ['+@clientGroupName+'] not found.'
    GOTO ERROR_EXIT
END
IF @hourlySchedPolicyName = @noParameter
BEGIN
    SET @errorCode = 1
    SET @errorString = 'Error. Hourly schedule policy name was not supplied as an input.'
    GOTO ERROR_EXIT
END
SET @hourlySchePolicyId = ISNULL((SELECT taskId FROM TM_Task WHERE taskName like @hourlySchedPolicyName), 0)
IF @hourlySchePolicyId = 0
BEGIN
    SET @errorCode = 1
    SET @errorString = 'Error. Schedule policy ['+@hourlySchedPolicyName+'] not found.'
    GOTO ERROR_EXIT
END
IF @dailySchedPolicyName = @noParameter
BEGIN
    SET @errorCode = 1
    SET @errorString = 'Error. Hourly schedule policy name was not supplied as an input.'
    GOTO ERROR_EXIT
END
SET @dailySchePolicyId = ISNULL((SELECT taskId FROM TM_Task WHERE taskName like @dailySchedPolicyName), 0)
IF @dailySchePolicyId = 0
BEGIN
    SET @errorCode = 1
    SET @errorString = 'Error. Schedule policy ['+@dailySchedPolicyName+'] not found.'
    GOTO ERROR_EXIT
END
IF @fullScan <> 'y' OR @fullScan <> 'Y'
BEGIN
	SET @lastCheckTime = ISNULL((SELECT CAST(value AS VARCHAR(100)) FROM GXGlobalParam where name=@lastCheckTimeProp), 0)
END
-------------------------------------------------------------------------------
DECLARE @clientId		INT
DECLARE @appTypeId		INT
DECLARE @instanceId		INT
DECLARE @backupSetId	INT
DECLARE @dataArchGrpId	INT
DECLARE @logArchGrpId	INT
--DECLARE @subclientId	INT
DECLARE @snapSCId		INT
DECLARE @cloneSnapSCId	INT
DECLARE @clientName		nvarchar(128)
DECLARE @instanceName	nvarchar(128)
DECLARE @messageText	nvarchar(max)='Created snap subclients for:' + CHAR(10)
BEGIN TRAN
	DECLARE curInstanceFound CURSOR FOR
	SELECT DISTINCT APP.clientId, C.name, APP.appTypeId, APP.instance, INS.name, APP.backupSet, APP. dataArchGrpID, APP.logArchGrpID
	FROM APP_Application APP WITH (NOLOCK)
	JOIN APP_InstanceName INS WITH (NOLOCK) ON INS.id=APP.instance AND (INS.refTime > @lastCheckTime OR @lastCheckTime = 0) AND INS.name <> @ignorASM
	JOIN APP_Client C ON C.id = APP.clientId
	JOIN APP_InstanceProp INP WITH (NOLOCK) ON INP.componentNameId=INS.id
	JOIN APP_BackupSetName BS WITH (NOLOCK) ON BS.id=APP.backupSet
	WHERE APP.clientId in (
		SELECT clientId FROM APP_ClientGroupAssoc WITH (NOLOCK) WHERE clientGroupId=@clientGroupId
	)
	AND APP.appTypeId=@oracleApptype	--ONLY FOR ORACLE APPTYPE
	AND	APP.subclientStatus&8=8			--ONLY GET ONE SUBCLIENT
	AND INS.status&16=0					--IGNORE defaultDummyInstanceForOracle
	AND NOT EXISTS(SELECT 1 FROM APP_Application AP WHERE AP.clientId=APP.clientId AND AP.instance=APP.instance AND (AP.subclientName=(INS.name+@cloneDbSnapName) OR AP.subclientName=(INS.name+@dbSnapName)))
	AND
	(
		(INP.attrName=@descriptName AND INP.modified=0 AND INP.attrVal not like @excludeDescription)
		OR
		NOT EXISTS (SELECT 1 FROM APP_InstanceProp WHERE componentNameId=INS.id AND attrName=@descriptName)
	)
	OPEN curInstanceFound
	FETCH NEXT FROM curInstanceFound INTO @clientId, @clientName, @appTypeId, @instanceId, @instanceName, @backupSetId, @dataArchGrpId, @logArchGrpId
	WHILE   @@FETCH_STATUS = 0
	BEGIN
		--CREATE SNAP SUBCLIENT
		INSERT INTO APP_application (clientid, apptypeid, instance, backupset, appNumber, dataArchGrpId, logArchGrpId, refTime, modified, subclientName, subclientstatus)
			VALUES(@clientId, @oracleApptype, @instanceId, @backupsetId, 0, @dataArchGrpId , @logArchGrpId , @nowTime, 0, @instanceName+@dbSnapName, 0)
		SET @errorCode = @@error
		IF @errorCode <> 0
		BEGIN
			SET @errorString = 'Error. Error trying to create '+@instanceName+@dbSnapName+' subclient for client['+@clientName+'] instance['+@instanceName +'].'
			GOTO TRANS_EXIT
		END
		SET @snapSCId = @@IDENTITY
		--CREATE SNAP SUBCLIENT PROPERTIES
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'Arch per bfs', 8, 32, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'Archive Log Deleting', 2, 0, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'Backup Archive Log', 2, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'Encrypt: encryption', 10, 2, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'force differential backup', 2, 0, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'Single Instancing Option', 7, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'last data SP', 10, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'last log SP', 10, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'Enable Snap Backups', 2, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'Oracle Backup Archive Log Destinations', 1, '`', @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'Oracle Log backup streams', 7, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'Oracle Data backup streams', 7, 3, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'sys: pre post option', 10, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'Use RMAN for Tape Movement', 2, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@snapSCId, 'Snap Engine', 10, 5, @nowTime , 0)	--SM_SNAPSHOT_ENGINE_SYMMETRIX_SNAP
		--ADD SUBCLIENT TO HOURLY SCHEDULE
		INSERT INTO TM_AssocEntity (assocType, taskId, flags, created, clientGroupId, clientId, apptypeId, instanceId, backupsetId, subclientId, policyId, copyId, srmReportSet, srmReportType, exclude, trackingPolicyId, MediaAgentId, agentlessPolicyId, workflowId,
		sidbStoreId, libraryId, logMonitoringPolicyId)
		VALUES(@assocType, @hourlySchePolicyId, 0, @nowTime, 0, @clientId, @appTypeId, @instanceId, @backupSetId, @snapSCId, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0)
		SET @errorCode = @@error
		IF @errorCode <> 0
		BEGIN
			SET @errorString = 'Error. Error trying to add subclient '+@snapSCId+' for client['+@clientName+'] instance['+@instanceName +'] to schedule policy ['+@hourlySchedPolicyName+'].'
			GOTO TRANS_EXIT
		END
		--CREATE CLONE SNAP SUBCLIENT
		INSERT INTO APP_application (clientid, apptypeid, instance, backupset, appNumber, dataArchGrpId, logArchGrpId, refTime, modified, subclientName, subclientstatus)
			VALUES(@clientId, @oracleApptype, @instanceId, @backupsetId, 0, @dataArchGrpId , @logArchGrpId , @nowTime, 0, @instanceName+@cloneDbSnapName, 0)
		SET @errorCode = @@error
		IF @errorCode <> 0
		BEGIN
			SET @errorString = 'Error. Error trying to create '+@instanceName+@cloneDbSnapName+' subclient for client['+@clientName+'] instance['+@instanceName +'].'
			GOTO TRANS_EXIT
		END
		SET @cloneSnapSCId = @@IDENTITY
		--CREATE SNAP CLONE SUBCLIENT PROPERTIES
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'Arch per bfs', 8, 32, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'Archive Log Deleting', 2, 0, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'Backup Control Files', 2, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'Encrypt: encryption', 10, 2, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'force differential backup', 2, 0, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'Single Instancing Option', 7, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'last data SP', 10, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'last log SP', 10, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'Enable Snap Backups', 2, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'Oracle Backup Archive Log Destinations', 1, '`', @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'Oracle Log backup streams', 7, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'Oracle Data backup streams', 7, 3, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'sys: pre post option', 10, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'Use RMAN for Tape Movement', 2, 1, @nowTime , 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@cloneSnapSCId, 'Snap Engine', 10, 28, @nowTime , 0)	--SM_SNAPSHOT_ENGINE_SYMMETRIX_CLONE
		--ADD SUBCLIENT TO DAILY SCHEDULE
		INSERT INTO TM_AssocEntity (assocType, taskId, flags, created, clientGroupId, clientId, apptypeId, instanceId, backupsetId, subclientId, policyId, copyId, srmReportSet, srmReportType, exclude, trackingPolicyId, MediaAgentId, agentlessPolicyId, workflowId,
		sidbStoreId, libraryId, logMonitoringPolicyId)
		VALUES(@assocType, @dailySchePolicyId, 0, @nowTime, 0, @clientId, @appTypeId, @instanceId, @backupSetId, @cloneSnapSCId, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0)
		SET @errorCode = @@error
		IF @errorCode <> 0
		BEGIN
			SET @errorString = 'Error. Error trying to add subclient '+@cloneDbSnapName+' for client['+@clientName+'] instance['+@instanceName +'] to schedule policy ['+@dailySchePolicyId+'].'
			GOTO TRANS_EXIT
		END
		SET @messageText = @messageText + ' Client ['+@clientName+'] Instance ['+@instanceName+']' + CHAR(10)
		FETCH NEXT FROM curInstanceFound INTO @clientId, @clientName, @appTypeId, @instanceId, @instanceName, @backupSetId, @dataArchGrpId, @logArchGrpId
	END
	CLOSE curInstanceFound
	DEALLOCATE curInstanceFound
	IF EXISTS (SELECT 1 FROM GXGlobalParam WHERE name=@lastCheckTimeProp)
		UPDATE GXGlobalParam SET value=CAST(@nowTime AS NVARCHAR(100)) WHERE name=@lastCheckTimeProp
	ELSE
		INSERT INTO GXGlobalParam (name, value, created, modified)
		VALUES(@lastCheckTimeProp, CAST(@nowTime AS NVARCHAR(100)), @nowTime, 0)
TRANS_EXIT:
IF @errorCode <> 0
BEGIN
    ROLLBACK TRAN
	PRINT 'Nothing created'
END
ELSE
BEGIN
    COMMIT TRAN
	PRINT @messageText
END
ERROR_EXIT:
Print @scriptName + ' completed at '+ Convert(varchar(60), getdate())+'. ErrorCode ('+  Convert(varchar(10), @errorCode) +').'
    --Close cursor
    IF ( CURSOR_STATUS('global', 'curInstanceFound') >= 0  /* cursor is open */
        OR CURSOR_STATUS('local', 'curInstanceFound') >= 0 )
        CLOSE curInstanceFound
    IF ( CURSOR_STATUS('global','curInstanceFound') = -1  /* cursor is closed */
        OR CURSOR_STATUS('local','curInstanceFound') = -1 )
        DEALLOCATE curInstanceFound
if @errorCode <> 0
    Raiserror(@errorString,
                15,  --Severity (> 10 to force DOS Error Code = 1)
                1    --State
                )
GO

IF EXISTS (select * from GxQscripts where name = 'QS_OraMultiDBCGSnapConfig')
	delete from GxQscripts where name = 'QS_OraMultiDBCGSnapConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_OraMultiDBCGSnapConfig')
	delete from GXDBVersions where aliasname = 'QS_OraMultiDBCGSnapConfig'
GO

insert into GXDBVersions values(2, 'QS_OraMultiDBCGSnapConfig',  '00000000000000000000', 'QS_OraMultiDBCGSnapConfig', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_OraMultiDBCGSnapConfig',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn OraMultiDBCGSnapConfig.sql -i [client group name] [hourly schedule policy name daily] [schedule policy name] [y/n (full scan)]
'
 + CHAR(10) + '--   script_name : OraMultiDBCGSnapConfig'
)
GO

