

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_NTUpdateRuleForMetricsAlerts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_NTUpdateRuleForMetricsAlerts.sp,v $ $Id: QS_NTUpdateRuleForMetricsAlerts.sp,v 1.3.14.3 2018/03/27 08:50:48 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_NTUpdateRuleForMetricsAlerts <<<'

IF EXISTS (select * from sysobjects where name='QS_NTUpdateRuleForMetricsAlerts')
	drop procedure QS_NTUpdateRuleForMetricsAlerts
IF EXISTS (select * from GxQscripts where name='QS_NTUpdateRuleForMetricsAlerts')
	delete from GxQscripts where name = 'QS_NTUpdateRuleForMetricsAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_NTUpdateRuleForMetricsAlerts')
	delete from GXDBVersions where aliasname = 'QS_NTUpdateRuleForMetricsAlerts'
GO
print '... Creating Procedure: QS_NTUpdateRuleForMetricsAlerts'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_NTUpdateRuleForMetricsAlerts
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
AS
Set NOCOUNT ON
DECLARE @scriptName NVARCHAR(MAX) = N''
SET @scriptName = N'NTUpdateRuleForMetricsAlerts'
DECLARE @lastError integer
SET @lastError = 0
DECLARE @localErrorMsg nvarchar(1024)
SET @localErrorMsg = ''
BEGIN TRY
	BEGIN TRAN
	declare @AlarmAlertMapping table
	(
		alarmId int,
		alertId int,
		queryID int,
		reportName nvarchar(max),
		commUniId nvarchar(max),
		updatedQueryId int
	)
	Insert into @AlarmAlertMapping
	SELECT K.AlarmId,0,0,K.reportName,CASE WHEN PATINDEX('%commUniId=%', K.uniqueIdStr) = 0 THEN '' ELSE SUBSTRING(K.uniqueIdStr, (PATINDEX('%commUniId=%', K.uniqueIdStr) + 10), 10) END,0
		FROM
		(SELECT CP.AlarmId, CP.reportName, ISNULL(x.value('@reportUniqId', 'NVARCHAR(1024)'), '') AS uniqueIdStr,
			ISNULL(x.value('@reportEnum', 'NVARCHAR(max)'), '') AS reportEnum
			FROM CustomAlarmProps CP
			CROSS APPLY CP.extendedProps.nodes('alarmProps') M(x)) K
		where K.reportEnum='survey'
	-- First remove all worldwide commcells from this list since they are associated to correct rule anyways.
	delete from @AlarmAlertMapping
	where commUniId is null or len(commUniId)=0
	Update AlarmAlertMapping
	set QueryId = NTNotificationQueryMapping.queryId,
	alertId = NTNotificationQueryMapping.NTNotificationId,
	updatedQueryId = NTNotificationQueryMapping.queryId
	from @AlarmAlertMapping AlarmAlertMapping
	inner join NTNotificationQueryMapping on
	AlarmAlertMapping.alarmId=IsNull(convert(xml,NTNotificationQueryMapping.xmlInfo).value('(CVGui_QueryAdditionalInfo/externalQueryInfo/@externalQueryId)[1]','int'),0)
	inner join NTQueryList on
	NTQueryList.queryId = NTNotificationQueryMapping.queryId
	and IsNull(convert(xml,NTQueryList.xmlInfo).value('(App_AdditionalQueryDetails/externalQueryEntity/@queryType)[1]','int'),1)=2
	Update AlarmAlertMapping
	set updatedQueryId = NTQueryList.queryId
	from @AlarmAlertMapping AlarmAlertMapping
	inner join NTQueryList on
	IsNull(convert(xml,NTQueryList.xmlInfo).value('(App_AdditionalQueryDetails/externalQueryEntity/@queryType)[1]','int'),1)=2
	and IsNull(convert(xml,NTQueryList.xmlInfo).value('(App_AdditionalQueryDetails/externalQueryEntity/@externalQueryId)[1]','nvarchar(max)'),'')=AlarmAlertMapping.reportName+'|'+AlarmAlertMapping.commUniId
	-- Update TaskID also for that rule
	Update NTNotificationQueryMapping
	set queryID = AlarmAlertMapping.updatedQueryID,
	taskId = NTQueryList.taskId,
	isscheduled = case when NTQueryList.taskId>0 then 1 else 0 end
	from @AlarmAlertMapping AlarmAlertMapping, NTQueryList
	where AlarmAlertMapping.alertId=NTNotificationQueryMapping.NTNotificationId
	and AlarmAlertMapping.queryID<>AlarmAlertMapping.updatedQueryId
	and NTQueryList.queryId = AlarmAlertMapping.updatedQueryID
	COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
BEGIN
	ROLLBACK TRAN
	SET @lastError = ERROR_NUMBER()
    SET @localErrorMsg = 'Problem updating custom rule for commcell specific metrics alerts ' +ERROR_MESSAGE()
 	GOTO ERROR_EXIT
END
END CATCH
	ERROR_EXIT:
     	-- Print @scriptName + ' completed at '+ Convert(varchar(60), getdate())+'. ErrorCode ('+ Convert(varchar(2),@lastError) +').'
if @lastError <> 0
     	Raiserror(@localErrorMsg,
     			    15,  --Severity (> 10 to force DOS Error Code = 1)
     				1	 --State
     				)
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_NTUpdateRuleForMetricsAlerts')
	delete from GxQscripts where name = 'QS_NTUpdateRuleForMetricsAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_NTUpdateRuleForMetricsAlerts')
	delete from GXDBVersions where aliasname = 'QS_NTUpdateRuleForMetricsAlerts'
GO

insert into GXDBVersions values(2, 'QS_NTUpdateRuleForMetricsAlerts',  '00010003001400030000', 'QS_NTUpdateRuleForMetricsAlerts', '00010003001400030000')
GO

insert into GxQscripts values(2,'QS_NTUpdateRuleForMetricsAlerts',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_NTUpdateRuleForMetricsAlerts.sql
'
 + CHAR(10) + '-- 	script_name: NTUpdateRuleForMetricsAlerts.'
 + CHAR(10) + '-- 	Update custom rule for all commcell level metrics alerts.'
)
GO

