

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_NTEnableDisableApplicationMgmtAlerts.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_NTEnableDisableApplicationMgmtAlerts <<<'

IF EXISTS (select * from sysobjects where name='QS_NTEnableDisableApplicationMgmtAlerts')
	drop procedure QS_NTEnableDisableApplicationMgmtAlerts
IF EXISTS (select * from GxQscripts where name='QS_NTEnableDisableApplicationMgmtAlerts')
	delete from GxQscripts where name = 'QS_NTEnableDisableApplicationMgmtAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_NTEnableDisableApplicationMgmtAlerts')
	delete from GXDBVersions where aliasname = 'QS_NTEnableDisableApplicationMgmtAlerts'
GO
print '... Creating Procedure: QS_NTEnableDisableApplicationMgmtAlerts'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_NTEnableDisableApplicationMgmtAlerts
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
  @NewState NVarchar(256),		-- Must always have this parameter
  @AlertTypeParam Nvarchar(1030)
AS
Set NOCOUNT ON
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'QS_NTEnableDisableApplicationMgmtAlerts'
DECLARE @created				AS integer		= 0
DECLARE @nowTime				AS integer		= dbo.GetUnixTime (GetUTCdate())
DECLARE @errorCode int
DECLARE @errorString nvarchar(1024)
SET @errorcode = 0
SET @errorstring = 'Succeeded.'
declare @alertTypeId int = 0
IF @NewState <> 'enable' and @newState <> 'disable'
BEGIN
	SET @errorstring	='Error. Invalid parameter '+@NewState+' passed. Value for first parameter must be enable or disable'
	SET @errorCode = 1
	GOTO cleanup
END
select @alertTypeId = id from NTAlertType
where name=@AlertTypeParam
if @alertTypeId=0
begin
	SET @errorstring	='Error. Invalid alert type name ['+@AlertTypeParam+'] passed. Please specify valid alert type.'
	SET @errorCode = 1
	GOTO cleanup
end
BEGIN TRY
	if (@newState = 'disable')
	begin
		-- If parameter is disabled and there are notification rules of alert type 25, we will not allow.
		declare @notificationName nvarchar(max) = ''
		select @notificationName=notificationName from NTNotificationRule  WITH (READUNCOMMITTED)
		where alertTypeId=@alertTypeId and revision=1
		and notifType<>2048
		if len(@notificationName)>0
		begin
			SET @errorstring	='Error. Notification rule ['+@notificationName+'] must be deleted before disabling alert type'
			SET @errorCode = 1
			GOTO cleanup
		end
	end
	BEGIN TRAN
	if (@newState = 'disable')
	BEGIN
		Update NTalertType
		set actionsAllowed = 8
		where id = @alertTypeId
	end
	else
	begin
		Update NTalertType
		set actionsAllowed = 7
		where id = @alertTypeId
		-- So that template is updated for this alert type.
		exec dbo.br_ntpopulatealerttemplate
	end
	COMMIT TRAN
END TRY
BEGIN CATCH
BEGIN
	ROLLBACK TRAN
	SET @errorcode = ERROR_NUMBER()
	SET @errorstring = 'Procedure [' + ERROR_PROCEDURE () + '] Error Line [' + CONVERT(nvarchar(5), ERROR_LINE()) + '].' + ERROR_MESSAGE()
END
End CATCH
cleanup:
if @errorCode <> 0
    Raiserror(@errorString,
                15,  --Severity (> 10 to force DOS Error Code = 1)
                1    --State
    )
GO

IF EXISTS (select * from GxQscripts where name = 'QS_NTEnableDisableApplicationMgmtAlerts')
	delete from GxQscripts where name = 'QS_NTEnableDisableApplicationMgmtAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_NTEnableDisableApplicationMgmtAlerts')
	delete from GXDBVersions where aliasname = 'QS_NTEnableDisableApplicationMgmtAlerts'
GO

insert into GXDBVersions values(2, 'QS_NTEnableDisableApplicationMgmtAlerts',  '00000000000000000000', 'QS_NTEnableDisableApplicationMgmtAlerts', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_NTEnableDisableApplicationMgmtAlerts',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_NTEnableDisableApplicationMgmtAlerts -si ''enable|disable'' -si ''File Replication Alerts''
'
)
GO

